/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import se.datadosen.jalbum.FileListMenuListener;
import se.datadosen.jalbum.JFileMenuItem;
import se.datadosen.jalbum.Msg;

public class JFileListMenu
extends JMenu
implements ActionListener {
    private Vector files;
    private int maxFiles = 8;
    private File storeFile;
    private transient Vector fileListMenuListeners;
    private int loadedHashCode;

    public JFileListMenu() {
        this.storeFile = new File(System.getProperty("java.home"), "RecentFileList.cfg");
        this.init();
    }

    public JFileListMenu(File storeFile) {
        this.storeFile = storeFile;
        this.init();
    }

    private void init() {
        this.files = new Vector();
        Properties props = new Properties();
        try {
            String name;
            FileInputStream fis = new FileInputStream(this.storeFile);
            props.load(fis);
            fis.close();
            int i2 = 1;
            while ((name = props.getProperty("File" + i2)) != null) {
                this.files.add(new File(name));
                ++i2;
            }
            this.loadedHashCode = this.files.hashCode();
            this.rebuildMenu();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JFileListMenu.this.save();
            }
        });
    }

    public boolean save() {
        if (this.files.hashCode() == this.loadedHashCode) {
            return false;
        }
        Properties props = new Properties();
        try {
            FileOutputStream fos = new FileOutputStream(this.storeFile);
            for (int i2 = 0; i2 < this.files.size(); ++i2) {
                props.setProperty("File" + (i2 + 1), ((File)this.files.get(i2)).getAbsolutePath());
            }
            props.store(fos, "Recent file list");
            fos.close();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        return true;
    }

    public void addFile(File file) {
        this.files.remove(file);
        this.files.add(0, file);
        if (this.files.size() > this.maxFiles) {
            this.files.removeElementAt(this.maxFiles);
        }
        this.rebuildMenu();
    }

    protected void rebuildMenu() {
        JMenuItem item;
        this.removeAll();
        for (int i2 = 0; i2 < this.files.size(); ++i2) {
            File f2 = (File)this.files.get(i2);
            String view = f2.getAbsolutePath();
            if (f2.getName().equals("jalbum-settings.jap")) {
                view = f2.getParentFile().getAbsolutePath();
            }
            item = new JFileMenuItem(view, f2);
            if (i2 < 3) {
                item.setAccelerator(KeyStroke.getKeyStroke(49 + i2, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }
            item.addActionListener(this);
            this.add(item);
        }
        if (this.files.size() > 0) {
            item = new JMenuItem("<< " + Msg.getString("ui.clearList") + " >>");
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    JFileListMenu.this.files.removeAllElements();
                    JFileListMenu.this.rebuildMenu();
                }
            });
            this.add(item);
        }
    }

    public void actionPerformed(ActionEvent e2) {
        this.fireFileSelected(e2);
    }

    public synchronized void removeFileListMenuListener(FileListMenuListener l2) {
        if (this.fileListMenuListeners != null && this.fileListMenuListeners.contains(l2)) {
            Vector v2 = (Vector)this.fileListMenuListeners.clone();
            v2.removeElement(l2);
            this.fileListMenuListeners = v2;
        }
    }

    public synchronized void addFileListMenuListener(FileListMenuListener l2) {
        Vector v2;
        Vector vector = v2 = this.fileListMenuListeners == null ? new Vector(2) : (Vector)this.fileListMenuListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.fileListMenuListeners = v2;
        }
    }

    protected void fireFileSelected(ActionEvent e2) {
        if (this.fileListMenuListeners != null) {
            Vector listeners = this.fileListMenuListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((FileListMenuListener)listeners.elementAt(i2)).fileSelected(e2);
            }
        }
    }
}

