/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Point;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import se.datadosen.dnd.AbstractTreeTransferHandler;
import se.datadosen.jalbum.RemoteFSNode;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.util.IO;

public class RemoteFSTreeTransferHandler
extends AbstractTreeTransferHandler {
    private UploadBean uploadBean;

    public RemoteFSTreeTransferHandler(JTree tree, UploadBean uploadBean, int action) {
        super(tree, action, true);
        this.uploadBean = uploadBean;
    }

    public boolean canPerformAction(JTree target, DefaultMutableTreeNode draggedNode, int action, Point location) {
        TreePath pathTarget = target.getPathForLocation(location.x, location.y);
        if (pathTarget == null) {
            target.setSelectionPath(null);
            return false;
        }
        target.setSelectionPath(pathTarget);
        if (action == 2) {
            RemoteFSNode targetNode = (RemoteFSNode)pathTarget.getLastPathComponent();
            RemoteFSNode parentNode = (RemoteFSNode)pathTarget.getLastPathComponent();
            return !targetNode.isAlbum() && !draggedNode.isRoot() && parentNode != draggedNode.getParent() && !draggedNode.isNodeDescendant(parentNode);
        }
        return false;
    }

    public boolean executeDrop(JTree target, DefaultMutableTreeNode dragged, DefaultMutableTreeNode newParent, int action) {
        RemoteFSNode draggedNode = (RemoteFSNode)dragged;
        RemoteFSNode newParentNode = (RemoteFSNode)newParent;
        if (action == 2) {
            String from = draggedNode.remotePath();
            String to = IO.combinePaths(newParentNode.remotePath(), draggedNode.getRemoteName());
            try {
                this.uploadBean.getRemoteFSBean().rename(from, to);
                draggedNode.removeFromParent();
                if (newParentNode.areChildrenDefined()) {
                    ((DefaultTreeModel)target.getModel()).insertNodeInto(draggedNode, newParentNode, newParentNode.getChildCount());
                }
                TreePath treePath = new TreePath(draggedNode.getPath());
                target.scrollPathToVisible(treePath);
                target.setSelectionPath(treePath);
                return true;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return false;
    }
}

