/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.IOException;
import java.io.Reader;

final class CharBuffer {
    char[] buf;
    int length = 0;

    public CharBuffer(int length) {
        this.buf = new char[length + 1];
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int fill(Reader in) throws IOException {
        int d2;
        while (this.length < this.buf.length && (d2 = in.read()) != -1) {
            this.buf[this.length] = (char)d2;
            ++this.length;
        }
        return this.length;
    }

    public void drop(int n2) {
        for (int i2 = n2; i2 < this.buf.length; ++i2) {
            this.buf[i2 - n2] = this.buf[i2];
        }
        this.length -= n2;
    }

    public char pop() {
        char ret = this.buf[0];
        this.drop(1);
        return ret;
    }

    public boolean startsWith(char[] match) {
        for (int i2 = 0; i2 <= this.length && i2 < match.length; ++i2) {
            if (this.buf[i2] == match[i2]) continue;
            return false;
        }
        return true;
    }
}

