/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.Config;
import se.datadosen.tags.Element;
import se.datadosen.tags.Elements;
import se.datadosen.util.IO;

public class FileFilters {
    private static Set classicTypes = new HashSet();
    private static Set imageIOTypes = new HashSet();
    private static Map otherTypes;
    private static final String FOLDER_KEY = "folder";

    public static void saveJPEG(BufferedImage img, File file, AlbumBean engine) throws IOException, ImageFormatException {
        FileFilters.saveJPEG(img, file, engine, null);
    }

    public static void saveJPEG(BufferedImage img, File file, AlbumBean engine, IIOMetadata metaData) throws IOException, ImageFormatException {
        if (file.exists()) {
            file.delete();
        }
        Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("jpeg");
        while (it.hasNext()) {
            ImageWriter iw = it.next();
            ImageWriteParam param = iw.getDefaultWriteParam();
            if (engine.isProgressiveMode() && !param.canWriteProgressive() && it.hasNext()) continue;
            param.setCompressionMode(2);
            param.setCompressionQuality((float)engine.getQualityPercent() / 100.0f);
            if (engine.isProgressiveMode() && param.canWriteProgressive()) {
                param.setProgressiveMode(1);
            }
            ImageOutputStream ios = ImageIO.createImageOutputStream(file);
            iw.setOutput(ios);
            iw.write(null, new IIOImage(img, null, metaData), param);
            iw.dispose();
            ios.close();
            break;
        }
    }

    public static boolean isFileSupported(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileFilters.getExtensionOf(file);
        return classicTypes.contains(extension) || imageIOTypes.contains(extension);
    }

    public static boolean isMediaFile(File file) {
        boolean mediaFile = FileFilters.hasIcon(file);
        if (file.isDirectory()) {
            return false;
        }
        return mediaFile;
    }

    public static boolean hasIcon(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (FileFilters.isFileSupported(file)) {
            return false;
        }
        String ext = FileFilters.getExtensionOf(file);
        return FileFilters.getOtherTypes().containsKey(ext);
    }

    public static File getIconFor(File f2) {
        return FileFilters.getIconFor(f2, null);
    }

    public static File getIconFor(File f2, AlbumBean engine) {
        File iconFile;
        Config c2 = Config.getConfig();
        String ext = f2.isDirectory() ? FOLDER_KEY : FileFilters.getExtensionOf(f2);
        FileType ft = (FileType)FileFilters.getOtherTypes().get(ext);
        if (ft == null) {
            return null;
        }
        if (engine != null && (iconFile = new File(engine.srcResDir, ft.icon)).exists()) {
            return iconFile;
        }
        return new File(c2.progDir, "res/" + ft.icon);
    }

    public static String getExtensionOf(File f2) {
        if (f2 == null) {
            throw new RuntimeException("File can't be null!");
        }
        String name = f2.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            dotIndex = name.length() - 1;
        }
        return name.substring(dotIndex + 1).toLowerCase();
    }

    private static BufferedImage ensureBuffered(Image img, int iw, int ih) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bi2 = new BufferedImage(iw, ih, 1);
        Graphics2D g2 = bi2.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        return bi2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage loadImage(File file, AlbumBean engine) throws IOException, ImageFormatException {
        if (!FileFilters.getExtensionOf(file).equals("thm") && !FileFilters.isFileSupported(file)) {
            file = FileFilters.getIconFor(file, engine);
        }
        if (engine.isClassicReaders() && classicTypes.contains(FileFilters.getExtensionOf(file))) {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(file));
                JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
                BufferedImage img = decoder.decodeAsBufferedImage();
                JPEGDecodeParam p2 = decoder.getJPEGDecodeParam();
                in.close();
                if (p2.getEncodedColorID() != 3 && p2.getEncodedColorID() != 2) {
                    throw new ImageFormatException("Image must be stored in RGB color model");
                }
                BufferedImage bufferedImage = img;
                return bufferedImage;
            }
            catch (Exception ex) {
                ImageIcon tmpIcon = new ImageIcon(file.getAbsolutePath());
                Image tmpImg = tmpIcon.getImage();
                BufferedImage bufferedImage = FileFilters.ensureBuffered(tmpImg, tmpIcon.getIconWidth(), tmpIcon.getIconHeight());
                return bufferedImage;
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        ImageReader reader = null;
        ImageInputStream stream = null;
        try {
            BufferedImage bi2;
            stream = ImageIO.createImageInputStream(file);
            reader = ImageIO.getImageReaders(stream).next();
            reader.setInput(stream, true, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Iterator<ImageTypeSpecifier> i2 = reader.getImageTypes(0);
            while (i2.hasNext()) {
                ImageTypeSpecifier type = i2.next();
                if (!type.getColorModel().getColorSpace().isCS_sRGB()) continue;
                param.setDestinationType(type);
                break;
            }
            BufferedImage bufferedImage = bi2 = reader.read(0, param);
            return bufferedImage;
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    static Map getOtherTypes() {
        if (otherTypes != null) {
            return otherTypes;
        }
        otherTypes = new HashMap();
        try {
            Element type;
            Config c2 = Config.getConfig();
            String content = IO.readTextFile(new File(c2.progDir, "system/filetypes.xml"));
            String docrest = content = Elements.stripComments(content);
            Element root = Elements.getElementByName("filetypes", docrest, false);
            if (root != null) {
                otherTypes.put(FOLDER_KEY, new FileType("Folder", root.getAttribute("foldericon", "folder.gif")));
            }
            while ((type = Elements.getElementByName("type", docrest, false)) != null) {
                Element ext;
                FileType ft = new FileType(type.getAttribute("name"), type.getAttribute("icon"));
                String extrest = type.getContent();
                while ((ext = Elements.getElementByName("ext", extrest, false)) != null) {
                    otherTypes.put(ext.getContent(), ft);
                    extrest = ext.getPostElement();
                }
                docrest = type.getPostElement();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return otherTypes;
    }

    static {
        classicTypes.add("jpg");
        classicTypes.add("jpeg");
        classicTypes.add("jpe");
        classicTypes.add("gif");
        classicTypes.add("png");
        String[] types = ImageIO.getReaderFormatNames();
        for (int i2 = 0; i2 < types.length; ++i2) {
            imageIOTypes.add(types[i2]);
        }
    }

    public static class FileType {
        String name;
        String icon;

        public FileType(String name, String iconName) {
            this.name = name;
            this.icon = iconName;
        }

        public String toString() {
            return "{Name=" + this.name + " icon=" + this.icon + "}";
        }
    }
}

