/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.EvalError;
import bsh.Token;

public class ParseException
extends EvalError {
    String sourceFile = "<unknown>";
    protected boolean specialConstructor = false;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public void setErrorSourceFile(String string) {
        this.sourceFile = string;
    }

    public String getErrorSourceFile() {
        return this.sourceFile;
    }

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        this();
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
        this("");
        this.specialConstructor = false;
    }

    public ParseException(String string) {
        super(string, null, null);
    }

    public String getMessage() {
        return this.getMessage(false);
    }

    public String getMessage(boolean bl2) {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String string = "";
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.expectedTokenSequences.length) {
            if (n2 < this.expectedTokenSequences[n3].length) {
                n2 = this.expectedTokenSequences[n3].length;
            }
            int n4 = 0;
            while (n4 < this.expectedTokenSequences[n3].length) {
                string = string + this.tokenImage[this.expectedTokenSequences[n3][n4]] + " ";
                ++n4;
            }
            if (this.expectedTokenSequences[n3][this.expectedTokenSequences[n3].length - 1] != 0) {
                string = string + "...";
            }
            string = string + this.eol + "    ";
            ++n3;
        }
        String string2 = "In file: " + this.sourceFile + " Encountered \"";
        Token token = this.currentToken.next;
        int n5 = 0;
        while (n5 < n2) {
            if (n5 != 0) {
                string2 = string2 + " ";
            }
            if (token.kind == 0) {
                string2 = string2 + this.tokenImage[0];
                break;
            }
            string2 = string2 + this.add_escapes(token.image);
            token = token.next;
            ++n5;
        }
        string2 = string2 + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn + "." + this.eol;
        if (bl2) {
            string2 = this.expectedTokenSequences.length == 1 ? string2 + "Was expecting:" + this.eol + "    " : string2 + "Was expecting one of:" + this.eol + "    ";
            string2 = string2 + string;
        }
        return string2;
    }

    protected String add_escapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            switch (string.charAt(n2)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    char c2 = string.charAt(n2);
                    if (c2 < ' ' || c2 > '~') {
                        String string2 = "0000" + Integer.toString(c2, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        break;
                    }
                    stringBuffer.append(c2);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public int getErrorLineNumber() {
        return this.currentToken.next.beginLine;
    }

    public String getErrorText() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.expectedTokenSequences.length) {
            if (n2 < this.expectedTokenSequences[n3].length) {
                n2 = this.expectedTokenSequences[n3].length;
            }
            ++n3;
        }
        String string = "";
        Token token = this.currentToken.next;
        int n4 = 0;
        while (n4 < n2) {
            if (n4 != 0) {
                string = string + " ";
            }
            if (token.kind == 0) {
                string = string + this.tokenImage[0];
                break;
            }
            string = string + this.add_escapes(token.image);
            token = token.next;
            ++n4;
        }
        return string;
    }

    public String toString() {
        return this.getMessage();
    }
}

