/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.Rational;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.TagDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class Directory
implements Serializable {
    protected final HashMap _tagMap = new HashMap();
    protected TagDescriptor _descriptor;
    protected final List _definedTagList = new ArrayList();
    private List _errorList;

    public abstract String getName();

    protected abstract HashMap getTagNameMap();

    public boolean containsTag(int tagType) {
        return this._tagMap.containsKey(new Integer(tagType));
    }

    public Iterator getTagIterator() {
        return this._definedTagList.iterator();
    }

    public int getTagCount() {
        return this._definedTagList.size();
    }

    public void setDescriptor(TagDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("cannot set a null descriptor");
        }
        this._descriptor = descriptor;
    }

    public void addError(String message) {
        if (this._errorList == null) {
            this._errorList = new ArrayList();
        }
        this._errorList.add(message);
    }

    public boolean hasErrors() {
        return this._errorList != null && this._errorList.size() > 0;
    }

    public Iterator getErrors() {
        return this._errorList.iterator();
    }

    public int getErrorCount() {
        return this._errorList.size();
    }

    public void setInt(int tagType, int value) {
        this.setObject(tagType, new Integer(value));
    }

    public void setDouble(int tagType, double value) {
        this.setObject(tagType, new Double(value));
    }

    public void setFloat(int tagType, float value) {
        this.setObject(tagType, new Float(value));
    }

    public void setString(int tagType, String value) {
        this.setObject(tagType, value);
    }

    public void setBoolean(int tagType, boolean value) {
        this.setObject(tagType, new Boolean(value));
    }

    public void setLong(int tagType, long value) {
        this.setObject(tagType, new Long(value));
    }

    public void setDate(int tagType, Date value) {
        this.setObject(tagType, value);
    }

    public void setRational(int tagType, Rational rational) {
        this.setObject(tagType, rational);
    }

    public void setRationalArray(int tagType, Rational[] rationals) {
        this.setObjectArray(tagType, rationals);
    }

    public void setIntArray(int tagType, int[] ints) {
        this.setObjectArray(tagType, ints);
    }

    public void setByteArray(int tagType, byte[] bytes) {
        this.setObjectArray(tagType, bytes);
    }

    public void setStringArray(int tagType, String[] strings) {
        this.setObjectArray(tagType, strings);
    }

    public void setObject(int tagType, Object value) {
        if (value == null) {
            throw new NullPointerException("cannot set a null object");
        }
        Integer key = new Integer(tagType);
        if (!this._tagMap.containsKey(key)) {
            this._definedTagList.add(new Tag(tagType, this));
        }
        this._tagMap.put(key, value);
    }

    public void setObjectArray(int tagType, Object array) {
        this.setObject(tagType, array);
    }

    public int getInt(int tagType) throws MetadataException {
        int[] ints;
        Object o2 = this.getObject(tagType);
        if (o2 == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o2 instanceof String) {
            try {
                return Integer.parseInt((String)o2);
            }
            catch (NumberFormatException nfe) {
                String s2 = (String)o2;
                byte[] bytes = s2.getBytes();
                long val = 0L;
                for (int i2 = 0; i2 < bytes.length; ++i2) {
                    val <<= 8;
                    val += (long)bytes[i2];
                }
                return (int)val;
            }
        }
        if (o2 instanceof Number) {
            return ((Number)o2).intValue();
        }
        if (o2 instanceof Rational[]) {
            Rational[] rationals = (Rational[])o2;
            if (rationals.length == 1) {
                return rationals[0].intValue();
            }
        } else if (o2 instanceof byte[]) {
            byte[] bytes = (byte[])o2;
            if (bytes.length == 1) {
                return bytes[0];
            }
        } else if (o2 instanceof int[] && (ints = (int[])o2).length == 1) {
            return ints[0];
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to int.  It is of type '" + o2.getClass() + "'.");
    }

    public String[] getStringArray(int tagType) throws MetadataException {
        Object o2 = this.getObject(tagType);
        if (o2 == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o2 instanceof String[]) {
            return (String[])o2;
        }
        if (o2 instanceof String) {
            String[] strings = new String[]{(String)o2};
            return strings;
        }
        if (o2 instanceof int[]) {
            int[] ints = (int[])o2;
            String[] strings = new String[ints.length];
            for (int i2 = 0; i2 < strings.length; ++i2) {
                strings[i2] = Integer.toString(ints[i2]);
            }
            return strings;
        }
        if (o2 instanceof byte[]) {
            byte[] bytes = (byte[])o2;
            String[] strings = new String[bytes.length];
            for (int i3 = 0; i3 < strings.length; ++i3) {
                strings[i3] = Byte.toString(bytes[i3]);
            }
            return strings;
        }
        if (o2 instanceof Rational[]) {
            Rational[] rationals = (Rational[])o2;
            String[] strings = new String[rationals.length];
            for (int i4 = 0; i4 < strings.length; ++i4) {
                strings[i4] = rationals[i4].toSimpleString(false);
            }
            return strings;
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to an String array.  It is of type '" + o2.getClass() + "'.");
    }

    public int[] getIntArray(int tagType) throws MetadataException {
        Object o2 = this.getObject(tagType);
        if (o2 == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o2 instanceof Rational[]) {
            Rational[] rationals = (Rational[])o2;
            int[] ints = new int[rationals.length];
            for (int i2 = 0; i2 < ints.length; ++i2) {
                ints[i2] = rationals[i2].intValue();
            }
            return ints;
        }
        if (o2 instanceof int[]) {
            return (int[])o2;
        }
        if (o2 instanceof byte[]) {
            byte[] bytes = (byte[])o2;
            int[] ints = new int[bytes.length];
            for (int i3 = 0; i3 < bytes.length; ++i3) {
                int b2;
                ints[i3] = b2 = bytes[i3];
            }
            return ints;
        }
        if (o2 instanceof String) {
            String str = (String)o2;
            int[] ints = new int[str.length()];
            for (int i4 = 0; i4 < str.length(); ++i4) {
                ints[i4] = str.charAt(i4);
            }
            return ints;
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to an int array.  It is of type '" + o2.getClass() + "'.");
    }

    public byte[] getByteArray(int tagType) throws MetadataException {
        Object o2 = this.getObject(tagType);
        if (o2 == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o2 instanceof Rational[]) {
            Rational[] rationals = (Rational[])o2;
            byte[] bytes = new byte[rationals.length];
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                bytes[i2] = rationals[i2].byteValue();
            }
            return bytes;
        }
        if (o2 instanceof byte[]) {
            return (byte[])o2;
        }
        if (o2 instanceof int[]) {
            int[] ints = (int[])o2;
            byte[] bytes = new byte[ints.length];
            for (int i3 = 0; i3 < ints.length; ++i3) {
                bytes[i3] = (byte)ints[i3];
            }
            return bytes;
        }
        if (o2 instanceof String) {
            String str = (String)o2;
            byte[] bytes = new byte[str.length()];
            for (int i4 = 0; i4 < str.length(); ++i4) {
                bytes[i4] = (byte)str.charAt(i4);
            }
            return bytes;
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a byte array.  It is of type '" + o2.getClass() + "'.");
    }

    public double getDouble(int tagType) throws MetadataException {
        Object o2 = this.getObject(tagType);
        if (o2 == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o2 instanceof String) {
            try {
                return Double.parseDouble((String)o2);
            }
            catch (NumberFormatException nfe) {
                throw new MetadataException("unable to parse string " + o2 + " as a double", nfe);
            }
        }
        if (o2 instanceof Number) {
            return ((Number)o2).doubleValue();
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a double.  It is of type '" + o2.getClass() + "'.");
    }

    public float getFloat(int tagType) throws MetadataException {
        Object o2 = this.getObject(tagType);
        if (o2 == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o2 instanceof String) {
            try {
                return Float.parseFloat((String)o2);
            }
            catch (NumberFormatException nfe) {
                throw new MetadataException("unable to parse string " + o2 + " as a float", nfe);
            }
        }
        if (o2 instanceof Number) {
            return ((Number)o2).floatValue();
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a float.  It is of type '" + o2.getClass() + "'.");
    }

    public long getLong(int tagType) throws MetadataException {
        Object o2 = this.getObject(tagType);
        if (o2 == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o2 instanceof String) {
            try {
                return Long.parseLong((String)o2);
            }
            catch (NumberFormatException nfe) {
                throw new MetadataException("unable to parse string " + o2 + " as a long", nfe);
            }
        }
        if (o2 instanceof Number) {
            return ((Number)o2).longValue();
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a long.  It is of type '" + o2.getClass() + "'.");
    }

    public boolean getBoolean(int tagType) throws MetadataException {
        Object o2 = this.getObject(tagType);
        if (o2 == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o2 instanceof Boolean) {
            return (Boolean)o2;
        }
        if (o2 instanceof String) {
            try {
                return Boolean.getBoolean((String)o2);
            }
            catch (NumberFormatException nfe) {
                throw new MetadataException("unable to parse string " + o2 + " as a boolean", nfe);
            }
        }
        if (o2 instanceof Number) {
            return ((Number)o2).doubleValue() != 0.0;
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a boolean.  It is of type '" + o2.getClass() + "'.");
    }

    public Date getDate(int tagType) throws MetadataException {
        Object o2 = this.getObject(tagType);
        if (o2 == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o2 instanceof Date) {
            return (Date)o2;
        }
        if (o2 instanceof String) {
            String[] datePatterns = new String[]{"yyyy:MM:dd HH:mm:ss", "yyyy:MM:dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm"};
            String dateString = (String)o2;
            for (int i2 = 0; i2 < datePatterns.length; ++i2) {
                try {
                    SimpleDateFormat parser = new SimpleDateFormat(datePatterns[i2]);
                    return parser.parse(dateString);
                }
                catch (ParseException ex) {
                    continue;
                }
            }
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a java.util.Date.  It is of type '" + o2.getClass() + "'.");
    }

    public Rational getRational(int tagType) throws MetadataException {
        Object o2 = this.getObject(tagType);
        if (o2 == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o2 instanceof Rational) {
            return (Rational)o2;
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a Rational.  It is of type '" + o2.getClass() + "'.");
    }

    public Rational[] getRationalArray(int tagType) throws MetadataException {
        Object o2 = this.getObject(tagType);
        if (o2 == null) {
            throw new MetadataException("Tag " + this.getTagName(tagType) + " has not been set -- check using containsTag() first");
        }
        if (o2 instanceof Rational[]) {
            return (Rational[])o2;
        }
        throw new MetadataException("Tag '" + tagType + "' cannot be cast to a Rational array.  It is of type '" + o2.getClass() + "'.");
    }

    public String getString(int tagType) {
        Object o2 = this.getObject(tagType);
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Rational) {
            return ((Rational)o2).toSimpleString(true);
        }
        if (o2.getClass().isArray()) {
            int arrayLength = Array.getLength(o2);
            boolean isObjectArray = o2.getClass().toString().startsWith("class [L");
            StringBuffer sbuffer = new StringBuffer();
            for (int i2 = 0; i2 < arrayLength; ++i2) {
                if (i2 != 0) {
                    sbuffer.append(' ');
                }
                if (isObjectArray) {
                    sbuffer.append(Array.get(o2, i2).toString());
                    continue;
                }
                sbuffer.append(Array.getInt(o2, i2));
            }
            return sbuffer.toString();
        }
        return o2.toString();
    }

    public Object getObject(int tagType) {
        return this._tagMap.get(new Integer(tagType));
    }

    public String getTagName(int tagType) {
        Integer key = new Integer(tagType);
        HashMap nameMap = this.getTagNameMap();
        if (!nameMap.containsKey(key)) {
            String hex = Integer.toHexString(tagType);
            while (hex.length() < 4) {
                hex = "0" + hex;
            }
            return "Unknown tag (0x" + hex + ")";
        }
        return (String)nameMap.get(key);
    }

    public String getDescription(int tagType) throws MetadataException {
        if (this._descriptor == null) {
            throw new MetadataException("a descriptor must be set using setDescriptor(...) before descriptions can be provided");
        }
        return this._descriptor.getDescription(tagType);
    }
}

