/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.KeyPairGenDSA;
import com.jcraft.jsch.Util;

public class KeyPairDSA
extends KeyPair {
    private byte[] P_array;
    private byte[] Q_array;
    private byte[] G_array;
    private byte[] pub_array;
    private byte[] prv_array;
    private int key_size = 1024;
    private static final byte[] begin = "-----BEGIN DSA PRIVATE KEY-----".getBytes();
    private static final byte[] end = "-----END DSA PRIVATE KEY-----".getBytes();
    private static final byte[] sshdss = "ssh-dss".getBytes();

    public KeyPairDSA(JSch jSch) {
        super(jSch);
    }

    void generate(int n2) throws JSchException {
        this.key_size = n2;
        try {
            Class<?> clazz = Class.forName(this.jsch.getConfig("keypairgen.dsa"));
            KeyPairGenDSA keyPairGenDSA = (KeyPairGenDSA)clazz.newInstance();
            keyPairGenDSA.init(n2);
            this.P_array = keyPairGenDSA.getP();
            this.Q_array = keyPairGenDSA.getQ();
            this.G_array = keyPairGenDSA.getG();
            this.pub_array = keyPairGenDSA.getY();
            this.prv_array = keyPairGenDSA.getX();
            keyPairGenDSA = null;
        }
        catch (Exception exception) {
            if (exception instanceof Throwable) {
                throw new JSchException(exception.toString(), exception);
            }
            throw new JSchException(exception.toString());
        }
    }

    byte[] getBegin() {
        return begin;
    }

    byte[] getEnd() {
        return end;
    }

    byte[] getPrivateKey() {
        int n2 = 1 + this.countLength(1) + 1 + 1 + this.countLength(this.P_array.length) + this.P_array.length + 1 + this.countLength(this.Q_array.length) + this.Q_array.length + 1 + this.countLength(this.G_array.length) + this.G_array.length + 1 + this.countLength(this.pub_array.length) + this.pub_array.length + 1 + this.countLength(this.prv_array.length) + this.prv_array.length;
        int n3 = 1 + this.countLength(n2) + n2;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        n4 = this.writeSEQUENCE(byArray, n4, n2);
        n4 = this.writeINTEGER(byArray, n4, new byte[1]);
        n4 = this.writeINTEGER(byArray, n4, this.P_array);
        n4 = this.writeINTEGER(byArray, n4, this.Q_array);
        n4 = this.writeINTEGER(byArray, n4, this.G_array);
        n4 = this.writeINTEGER(byArray, n4, this.pub_array);
        n4 = this.writeINTEGER(byArray, n4, this.prv_array);
        return byArray;
    }

    boolean parse(byte[] byArray) {
        try {
            int n2;
            if (this.vendor == 1) {
                if (byArray[0] != 48) {
                    Buffer buffer = new Buffer(byArray);
                    buffer.getInt();
                    this.P_array = buffer.getMPIntBits();
                    this.G_array = buffer.getMPIntBits();
                    this.Q_array = buffer.getMPIntBits();
                    this.pub_array = buffer.getMPIntBits();
                    this.prv_array = buffer.getMPIntBits();
                    return true;
                }
                return false;
            }
            int n3 = 0;
            int n4 = 0;
            if (byArray[n3] != 48) {
                return false;
            }
            int n5 = ++n3;
            ++n3;
            n4 = byArray[n5] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            if (byArray[n3] != 2) {
                return false;
            }
            int n6 = ++n3;
            ++n3;
            n4 = byArray[n6] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            n3 += n4;
            int n7 = ++n3;
            ++n3;
            n4 = byArray[n7] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.P_array = new byte[n4];
            System.arraycopy(byArray, n3, this.P_array, 0, n4);
            n3 += n4;
            int n8 = ++n3;
            ++n3;
            n4 = byArray[n8] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.Q_array = new byte[n4];
            System.arraycopy(byArray, n3, this.Q_array, 0, n4);
            n3 += n4;
            int n9 = ++n3;
            ++n3;
            n4 = byArray[n9] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.G_array = new byte[n4];
            System.arraycopy(byArray, n3, this.G_array, 0, n4);
            n3 += n4;
            int n10 = ++n3;
            ++n3;
            n4 = byArray[n10] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.pub_array = new byte[n4];
            System.arraycopy(byArray, n3, this.pub_array, 0, n4);
            n3 += n4;
            int n11 = ++n3;
            ++n3;
            n4 = byArray[n11] & 0xFF;
            if ((n4 & 0x80) != 0) {
                n2 = n4 & 0x7F;
                n4 = 0;
                while (n2-- > 0) {
                    n4 = (n4 << 8) + (byArray[n3++] & 0xFF);
                }
            }
            this.prv_array = new byte[n4];
            System.arraycopy(byArray, n3, this.prv_array, 0, n4);
            n3 += n4;
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public byte[] getPublicKeyBlob() {
        byte[] byArray = super.getPublicKeyBlob();
        if (byArray != null) {
            return byArray;
        }
        if (this.P_array == null) {
            return null;
        }
        Buffer buffer = new Buffer(sshdss.length + 4 + this.P_array.length + 4 + this.Q_array.length + 4 + this.G_array.length + 4 + this.pub_array.length + 4);
        buffer.putString(sshdss);
        buffer.putString(this.P_array);
        buffer.putString(this.Q_array);
        buffer.putString(this.G_array);
        buffer.putString(this.pub_array);
        return buffer.buffer;
    }

    byte[] getKeyTypeName() {
        return sshdss;
    }

    public int getKeyType() {
        return 1;
    }

    public int getKeySize() {
        return this.key_size;
    }

    public void dispose() {
        super.dispose();
        Util.bzero(this.prv_array);
    }
}

