/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import se.datadosen.util.IO;
import se.datadosen.util.Replacer;

public class BrowserLauncher {
    private static int jvm;
    private static Object browser;
    private static boolean loadedWithoutErrors;
    private static Class mrjFileUtilsClass;
    private static Class mrjOSTypeClass;
    private static Class aeDescClass;
    private static Constructor aeTargetConstructor;
    private static Constructor appleEventConstructor;
    private static Constructor aeDescConstructor;
    private static Method findFolder;
    private static Method getFileCreator;
    private static Method getFileType;
    private static Method openURL;
    private static Method makeOSType;
    private static Method putParameter;
    private static Method sendNoReply;
    private static Object kSystemFolderType;
    private static Integer keyDirectObject;
    private static Integer kAutoGenerateReturnID;
    private static Integer kAnyTransactionID;
    private static Object linkage;
    private static final String JDirect_MacOSX = "/System/Library/Frameworks/Carbon.framework/Frameworks/HIToolbox.framework/HIToolbox";
    private static final int MRJ_2_0 = 0;
    private static final int MRJ_2_1 = 1;
    private static final int MRJ_3_0 = 3;
    private static final int MRJ_3_1 = 4;
    private static final int WINDOWS_NT = 5;
    private static final int WINDOWS_9x = 6;
    private static final int WINDOWS_XP = 7;
    private static final int OTHER = -1;
    private static final String FINDER_TYPE = "FNDR";
    private static final String FINDER_CREATOR = "MACS";
    private static final String GURL_EVENT = "GURL";
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "'openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")'";
    private static String errorMessage;
    static /* synthetic */ Class class$java$lang$String;

    private BrowserLauncher() {
    }

    private static boolean loadClasses() {
        switch (jvm) {
            case 4: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    openURL = mrjFileUtilsClass.getDeclaredMethod("openURL", class$java$lang$String == null ? (class$java$lang$String = BrowserLauncher.class$("java.lang.String")) : class$java$lang$String);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    errorMessage = cnfe.getMessage();
                    System.err.println("BrowserLauncher: " + cnfe);
                    return false;
                }
                catch (NoSuchMethodException nsme) {
                    errorMessage = nsme.getMessage();
                    System.err.println("BrowserLauncher: " + nsme);
                    return false;
                }
            }
        }
        return true;
    }

    private static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 4: {
                browser = "";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                browser = "rundll32 url.dll,FileProtocolHandler";
                break;
            }
            default: {
                browser = "firefox";
            }
        }
        return browser;
    }

    private static String fileURL(File path) {
        String absolute = path.getAbsolutePath().replace('\\', '/');
        String url = absolute.startsWith("/") ? "file://" + absolute : "file:///" + absolute;
        return url;
    }

    public static void openLocal(File file) throws IOException {
        BrowserLauncher.openURL(file.getAbsolutePath(), true, file.isDirectory());
    }

    public static void openURL(String url) throws IOException {
        BrowserLauncher.openURL(url, false, false);
    }

    private static void openURL(String url, boolean isLocal, boolean isDirectory) throws IOException {
        if (!loadedWithoutErrors) {
            throw new IOException("Exception in finding browser: " + errorMessage);
        }
        Object browser = BrowserLauncher.locateBrowser();
        if (browser == null) {
            throw new IOException("Unable to locate browser: " + errorMessage);
        }
        switch (jvm) {
            case 4: {
                try {
                    openURL.invoke(null, isLocal ? "file://" + IO.urlEncode(url) : url);
                    break;
                }
                catch (InvocationTargetException ite) {
                    throw new IOException("InvocationTargetException while calling openURL: " + ite.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new IOException("IllegalAccessException while calling openURL: " + iae.getMessage());
                }
            }
            case 5: 
            case 6: {
                Process process = Runtime.getRuntime().exec(browser + " " + url);
                try {
                    process.waitFor();
                    process.exitValue();
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            case 7: {
                Process process = Runtime.getRuntime().exec(browser + " \"" + url + "\"");
                try {
                    process.waitFor();
                    process.exitValue();
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            case -1: {
                String cmd;
                String string = cmd = isDirectory ? System.getProperty("folder.cmd") : System.getProperty("browser.cmd");
                if (cmd == null) {
                    cmd = System.getProperty("browser.cmd");
                }
                if (cmd != null) {
                    String arg;
                    Replacer replacer = new Replacer();
                    replacer.add("$url", url);
                    replacer.add("@url", url);
                    LinkedList<String> arglist = new LinkedList<String>();
                    arglist.addLast(cmd);
                    int i2 = 0;
                    while ((arg = System.getProperty("browser.arg" + i2)) != null) {
                        arglist.addLast(arg);
                        ++i2;
                    }
                    String[] args = new String[arglist.size()];
                    for (int i3 = 0; i3 < arglist.size(); ++i3) {
                        args[i3] = replacer.replace((String)arglist.get(i3));
                    }
                    Process process = Runtime.getRuntime().exec(args);
                    break;
                }
                Process process = Runtime.getRuntime().exec(new String[]{"firefox", url});
                try {
                    int exitCode = process.waitFor();
                    if (exitCode == 0) break;
                    Runtime.getRuntime().exec(new String[]{(String)browser, url});
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            default: {
                Runtime.getRuntime().exec(new String[]{(String)browser, url});
            }
        }
    }

    private static native int ICStart(int[] var0, int var1);

    private static native int ICStop(int[] var0);

    private static native int ICLaunchURL(int var0, byte[] var1, byte[] var2, int var3, int[] var4, int[] var5);

    public static void main(String[] args) throws Exception {
        BrowserLauncher.openURL("http://www.fyvie.net/index.html");
    }

    static {
        loadedWithoutErrors = true;
        String osName = System.getProperty("os.name");
        jvm = osName.startsWith("Mac OS") ? 4 : (osName.startsWith("Windows") ? (osName.indexOf("9") != -1 ? 6 : (osName.indexOf("XP") != -1 ? 7 : 5)) : -1);
        if (loadedWithoutErrors) {
            loadedWithoutErrors = BrowserLauncher.loadClasses();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

