/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class RemoteFile {
    protected String name;
    protected Date creationDate;
    protected Date modificationDate;
    protected long size;
    private static String dateFormat1 = "MMM d HH:mm";
    private static String dateFormat2 = "MMM d yyyy";

    protected RemoteFile() {
    }

    public abstract boolean isFile();

    public abstract boolean isDirectory();

    public abstract boolean isLink();

    public String getName() {
        return this.name;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public long size() {
        return this.size;
    }

    protected Date parseDate(String date) {
        try {
            if (date.indexOf(":") >= 0) {
                SimpleDateFormat df2 = new SimpleDateFormat(dateFormat1);
                Date d2 = df2.parse(date);
                Calendar cal = Calendar.getInstance();
                int year = cal.get(1);
                cal.setTime(d2);
                cal.set(1, year);
                return cal.getTime();
            }
            SimpleDateFormat df3 = new SimpleDateFormat(dateFormat2);
            Date d3 = df3.parse(date);
            return d3;
        }
        catch (ParseException e2) {
            return new Date();
        }
    }
}

