/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.axes.AncestorContext;
import org.apache.commons.jxpath.ri.axes.AttributeContext;
import org.apache.commons.jxpath.ri.axes.ChildContext;
import org.apache.commons.jxpath.ri.axes.DescendantContext;
import org.apache.commons.jxpath.ri.axes.NamespaceContext;
import org.apache.commons.jxpath.ri.axes.ParentContext;
import org.apache.commons.jxpath.ri.axes.PrecedingOrFollowingContext;
import org.apache.commons.jxpath.ri.axes.PredicateContext;
import org.apache.commons.jxpath.ri.axes.SelfContext;
import org.apache.commons.jxpath.ri.axes.SimplePathInterpreter;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.NameAttributeTest;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.Step;
import org.apache.commons.jxpath.ri.model.NodePointer;

public abstract class Path
extends Expression {
    private Step[] steps;
    private boolean basicKnown = false;
    private boolean basic;

    public Path(Step[] steps) {
        this.steps = steps;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    public boolean computeContextDependent() {
        if (this.steps != null) {
            int i2 = 0;
            while (i2 < this.steps.length) {
                if (this.steps[i2].isContextDependent()) {
                    return true;
                }
                ++i2;
            }
        }
        return false;
    }

    public boolean isSimplePath() {
        if (!this.basicKnown) {
            this.basicKnown = true;
            this.basic = true;
            Step[] steps = this.getSteps();
            int i2 = 0;
            while (i2 < steps.length) {
                boolean accepted = false;
                if (steps[i2].getAxis() == 1 && steps[i2].getNodeTest() instanceof NodeTypeTest && ((NodeTypeTest)steps[i2].getNodeTest()).getNodeType() == 1) {
                    accepted = true;
                } else if ((steps[i2].getAxis() == 2 || steps[i2].getAxis() == 5) && steps[i2].getNodeTest() instanceof NodeNameTest && !((NodeNameTest)steps[i2].getNodeTest()).getNodeName().getName().equals("*")) {
                    accepted = true;
                }
                if (accepted) {
                    accepted = this.areBasicPredicates(steps[i2].getPredicates());
                }
                if (!accepted) {
                    this.basic = false;
                    break;
                }
                ++i2;
            }
        }
        return this.basic;
    }

    protected boolean areBasicPredicates(Expression[] predicates) {
        if (predicates != null && predicates.length != 0) {
            boolean firstIndex = true;
            int i2 = 0;
            while (i2 < predicates.length) {
                if (predicates[i2] instanceof NameAttributeTest) {
                    if (((NameAttributeTest)predicates[i2]).getNameTestExpression().isContextDependent()) {
                        return false;
                    }
                } else {
                    if (predicates[i2].isContextDependent()) {
                        return false;
                    }
                    if (!firstIndex) {
                        return false;
                    }
                    firstIndex = false;
                }
                ++i2;
            }
        }
        return true;
    }

    protected Pointer getSingleNodePointerForSteps(EvalContext context) {
        if (this.steps.length == 0) {
            return context.getSingleNodePointer();
        }
        if (this.isSimplePath()) {
            NodePointer ptr = (NodePointer)context.getSingleNodePointer();
            return SimplePathInterpreter.interpretSimpleLocationPath(context, ptr, this.steps);
        }
        return this.searchForPath(context);
    }

    private Pointer searchForPath(EvalContext context) {
        int i2 = 0;
        while (i2 < this.steps.length) {
            context = this.createContextForStep(context, this.steps[i2].getAxis(), this.steps[i2].getNodeTest());
            Expression[] predicates = this.steps[i2].getPredicates();
            if (predicates != null) {
                int j2 = 0;
                while (j2 < predicates.length) {
                    context = new PredicateContext(context, predicates[j2]);
                    ++j2;
                }
            }
            ++i2;
        }
        return context.getSingleNodePointer();
    }

    protected EvalContext evalSteps(EvalContext context) {
        if (this.steps.length == 0) {
            return context;
        }
        int i2 = 0;
        while (i2 < this.steps.length) {
            context = this.createContextForStep(context, this.steps[i2].getAxis(), this.steps[i2].getNodeTest());
            Expression[] predicates = this.steps[i2].getPredicates();
            if (predicates != null) {
                int j2 = 0;
                while (j2 < predicates.length) {
                    context = new PredicateContext(context, predicates[j2]);
                    ++j2;
                }
            }
            ++i2;
        }
        return context;
    }

    protected EvalContext createContextForStep(EvalContext context, int axis, NodeTest nodeTest) {
        switch (axis) {
            case 4: {
                return new AncestorContext(context, false, nodeTest);
            }
            case 10: {
                return new AncestorContext(context, true, nodeTest);
            }
            case 5: {
                return new AttributeContext(context, nodeTest);
            }
            case 2: {
                return new ChildContext(context, nodeTest, false, false);
            }
            case 9: {
                return new DescendantContext(context, false, nodeTest);
            }
            case 13: {
                return new DescendantContext(context, true, nodeTest);
            }
            case 8: {
                return new PrecedingOrFollowingContext(context, nodeTest, false);
            }
            case 11: {
                return new ChildContext(context, nodeTest, true, false);
            }
            case 6: {
                return new NamespaceContext(context, nodeTest);
            }
            case 3: {
                return new ParentContext(context, nodeTest);
            }
            case 7: {
                return new PrecedingOrFollowingContext(context, nodeTest, true);
            }
            case 12: {
                return new ChildContext(context, nodeTest, true, true);
            }
            case 1: {
                return new SelfContext(context, nodeTest);
            }
        }
        return null;
    }
}

