/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dynabeans;

import java.util.Locale;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;
import org.apache.commons.jxpath.ri.model.dynabeans.DynaBeanPropertyPointer;

public class DynaBeanPointer
extends PropertyOwnerPointer {
    private QName name;
    private DynaBean dynaBean;

    public DynaBeanPointer(QName name, DynaBean dynaBean, Locale locale) {
        super(null, locale);
        this.name = name;
        this.dynaBean = dynaBean;
    }

    public DynaBeanPointer(NodePointer parent, QName name, DynaBean dynaBean) {
        super(parent);
        this.name = name;
        this.dynaBean = dynaBean;
    }

    public PropertyPointer getPropertyPointer() {
        return new DynaBeanPropertyPointer((NodePointer)this, this.dynaBean);
    }

    public QName getName() {
        return this.name;
    }

    public Object getBaseValue() {
        return this.dynaBean;
    }

    public Object getImmediateNode() {
        return this.dynaBean;
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public boolean isLeaf() {
        return false;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object object) {
        int iOther;
        if (object == this) {
            return true;
        }
        if (!(object instanceof DynaBeanPointer)) {
            return false;
        }
        DynaBeanPointer other = (DynaBeanPointer)object;
        if (!(this.parent == other.parent || this.parent != null && this.parent.equals(other.parent))) {
            return false;
        }
        if (this.name == null && other.name != null || this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        int iThis = this.index == Integer.MIN_VALUE ? 0 : this.index;
        int n2 = iOther = other.index == Integer.MIN_VALUE ? 0 : other.index;
        if (iThis != iOther) {
            return false;
        }
        return this.dynaBean == other.dynaBean;
    }

    public String asPath() {
        if (this.parent != null) {
            return super.asPath();
        }
        return "/";
    }
}

