/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.parser;

public class TokenMgrError
extends Error {
    static final int LEXICAL_ERROR = 0;
    static final int STATIC_LEXER_ERROR = 1;
    static final int INVALID_LEXICAL_STATE = 2;
    static final int LOOP_DETECTED = 3;
    int errorCode;
    private int position;
    private char character;

    public static final String addEscapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i2 = 0;
        while (i2 < str.length()) {
            switch (str.charAt(i2)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch2 = str.charAt(i2);
                    if (ch2 < ' ' || ch2 > '~') {
                        String s2 = "0000" + Integer.toString(ch2, 16);
                        retval.append("\\u" + s2.substring(s2.length() - 4, s2.length()));
                        break;
                    }
                    retval.append(ch2);
                }
            }
            ++i2;
        }
        return retval.toString();
    }

    private static final String LexicalError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar) {
        return "Lexical error at line " + errorLine + ", column " + errorColumn + ".  Encountered: " + (EOFSeen ? "<EOF> " : "\"" + TokenMgrError.addEscapes(String.valueOf(curChar)) + "\"" + " (" + curChar + "), ") + "after : \"" + TokenMgrError.addEscapes(errorAfter) + "\"";
    }

    public String getMessage() {
        return super.getMessage();
    }

    public TokenMgrError() {
    }

    public TokenMgrError(String message, int reason) {
        super(message);
        this.errorCode = reason;
    }

    public TokenMgrError(boolean EOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar, int reason) {
        this(TokenMgrError.LexicalError(EOFSeen, lexState, errorLine, errorColumn, errorAfter, curChar), reason);
        this.position = errorColumn - 1;
        this.character = curChar;
    }

    public int getPosition() {
        return this.position;
    }

    public char getCharacter() {
        return this.character;
    }
}

