/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.mortbay.html.Element;
import org.mortbay.html.Page;

public class Composite
extends Element {
    protected ArrayList elements = new ArrayList(8);
    protected Composite nest = null;

    public Composite() {
    }

    public Composite(String attributes) {
        super(attributes);
    }

    public Composite add(Object o2) {
        if (this.nest != null) {
            this.nest.add(o2);
        } else if (o2 != null) {
            if (o2 instanceof Element) {
                if (o2 instanceof Page) {
                    throw new IllegalArgumentException("Can't insert Page in Composite");
                }
                this.elements.add(o2);
            } else if (o2 instanceof String) {
                this.elements.add(o2);
            } else {
                this.elements.add(o2.toString());
            }
        }
        return this;
    }

    public Composite nest(Composite c2) {
        if (this.nest != null) {
            return this.nest.nest(c2);
        }
        this.add(c2);
        this.nest = c2;
        return this;
    }

    public Composite setNest(Composite c2) {
        if (this.nest != null) {
            this.nest.setNest(c2);
        } else {
            this.nest = c2;
        }
        return this;
    }

    public Composite unnest() {
        if (this.nest != null) {
            this.nest.unnest();
        }
        this.nest = null;
        return this;
    }

    public int size() {
        return this.elements.size();
    }

    public void write(Writer out) throws IOException {
        for (int i2 = 0; i2 < this.elements.size(); ++i2) {
            Object element = this.elements.get(i2);
            if (element instanceof Element) {
                ((Element)element).write(out);
                continue;
            }
            if (element == null) {
                out.write("null");
                continue;
            }
            out.write(element.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String contents() {
        StringBuffer buf;
        StringBuffer stringBuffer = buf = new StringBuffer();
        synchronized (stringBuffer) {
            for (int i2 = 0; i2 < this.elements.size(); ++i2) {
                Object element = this.elements.get(i2);
                if (element == null) {
                    buf.append("null");
                    continue;
                }
                buf.append(element.toString());
            }
        }
        return buf.toString();
    }

    public Composite reset() {
        this.elements.clear();
        return this.unnest();
    }

    void flush(Writer out) throws IOException {
        if (this.nest != null) {
            this.nest.flush(out);
        } else {
            this.write(out);
            this.elements.clear();
        }
    }

    void flush(OutputStream out) throws IOException {
        this.flush(new OutputStreamWriter(out));
    }

    void flush(OutputStream out, String encoding) throws IOException {
        this.flush(new OutputStreamWriter(out, encoding));
    }

    public boolean replace(Object oldObj, Object newObj) {
        if (this.nest != null) {
            return this.nest.replace(oldObj, newObj);
        }
        int sz = this.elements.size();
        for (int i2 = 0; i2 < sz; ++i2) {
            if (this.elements.get(i2) != oldObj) continue;
            this.elements.set(i2, newObj);
            return true;
        }
        return false;
    }
}

