/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.SocketListener;
import org.mortbay.jetty.servlet.ServletSSL;
import org.mortbay.log.LogFactory;
import org.mortbay.util.InetAddrPort;

public abstract class JsseListener
extends SocketListener {
    private static Log log = LogFactory.getLog(JsseListener.class);
    public static final String KEYSTORE_PROPERTY = "jetty.ssl.keystore";
    public static final String KEYSTORE_TYPE_PROPERTY = "jetty.ssl.keystore.type";
    public static final String DEFAULT_KEYSTORE_TYPE = System.getProperty("jetty.ssl.keystore.type", KeyStore.getDefaultType());
    public static final String KEYSTORE_PROVIDER_NAME_PROPERTY = "jetty.ssl.keystore.provider.name";
    public static final String KEYSTORE_PROVIDER_CLASS_PROPERTY = "jetty.ssl.keystore.provider.class";
    public static final String DEFAULT_KEYSTORE_PROVIDER_CLASS = System.getProperty("jetty.ssl.keystore.provider.class");
    public static final String DEFAULT_KEYSTORE = System.getProperty("user.home") + File.separator + ".keystore";
    public static final String DEFAULT_KEYSTORE_PROVIDER_NAME = System.getProperty("jetty.ssl.keystore.provider.name");
    public static final String PASSWORD_PROPERTY = "jetty.ssl.password";
    public static final String KEYPASSWORD_PROPERTY = "jetty.ssl.keypassword";
    static final String CACHED_INFO_ATTR = CachedInfo.class.getName();
    private boolean _needClientAuth = false;

    public JsseListener() {
        this.setDefaultScheme("https");
    }

    public JsseListener(InetAddrPort p_address) {
        super(p_address);
        if (p_address.getPort() == 0) {
            p_address.setPort(443);
            this.setPort(443);
        }
        this.setDefaultScheme("https");
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this._needClientAuth = needClientAuth;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public boolean isIntegral(HttpConnection connection) {
        int integralPort = this.getIntegralPort();
        return integralPort == 0 || integralPort == this.getPort();
    }

    public boolean isConfidential(HttpConnection connection) {
        int confidentialPort = this.getConfidentialPort();
        return confidentialPort == 0 || confidentialPort == this.getPort();
    }

    protected abstract SSLServerSocketFactory createFactory() throws Exception;

    protected ServerSocket newServerSocket(InetAddrPort p_address, int p_acceptQueueSize) throws IOException {
        SSLServerSocketFactory factory = null;
        SSLServerSocket socket = null;
        try {
            factory = this.createFactory();
            socket = p_address == null ? (SSLServerSocket)factory.createServerSocket(0, p_acceptQueueSize) : (SSLServerSocket)factory.createServerSocket(p_address.getPort(), p_acceptQueueSize, p_address.getInetAddress());
            socket.setNeedClientAuth(this._needClientAuth);
            log.info("JsseListener.needClientAuth=" + this._needClientAuth);
        }
        catch (IOException e2) {
            throw e2;
        }
        catch (Exception e3) {
            log.warn("EXCEPTION ", e3);
            throw new IOException("Could not create JsseListener: " + e3.toString());
        }
        return socket;
    }

    protected Socket accept(ServerSocket p_serverSocket) throws IOException {
        try {
            SSLSocket s2 = (SSLSocket)p_serverSocket.accept();
            if (this.getMaxIdleTimeMs() > 0) {
                s2.setSoTimeout(this.getMaxIdleTimeMs());
            }
            s2.startHandshake();
            return s2;
        }
        catch (SSLException e2) {
            log.warn("EXCEPTION ", e2);
            throw new IOException(e2.getMessage());
        }
    }

    protected void customizeRequest(Socket socket, HttpRequest request) {
        super.customizeRequest(socket, request);
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        try {
            java.security.cert.X509Certificate[] certs;
            Integer keySize;
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession sslSession = sslSocket.getSession();
            String cipherSuite = sslSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sslSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                keySize = cachedInfo.getKeySize();
                certs = cachedInfo.getCerts();
            } else {
                keySize = new Integer(ServletSSL.deduceKeyLength(cipherSuite));
                certs = JsseListener.getCertChain(sslSession);
                cachedInfo = new CachedInfo(keySize, certs);
                sslSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (certs != null) {
                request.setAttribute("javax.servlet.request.X509Certificate", certs);
            } else if (this._needClientAuth) {
                throw new HttpException(403);
            }
            request.setAttribute("javax.servlet.request.cipher_suite", cipherSuite);
            request.setAttribute("javax.servlet.request.key_size", keySize);
        }
        catch (Exception e2) {
            log.warn("EXCEPTION ", e2);
        }
    }

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sslSession) {
        try {
            X509Certificate[] javaxCerts = sslSession.getPeerCertificateChain();
            if (javaxCerts == null || javaxCerts.length == 0) {
                return null;
            }
            int length = javaxCerts.length;
            java.security.cert.X509Certificate[] javaCerts = new java.security.cert.X509Certificate[length];
            CertificateFactory cf2 = CertificateFactory.getInstance("X.509");
            for (int i2 = 0; i2 < length; ++i2) {
                byte[] bytes = javaxCerts[i2].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i2] = (java.security.cert.X509Certificate)cf2.generateCertificate(stream);
            }
            return javaCerts;
        }
        catch (SSLPeerUnverifiedException pue) {
            return null;
        }
        catch (Exception e2) {
            log.warn("EXCEPTION ", e2);
            return null;
        }
    }

    private class CachedInfo {
        private Integer _keySize;
        private java.security.cert.X509Certificate[] _certs;

        CachedInfo(Integer keySize, java.security.cert.X509Certificate[] certs) {
            this._keySize = keySize;
            this._certs = certs;
        }

        Integer getKeySize() {
            return this._keySize;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this._certs;
        }
    }
}

