/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.win32;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpServer;
import org.mortbay.jetty.Server;
import org.mortbay.log.LogFactory;

public class Service {
    private static Log log = LogFactory.getLog(Service.class);
    static String serviceLogFile = System.getProperty("SERVICE_LOG_FILE", "logs" + File.separator + "yyyy_mm_dd.service.log");
    public static final int SERVICE_CONTROL_STOP = 1;
    public static final int SERVICE_CONTROL_PAUSE = 2;
    public static final int SERVICE_CONTROL_CONTINUE = 3;
    public static final int SERVICE_CONTROL_INTERROGATE = 4;
    public static final int SERVICE_CONTROL_SHUTDOWN = 5;
    public static final int SERVICE_CONTROL_PARAMCHANGE = 6;
    private static Vector _servers;
    private static Vector _configs;

    private Service() {
    }

    public static void dispatchSCMEvent(int eventID) {
        switch (eventID) {
            case 1: 
            case 2: {
                Service.stopAll();
                break;
            }
            case 3: {
                Service.startAll();
                break;
            }
            case 5: {
                Service.destroyAll();
                break;
            }
            case 6: {
                Service.stopAll();
                Service.destroyAll();
                Service.createAll();
                Service.startAll();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAll() {
        if (_configs != null) {
            Vector vector = _configs;
            synchronized (vector) {
                _servers = new Vector();
                for (int i2 = 0; i2 < _configs.size(); ++i2) {
                    try {
                        Server server = new Server((String)_configs.get(i2));
                        _servers.add(server);
                        continue;
                    }
                    catch (Exception e2) {
                        log.warn(_configs.get(i2) + " configuration problem: ", e2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startAll() {
        block6: {
            try {
                if (_configs == null) break block6;
                Vector vector = _configs;
                synchronized (vector) {
                    for (int i2 = 0; i2 < _servers.size(); ++i2) {
                        HttpServer server = (HttpServer)_servers.get(i2);
                        if (server.isStarted()) continue;
                        server.start();
                    }
                }
            }
            catch (Exception e2) {
                log.warn("EXCEPTION ", e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopAll() {
        if (_configs != null) {
            Vector vector = _configs;
            synchronized (vector) {
                for (int i2 = 0; i2 < _servers.size(); ++i2) {
                    HttpServer server = (HttpServer)_servers.get(i2);
                    try {
                        server.stop();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static void destroyAll() {
        Service.stopAll();
        if (_servers != null) {
            _servers.clear();
        }
        _servers = null;
    }

    public static void stopAndDestroy(String[] arg) {
        if (arg == null || arg.length == 0) {
            Service.stopAll();
            Service.destroyAll();
        } else {
            log.warn("NOT IMPLEMENTED ");
        }
    }

    public static void main(String[] arg) {
        String opt = System.getProperty("SERVICE_OUT");
        if (opt != null) {
            try {
                PrintStream stdout = new PrintStream(new FileOutputStream(opt));
                System.setOut(stdout);
            }
            catch (Exception e2) {
                log.warn("EXCEPTION ", e2);
            }
        }
        if ((opt = System.getProperty("SERVICE_ERR")) != null) {
            try {
                PrintStream stderr = new PrintStream(new FileOutputStream(opt));
                System.setErr(stderr);
            }
            catch (Exception e3) {
                log.warn("EXCEPTION ", e3);
            }
        }
        if (arg.length == 0) {
            arg = new String[]{"etc/jetty.xml"};
        }
        try {
            _configs = new Vector();
            for (int i2 = 0; i2 < arg.length; ++i2) {
                _configs.add(arg[i2]);
            }
            Service.createAll();
            Service.startAll();
        }
        catch (Exception e4) {
            log.warn("EXCEPTION ", e4);
        }
    }
}

