/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.Credential;

public class Password
extends Credential {
    private static Log log = LogFactory.getLog(Password.class);
    private String _pw;

    public Password(String password) {
        this._pw = password;
        while (this._pw != null && this._pw.startsWith("OBF:")) {
            this._pw = Password.deobfuscate(this._pw);
        }
    }

    public String toString() {
        return this._pw;
    }

    public String toStarString() {
        return "*****************************************************".substring(0, this._pw.length());
    }

    public boolean check(Object credentials) {
        if (this == credentials) {
            return true;
        }
        if (credentials instanceof Password) {
            return credentials.equals(this._pw);
        }
        if (credentials instanceof String) {
            return credentials.equals(this._pw);
        }
        if (credentials instanceof Credential) {
            return ((Credential)credentials).check(this._pw);
        }
        return false;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (null == o2) {
            return false;
        }
        if (o2 instanceof Password) {
            Password p2 = (Password)o2;
            return p2._pw == this._pw || null != this._pw && this._pw.equals(p2._pw);
        }
        if (o2 instanceof String) {
            return o2.equals(this._pw);
        }
        return false;
    }

    public int hashCode() {
        return null == this._pw ? super.hashCode() : this._pw.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String obfuscate(String s2) {
        StringBuffer buf = new StringBuffer();
        byte[] b2 = s2.getBytes();
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            buf.append("OBF:");
            for (int i2 = 0; i2 < b2.length; ++i2) {
                byte b1 = b2[i2];
                byte b22 = b2[s2.length() - (i2 + 1)];
                int i1 = b1 + b22 + 127;
                int i22 = b1 - b22 + 127;
                int i0 = i1 * 256 + i22;
                String x2 = Integer.toString(i0, 36);
                switch (x2.length()) {
                    case 1: {
                        buf.append('0');
                    }
                    case 2: {
                        buf.append('0');
                    }
                    case 3: {
                        buf.append('0');
                    }
                }
                buf.append(x2);
            }
            return buf.toString();
        }
    }

    public static String deobfuscate(String s2) {
        if (s2.startsWith("OBF:")) {
            s2 = s2.substring(4);
        }
        byte[] b2 = new byte[s2.length() / 2];
        int l2 = 0;
        for (int i2 = 0; i2 < s2.length(); i2 += 4) {
            String x2 = s2.substring(i2, i2 + 4);
            int i0 = Integer.parseInt(x2, 36);
            int i1 = i0 / 256;
            int i22 = i0 % 256;
            b2[l2++] = (byte)((i1 + i22 - 254) / 2);
        }
        return new String(b2, 0, l2);
    }

    public static Password getPassword(String realm, String dft, String promptDft) {
        String passwd = System.getProperty(realm, dft);
        if (passwd == null || passwd.length() == 0) {
            try {
                System.out.print(realm + (promptDft != null && promptDft.length() > 0 ? " [dft]" : "") + " : ");
                System.out.flush();
                byte[] buf = new byte[512];
                int len = System.in.read(buf);
                if (len > 0) {
                    passwd = new String(buf, 0, len).trim();
                }
            }
            catch (IOException e2) {
                log.warn("EXCEPTION ", e2);
            }
            if (passwd == null || passwd.length() == 0) {
                passwd = promptDft;
            }
        }
        return new Password(passwd);
    }

    public static void main(String[] arg) {
        if (arg.length != 1 && arg.length != 2) {
            System.err.println("Usage - java org.mortbay.util.Password [<user>] <password>");
            System.err.println("If the password is ?, the user will be prompted for the password");
            System.exit(1);
        }
        String p2 = arg[arg.length == 1 ? 0 : 1];
        Password pw = "?".equals(p2) ? new Password(p2) : new Password(p2);
        System.err.println(pw.toString());
        System.err.println(Password.obfuscate(pw.toString()));
        System.err.println(Credential.MD5.digest(p2));
        if (arg.length == 2) {
            System.err.println(Credential.Crypt.crypt(arg[0], pw.toString()));
        }
    }
}

