/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.LogSupport;
import org.mortbay.util.ThreadPool;

public abstract class ThreadedServer
extends ThreadPool {
    private static Log log = LogFactory.getLog(ThreadedServer.class);
    private InetAddrPort _address = null;
    private int _soTimeOut = -1;
    private int _lingerTimeSecs = 30;
    private boolean _tcpNoDelay = true;
    private int _acceptQueueSize = 0;
    private int _acceptors = 1;
    private transient Acceptor[] _acceptor;
    private transient ServerSocket _listen = null;
    private transient boolean _running = false;

    public ThreadedServer() {
    }

    public ServerSocket getServerSocket() {
        return this._listen;
    }

    public ThreadedServer(int port) {
        this.setInetAddrPort(new InetAddrPort(port));
    }

    public ThreadedServer(InetAddress address, int port) {
        this.setInetAddrPort(new InetAddrPort(address, port));
    }

    public ThreadedServer(String host, int port) throws UnknownHostException {
        this.setInetAddrPort(new InetAddrPort(host, port));
    }

    public ThreadedServer(InetAddrPort address) {
        this.setInetAddrPort(address);
    }

    public synchronized void setInetAddrPort(InetAddrPort address) {
        if (this._address != null && this._address.equals(address)) {
            return;
        }
        if (this.isStarted()) {
            log.warn(this + " is started");
        }
        this._address = address;
    }

    public InetAddrPort getInetAddrPort() {
        if (this._address == null) {
            return null;
        }
        return new InetAddrPort(this._address);
    }

    public synchronized void setHost(String host) throws UnknownHostException {
        if (this._address != null && this._address.getHost() != null && this._address.getHost().equals(host)) {
            return;
        }
        if (this.isStarted()) {
            log.warn(this + " is started");
        }
        if (this._address == null) {
            this._address = new InetAddrPort(host, 0);
        } else {
            this._address.setHost(host);
        }
    }

    public String getHost() {
        if (this._address == null || this._address.getInetAddress() == null) {
            return null;
        }
        return this._address.getHost();
    }

    public synchronized void setInetAddress(InetAddress addr) {
        if (this._address != null && this._address.getInetAddress() != null && this._address.getInetAddress().equals(addr)) {
            return;
        }
        if (this.isStarted()) {
            log.warn(this + " is started");
        }
        if (this._address == null) {
            this._address = new InetAddrPort(addr, 0);
        } else {
            this._address.setInetAddress(addr);
        }
    }

    public InetAddress getInetAddress() {
        if (this._address == null) {
            return null;
        }
        return this._address.getInetAddress();
    }

    public synchronized void setPort(int port) {
        if (this._address != null && this._address.getPort() == port) {
            return;
        }
        if (this.isStarted()) {
            log.warn(this + " is started");
        }
        if (this._address == null) {
            this._address = new InetAddrPort(port);
        } else {
            this._address.setPort(port);
        }
    }

    public int getPort() {
        if (this._address == null) {
            return 0;
        }
        return this._address.getPort();
    }

    public void setMaxReadTimeMs(int ms) {
        log.warn("setMaxReadTimeMs is deprecated. Use setMaxIdleTimeMs()");
    }

    public int getMaxReadTimeMs() {
        return this.getMaxIdleTimeMs();
    }

    public void setLingerTimeSecs(int ls) {
        this._lingerTimeSecs = ls;
    }

    public int getLingerTimeSecs() {
        return this._lingerTimeSecs;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this._tcpNoDelay = tcpNoDelay;
    }

    public boolean getTcpNoDelay() {
        return this._tcpNoDelay;
    }

    public int getAcceptQueueSize() {
        return this._acceptQueueSize;
    }

    public void setAcceptQueueSize(int acceptQueueSize) {
        this._acceptQueueSize = acceptQueueSize;
    }

    public void setAcceptorThreads(int n2) {
        this._acceptors = n2;
    }

    public int getAcceptorThreads() {
        return this._acceptors;
    }

    protected void handleConnection(InputStream in, OutputStream out) {
        throw new Error("Either handlerConnection must be overridden");
    }

    protected void handleConnection(Socket connection) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Handle " + connection);
        }
        InputStream in = connection.getInputStream();
        OutputStream out = connection.getOutputStream();
        this.handleConnection(in, out);
        out.flush();
        in = null;
        out = null;
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Object job) {
        Socket socket = (Socket)job;
        try {
            if (this._tcpNoDelay) {
                socket.setTcpNoDelay(true);
            }
            this.handleConnection(socket);
        }
        catch (Exception e2) {
            log.debug("Connection problem", e2);
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception e3) {
                log.debug("Connection problem", e3);
            }
        }
    }

    protected ServerSocket newServerSocket(InetAddrPort address, int acceptQueueSize) throws IOException {
        if (address == null) {
            return new ServerSocket(0, acceptQueueSize);
        }
        return new ServerSocket(address.getPort(), acceptQueueSize, address.getInetAddress());
    }

    protected Socket acceptSocket(ServerSocket ignored, int timeout) {
        return this.acceptSocket(timeout);
    }

    protected Socket acceptSocket(int timeout) {
        try {
            Socket s2 = null;
            if (this._listen != null) {
                if (this._soTimeOut != timeout) {
                    this._soTimeOut = timeout;
                    this._listen.setSoTimeout(this._soTimeOut);
                }
                s2 = this._listen.accept();
                try {
                    if (this.getMaxIdleTimeMs() >= 0) {
                        s2.setSoTimeout(this.getMaxIdleTimeMs());
                    }
                    if (this._lingerTimeSecs >= 0) {
                        s2.setSoLinger(true, this._lingerTimeSecs);
                    } else {
                        s2.setSoLinger(false, 0);
                    }
                }
                catch (Exception e2) {
                    LogSupport.ignore(log, e2);
                }
            }
            return s2;
        }
        catch (SocketException e3) {
            LogSupport.ignore(log, e3);
        }
        catch (InterruptedIOException e4) {
            LogSupport.ignore(log, e4);
        }
        catch (IOException e5) {
            log.warn("EXCEPTION ", e5);
        }
        return null;
    }

    public void open() throws IOException {
        if (this._listen == null) {
            this._listen = this.newServerSocket(this._address, this._acceptQueueSize);
            if (this._address == null) {
                this._address = new InetAddrPort(this._listen.getInetAddress(), this._listen.getLocalPort());
            } else {
                if (this._address.getInetAddress() == null) {
                    this._address.setInetAddress(this._listen.getInetAddress());
                }
                if (this._address.getPort() == 0) {
                    this._address.setPort(this._listen.getLocalPort());
                }
            }
            this._soTimeOut = this.getMaxIdleTimeMs();
            if (this._soTimeOut >= 0) {
                this._listen.setSoTimeout(this._soTimeOut);
            }
        }
    }

    public synchronized void start() throws Exception {
        try {
            if (this.isStarted()) {
                return;
            }
            this.open();
            this._running = true;
            this._acceptor = new Acceptor[this._acceptors];
            for (int a2 = 0; a2 < this._acceptor.length; ++a2) {
                this._acceptor[a2] = new Acceptor();
                this._acceptor[a2].setDaemon(this.isDaemon());
                this._acceptor[a2].start();
            }
            super.start();
        }
        catch (Exception e2) {
            log.warn("Failed to start: " + this);
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        ThreadedServer threadedServer = this;
        synchronized (threadedServer) {
            Acceptor acc;
            int a2;
            this._running = false;
            if (log.isDebugEnabled()) {
                log.debug("closing " + this._listen);
            }
            try {
                if (this._listen != null) {
                    this._listen.close();
                }
                this._listen = null;
            }
            catch (IOException e2) {
                log.warn("EXCEPTION ", e2);
            }
            Thread.yield();
            for (a2 = 0; this._acceptor != null && a2 < this._acceptor.length; ++a2) {
                acc = this._acceptor[a2];
                if (acc == null) continue;
                acc.interrupt();
            }
            Thread.sleep(100L);
            for (a2 = 0; this._acceptor != null && a2 < this._acceptor.length; ++a2) {
                acc = this._acceptor[a2];
                if (acc == null) continue;
                acc.forceStop();
                this._acceptor[a2] = null;
            }
        }
        try {
            super.stop();
        }
        catch (Exception e3) {
            log.warn("EXCEPTION ", e3);
        }
        finally {
            ThreadedServer threadedServer2 = this;
            synchronized (threadedServer2) {
                this._acceptor = null;
            }
        }
    }

    protected void stopJob(Thread thread, Object job) {
        if (job instanceof Socket) {
            try {
                ((Socket)job).close();
            }
            catch (Exception e2) {
                LogSupport.ignore(log, e2);
            }
        }
        super.stopJob(thread, job);
    }

    public String toString() {
        if (this._address == null) {
            return this.getName() + "@0.0.0.0:0";
        }
        if (this._listen != null) {
            return this.getName() + "@" + this._listen.getInetAddress().getHostAddress() + ":" + this._listen.getLocalPort();
        }
        return this.getName() + "@" + this.getInetAddrPort();
    }

    private class Acceptor
    extends Thread {
        private Acceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadedServer threadedServer = ThreadedServer.this;
            try {
                this.setName("Acceptor " + ThreadedServer.this._listen);
                while (ThreadedServer.this._running) {
                    try {
                        Socket socket = ThreadedServer.this.acceptSocket(ThreadedServer.this._soTimeOut);
                        if (socket == null) continue;
                        if (ThreadedServer.this._running) {
                            threadedServer.run(socket);
                            continue;
                        }
                        socket.close();
                    }
                    catch (Throwable e2) {
                        if (ThreadedServer.this._running) {
                            log.warn("EXCEPTION ", e2);
                            continue;
                        }
                        log.debug("EXCEPTION ", e2);
                    }
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (ThreadedServer.this._running) {
                    log.warn("Stopping " + this.getName());
                } else {
                    log.info("Stopping " + this.getName());
                }
                ThreadedServer threadedServer2 = threadedServer;
                synchronized (threadedServer2) {
                    if (ThreadedServer.this._acceptor != null) {
                        for (int a2 = 0; a2 < ThreadedServer.this._acceptor.length; ++a2) {
                            if (ThreadedServer.this._acceptor[a2] != this) continue;
                            ((ThreadedServer)ThreadedServer.this)._acceptor[a2] = null;
                        }
                    }
                    threadedServer.notifyAll();
                }
                throw throwable;
            }
            if (ThreadedServer.this._running) {
                log.warn("Stopping " + this.getName());
            } else {
                log.info("Stopping " + this.getName());
            }
            ThreadedServer threadedServer3 = threadedServer;
            synchronized (threadedServer3) {
                if (ThreadedServer.this._acceptor != null) {
                    for (int a2 = 0; a2 < ThreadedServer.this._acceptor.length; ++a2) {
                        if (ThreadedServer.this._acceptor[a2] != this) continue;
                        ((ThreadedServer)ThreadedServer.this)._acceptor[a2] = null;
                    }
                }
                threadedServer.notifyAll();
            }
        }

        void forceStop() {
            block5: {
                if (ThreadedServer.this._listen != null && ThreadedServer.this._address != null) {
                    InetAddress addr = ThreadedServer.this._address.getInetAddress();
                    try {
                        if (addr == null || addr.toString().startsWith("0.0.0.0")) {
                            addr = InetAddress.getByName("127.0.0.1");
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Self connect to close listener " + addr + ":" + ThreadedServer.this._address.getPort());
                        }
                        Socket socket = new Socket(addr, ThreadedServer.this._address.getPort());
                        Thread.yield();
                        socket.close();
                        Thread.yield();
                    }
                    catch (IOException e2) {
                        if (!log.isDebugEnabled()) break block5;
                        log.debug("problem stopping acceptor " + addr + ": ", e2);
                    }
                }
            }
        }
    }
}

