/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LogSupport;

public class TypeUtil {
    private static Log log = LogFactory.getLog(TypeUtil.class);
    private static final HashMap name2Class = new HashMap();
    private static final HashMap class2Name;
    private static final HashMap class2Value;
    private static Class[] stringArg;
    private static int intCacheSize;
    private static Integer[] integerCache;
    private static String[] integerStrCache;
    private static Integer minusOne;

    public static Class fromName(String name) {
        return (Class)name2Class.get(name);
    }

    public static String toName(Class type) {
        return (String)class2Name.get(type);
    }

    public static Object valueOf(Class type, String value) {
        try {
            if (type.equals(String.class)) {
                return value;
            }
            Method m2 = (Method)class2Value.get(type);
            if (m2 != null) {
                return m2.invoke(null, value);
            }
            if (type.equals(Character.TYPE) || type.equals(Character.class)) {
                return new Character(value.charAt(0));
            }
            Constructor c2 = type.getConstructor(stringArg);
            return c2.newInstance(value);
        }
        catch (NoSuchMethodException e2) {
            LogSupport.ignore(log, e2);
        }
        catch (IllegalAccessException e3) {
            LogSupport.ignore(log, e3);
        }
        catch (InstantiationException e4) {
            LogSupport.ignore(log, e4);
        }
        catch (InvocationTargetException e5) {
            if (e5.getTargetException() instanceof Error) {
                throw (Error)e5.getTargetException();
            }
            LogSupport.ignore(log, e5);
        }
        return null;
    }

    public static Object valueOf(String type, String value) {
        return TypeUtil.valueOf(TypeUtil.fromName(type), value);
    }

    public static Integer newInteger(int i2) {
        if (i2 >= 0 && i2 < intCacheSize) {
            if (integerCache[i2] == null) {
                TypeUtil.integerCache[i2] = new Integer(i2);
            }
            return integerCache[i2];
        }
        if (i2 == -1) {
            return minusOne;
        }
        return new Integer(i2);
    }

    public static String toString(int i2) {
        if (i2 >= 0 && i2 < intCacheSize) {
            if (integerStrCache[i2] == null) {
                TypeUtil.integerStrCache[i2] = Integer.toString(i2);
            }
            return integerStrCache[i2];
        }
        if (i2 == -1) {
            return "-1";
        }
        return Integer.toString(i2);
    }

    public static int parseInt(String s2, int offset, int length, int base) throws NumberFormatException {
        int value = 0;
        if (length < 0) {
            length = s2.length() - offset;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = s2.charAt(offset + i2);
            int digit = c2 - 48;
            if (!(digit >= 0 && digit < base && digit < 10 || (digit = 10 + c2 - 65) >= 10 && digit < base)) {
                digit = 10 + c2 - 97;
            }
            if (digit < 0 || digit >= base) {
                throw new NumberFormatException(s2.substring(offset, offset + length));
            }
            value = value * base + digit;
        }
        return value;
    }

    public static byte[] parseBytes(String s2, int base) {
        byte[] bytes = new byte[s2.length() / 2];
        for (int i2 = 0; i2 < s2.length(); i2 += 2) {
            bytes[i2 / 2] = (byte)TypeUtil.parseInt(s2, i2, 2, base);
        }
        return bytes;
    }

    public static String toString(byte[] bytes, int base) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            int bi2 = 0xFF & bytes[i2];
            int c2 = 48 + bi2 / base % base;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
            c2 = 48 + bi2 % base;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
        }
        return buf.toString();
    }

    public static byte convertHexDigit(byte b2) {
        if (b2 >= 48 && b2 <= 57) {
            return (byte)(b2 - 48);
        }
        if (b2 >= 97 && b2 <= 102) {
            return (byte)(b2 - 97 + 10);
        }
        if (b2 >= 65 && b2 <= 70) {
            return (byte)(b2 - 65 + 10);
        }
        return 0;
    }

    public static char toHexChar(int b2) {
        return (char)(b2 < 10 ? 48 + b2 : 65 + b2 - 10);
    }

    public static String toHexString(byte[] b2) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = 0; i2 < b2.length; ++i2) {
            int bi2 = 0xFF & b2[i2];
            int c2 = 48 + bi2 / 16 % 16;
            if (c2 > 57) {
                c2 = 65 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
            c2 = 48 + bi2 % 16;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
        }
        return buf.toString();
    }

    public static String toHexString(byte[] b2, int offset, int length) {
        StringBuffer buf = new StringBuffer();
        for (int i2 = offset; i2 < offset + length; ++i2) {
            int bi2 = 0xFF & b2[i2];
            int c2 = 48 + bi2 / 16 % 16;
            if (c2 > 57) {
                c2 = 65 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
            c2 = 48 + bi2 % 16;
            if (c2 > 57) {
                c2 = 97 + (c2 - 48 - 10);
            }
            buf.append((char)c2);
        }
        return buf.toString();
    }

    public static byte[] fromHexString(String s2) {
        if (s2.length() % 2 != 0) {
            throw new IllegalArgumentException(s2);
        }
        byte[] array = new byte[s2.length() / 2];
        for (int i2 = 0; i2 < array.length; ++i2) {
            int b2 = Integer.parseInt(s2.substring(i2 * 2, i2 * 2 + 2), 16);
            array[i2] = (byte)(0xFF & b2);
        }
        return array;
    }

    public static void dump(Class c2) {
        System.err.println("Dump: " + c2);
        TypeUtil.dump(c2.getClassLoader());
    }

    public static void dump(ClassLoader cl2) {
        System.err.println("Dump Loaders:");
        while (cl2 != null) {
            System.err.println("  loader " + cl2);
            cl2 = cl2.getParent();
        }
    }

    static {
        name2Class.put("boolean", Boolean.TYPE);
        name2Class.put("byte", Byte.TYPE);
        name2Class.put("char", Character.TYPE);
        name2Class.put("double", Double.TYPE);
        name2Class.put("float", Float.TYPE);
        name2Class.put("int", Integer.TYPE);
        name2Class.put("long", Long.TYPE);
        name2Class.put("short", Short.TYPE);
        name2Class.put("void", Void.TYPE);
        name2Class.put("java.lang.Boolean.TYPE", Boolean.TYPE);
        name2Class.put("java.lang.Byte.TYPE", Byte.TYPE);
        name2Class.put("java.lang.Character.TYPE", Character.TYPE);
        name2Class.put("java.lang.Double.TYPE", Double.TYPE);
        name2Class.put("java.lang.Float.TYPE", Float.TYPE);
        name2Class.put("java.lang.Integer.TYPE", Integer.TYPE);
        name2Class.put("java.lang.Long.TYPE", Long.TYPE);
        name2Class.put("java.lang.Short.TYPE", Short.TYPE);
        name2Class.put("java.lang.Void.TYPE", Void.TYPE);
        name2Class.put("java.lang.Boolean", Boolean.class);
        name2Class.put("java.lang.Byte", Byte.class);
        name2Class.put("java.lang.Character", Character.class);
        name2Class.put("java.lang.Double", Double.class);
        name2Class.put("java.lang.Float", Float.class);
        name2Class.put("java.lang.Integer", Integer.class);
        name2Class.put("java.lang.Long", Long.class);
        name2Class.put("java.lang.Short", Short.class);
        name2Class.put("Boolean", Boolean.class);
        name2Class.put("Byte", Byte.class);
        name2Class.put("Character", Character.class);
        name2Class.put("Double", Double.class);
        name2Class.put("Float", Float.class);
        name2Class.put("Integer", Integer.class);
        name2Class.put("Long", Long.class);
        name2Class.put("Short", Short.class);
        name2Class.put(null, Void.TYPE);
        name2Class.put("string", String.class);
        name2Class.put("String", String.class);
        name2Class.put("java.lang.String", String.class);
        class2Name = new HashMap();
        class2Name.put(Boolean.TYPE, "boolean");
        class2Name.put(Byte.TYPE, "byte");
        class2Name.put(Character.TYPE, "char");
        class2Name.put(Double.TYPE, "double");
        class2Name.put(Float.TYPE, "float");
        class2Name.put(Integer.TYPE, "int");
        class2Name.put(Long.TYPE, "long");
        class2Name.put(Short.TYPE, "short");
        class2Name.put(Void.TYPE, "void");
        class2Name.put(Boolean.class, "java.lang.Boolean");
        class2Name.put(Byte.class, "java.lang.Byte");
        class2Name.put(Character.class, "java.lang.Character");
        class2Name.put(Double.class, "java.lang.Double");
        class2Name.put(Float.class, "java.lang.Float");
        class2Name.put(Integer.class, "java.lang.Integer");
        class2Name.put(Long.class, "java.lang.Long");
        class2Name.put(Short.class, "java.lang.Short");
        class2Name.put(null, "void");
        name2Class.put(String.class, "java.lang.String");
        class2Value = new HashMap();
        try {
            Class[] s2 = new Class[]{String.class};
            class2Value.put(Boolean.TYPE, Boolean.class.getMethod("valueOf", s2));
            class2Value.put(Byte.TYPE, Byte.class.getMethod("valueOf", s2));
            class2Value.put(Double.TYPE, Double.class.getMethod("valueOf", s2));
            class2Value.put(Float.TYPE, Float.class.getMethod("valueOf", s2));
            class2Value.put(Integer.TYPE, Integer.class.getMethod("valueOf", s2));
            class2Value.put(Long.TYPE, Long.class.getMethod("valueOf", s2));
            class2Value.put(Short.TYPE, Short.class.getMethod("valueOf", s2));
            class2Value.put(Boolean.class, Boolean.class.getMethod("valueOf", s2));
            class2Value.put(Byte.class, Byte.class.getMethod("valueOf", s2));
            class2Value.put(Double.class, Double.class.getMethod("valueOf", s2));
            class2Value.put(Float.class, Float.class.getMethod("valueOf", s2));
            class2Value.put(Integer.class, Integer.class.getMethod("valueOf", s2));
            class2Value.put(Long.class, Long.class.getMethod("valueOf", s2));
            class2Value.put(Short.class, Short.class.getMethod("valueOf", s2));
        }
        catch (Exception e2) {
            log.warn("EXCEPTION ", e2);
        }
        stringArg = new Class[]{String.class};
        intCacheSize = Integer.getInteger("org.mortbay.util.TypeUtil.IntegerCacheSize", 600);
        integerCache = new Integer[intCacheSize];
        integerStrCache = new String[intCacheSize];
        minusOne = new Integer(-1);
    }
}

