/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class BasicIo {
    static final byte M_SOF0 = -64;
    static final byte M_SOF1 = -63;
    static final byte M_SOF2 = -62;
    static final byte M_SOF3 = -61;
    public final byte M_DHT = (byte)-60;
    static final byte M_SOF5 = -59;
    static final byte M_SOF6 = -58;
    static final byte M_SOF7 = -57;
    static final byte M_JPG = -56;
    static final byte M_SOF9 = -55;
    static final byte M_SOF10 = -54;
    static final byte M_SOF11 = -53;
    static final byte M_SOF13 = -51;
    static final byte M_SOF14 = -50;
    static final byte M_SOF15 = -49;
    static final byte M_RST0 = -48;
    static final byte M_RST1 = -47;
    static final byte M_RST2 = -46;
    static final byte M_RST3 = -45;
    static final byte M_RST4 = -44;
    static final byte M_RST5 = -43;
    static final byte M_RST6 = -42;
    static final byte M_RST7 = -41;
    static final byte M_SOI = -40;
    static final byte M_EOI = -39;
    static final byte M_SOS = -38;
    public final byte M_DQT = (byte)-37;
    public final byte M_DNL = (byte)-36;
    public final byte M_DRI = (byte)-35;
    public final byte M_DHP = (byte)-34;
    public final byte M_EXP = (byte)-33;
    static final byte M_APP0 = -32;
    static final byte M_APP12 = -20;
    static final byte M_COM = -2;
    static final byte M_PRX = -1;
    boolean intel;
    boolean motorola;
    byte[] data;

    int i2bsI(int offset, int value, int length) {
        int i2 = 0;
        int s2 = 0;
        while (i2 < length) {
            this.data[offset + i2] = (byte)(value >> s2);
            ++i2;
            s2 += 8;
        }
        return offset + length;
    }

    int bs2i(int offset, int length) {
        int val = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            val = (val << 8) + (this.data[offset + i2] & 0xFF);
        }
        return val;
    }

    int s2n(int offset, int length) {
        return this.s2n(offset, length, false);
    }

    int s2n(int offset, int length, boolean signed) {
        int msb;
        int val = 0;
        if (this.intel) {
            int shift = 0;
            for (int i2 = offset; i2 < length + offset && i2 < this.data.length; ++i2) {
                val += (this.data[i2] & 0xFF) << shift;
                shift += 8;
            }
        } else if (this.motorola) {
            for (int i3 = 0; i3 < length; ++i3) {
                val = (val << 8) + (this.data[offset + i3] & 0xFF);
            }
        }
        if (signed && (val & (msb = 1 << 8 * length - 1)) > 0) {
            val -= msb << 1;
        }
        return val;
    }

    void n2s(byte[] result, int offset, int value, int length) {
        if (this.motorola) {
            for (int i2 = 0; i2 < length; ++i2) {
                result[offset + length - i2 - 1] = (byte)(value & 0xFF);
                value >>= 8;
            }
        } else {
            for (int i3 = 0; i3 < length; ++i3) {
                result[offset + i3] = (byte)(value & 0xFF);
                value >>= 8;
            }
        }
    }

    void bn2s(byte[] result, int offset, int value, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            result[offset + length - i2 - 1] = (byte)(value & 0xFF);
            value >>= 8;
        }
    }

    byte[] n2s(int value, int length) {
        byte[] result = new byte[length];
        this.n2s(result, 0, value, length);
        return result;
    }

    byte[] bn2s(int value, int length) {
        byte[] result = new byte[length];
        this.bn2s(result, 0, value, length);
        return result;
    }

    String s2a(int offset, int length) {
        String result = null;
        try {
            result = new String(this.data, offset, length, "Default");
        }
        catch (UnsupportedEncodingException e2) {
            // empty catch block
        }
        return result;
    }

    boolean isSignature(int offset, String signature) {
        for (int i2 = 0; i2 < signature.length(); ++i2) {
            if (signature.charAt(i2) == (this.data[offset + i2] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    public static void skip(InputStream is, long n2) throws IOException {
        if (n2 == 0L) {
            return;
        }
        long lefttoskip = n2;
        while ((lefttoskip -= is.skip(lefttoskip)) > 0L) {
        }
    }

    public static int read(InputStream is, byte[] data) throws IOException {
        int rl;
        for (int lefttoread = data.length; lefttoread > 0 && lefttoread <= data.length; lefttoread -= rl) {
            rl = is.read(data, data.length - lefttoread, lefttoread);
            if (rl >= 0) continue;
            return data.length - lefttoread;
        }
        return data.length;
    }

    public static String convertLength(long l2) {
        if (l2 / 1024L / 1024L > 0L) {
            return "" + l2 / 1024L / 1024L + "MB";
        }
        if (l2 / 1024L > 0L) {
            return "" + l2 / 1024L + "KB";
        }
        return "" + l2;
    }
}

