/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import se.datadosen.component.JBackgroundPanel;
import se.datadosen.component.JIconButton;
import se.datadosen.component.JWizardStep;
import se.datadosen.component.NorthEtchedBorder;
import se.datadosen.jalbum.JAlbum;

public class JWizard
extends JDialog {
    protected String title = "";
    protected LinkedList steps = new LinkedList();
    protected int stepIndex = 0;
    JPanel content = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel imageLabel = new JLabel();
    protected JPanel buttonPanel = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    public Action backAction = new AbstractAction("Back"){

        public void actionPerformed(ActionEvent e2) {
            JWizard.this.currentStep().onHide();
            JWizard.this.cardLayout.previous(JWizard.this.stepPanel);
            --JWizard.this.stepIndex;
            JWizard.this.update();
            JWizard.this.currentStep().onShow();
        }
    };
    public Action nextAction = new AbstractAction("Next"){

        public void actionPerformed(ActionEvent e2) {
            JWizard.this.currentStep().onHide();
            JWizard.this.cardLayout.next(JWizard.this.stepPanel);
            ++JWizard.this.stepIndex;
            JWizard.this.update();
            JWizard.this.currentStep().onShow();
        }
    };
    public Action okAction = new AbstractAction("Ok"){

        public void actionPerformed(ActionEvent e2) {
            JWizard.this.setVisible(false);
            JWizard.this.dispose();
        }
    };
    public Action finishAction = new AbstractAction("Finish"){

        public void actionPerformed(ActionEvent e2) {
            JWizard.this.onFinish();
        }
    };
    public Action cancelAction = new AbstractAction("Cancel"){

        public void actionPerformed(ActionEvent e2) {
            JWizard.this.setVisible(false);
            JWizard.this.dispose();
        }
    };
    protected JButton cancelButton = new JButton(this.cancelAction);
    protected JButton okButton = new JButton(this.okAction);
    protected JButton finishButton = new JButton(this.finishAction);
    protected JButton nextButton = new JButton(this.nextAction);
    protected JButton backButton = new JButton(this.backAction);
    Border border1;
    JBackgroundPanel stepPanel = new JBackgroundPanel();
    CardLayout cardLayout = new CardLayout();

    public JWizard(JFrame owner, String title, boolean modal, ImageIcon image) {
        super(owner, title, modal);
        this.title = title;
        this.imageLabel.setIcon(image);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JWizard(JDialog owner, String title, boolean modal, ImageIcon image) {
        super(owner, title, modal);
        this.title = title;
        this.imageLabel.setIcon(image);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setVisible(boolean show) {
        if (show) {
            this.currentStep().onShow();
        } else {
            this.currentStep().onHide();
            this.onHide();
        }
        super.setVisible(show);
    }

    public void onFinish() {
        this.setVisible(false);
    }

    public void onHide() {
    }

    public void setBackgroundImage(Image bg2) {
        this.stepPanel.setBackgroundImage(bg2);
    }

    void jbInit() throws Exception {
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane pane = this.getLayeredPane();
        AbstractAction closeAction = new AbstractAction("close"){

            public void actionPerformed(ActionEvent e2) {
                JWizard.this.cancelAction.actionPerformed(null);
            }
        };
        pane.registerKeyboardAction(closeAction, "close", ks, 2);
        this.border1 = BorderFactory.createEmptyBorder(12, 12, 0, 12);
        this.getContentPane().setLayout(this.borderLayout1);
        this.content.setLayout(this.borderLayout2);
        this.content.setOpaque(false);
        this.content.setBorder(this.border1);
        this.stepPanel.setLayout(this.cardLayout);
        this.stepPanel.setOpaque(false);
        this.backAction.setEnabled(false);
        this.getContentPane().add((Component)this.content, "Center");
        this.buttonPanel.setLayout(this.flowLayout1);
        this.buttonPanel.setOpaque(false);
        this.flowLayout1.setAlignment(2);
        if (JAlbum.isMac()) {
            this.buttonPanel.setBorder(new EmptyBorder(0, 0, 6, 0));
        } else {
            this.buttonPanel.setBorder(new NorthEtchedBorder());
        }
        JPanel imagePanel = new JPanel(new BorderLayout());
        imagePanel.setOpaque(false);
        imagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 9, 12), BorderFactory.createLineBorder(new Color(0, 0, 0, 50))));
        JLabel filler = new JLabel();
        filler.setBackground(new Color(254, 254, 254));
        filler.setOpaque(true);
        imagePanel.add((Component)filler, "Center");
        imagePanel.add((Component)this.imageLabel, "South");
        this.content.add((Component)imagePanel, "West");
        this.content.add((Component)this.buttonPanel, "South");
        this.content.add((Component)this.stepPanel, "Center");
    }

    public void allowFinish(boolean allow) {
        this.finishAction.setEnabled(allow);
        this.okAction.setEnabled(allow);
    }

    public void addStep(JWizardStep step) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JLabel headerLabel = new JLabel(step.getHeader());
        headerLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
        Font existingFont = headerLabel.getFont();
        Font boldFont = existingFont.deriveFont(1);
        int problemIndex = boldFont.canDisplayUpTo(step.getHeader());
        if (problemIndex == -1 || problemIndex == step.getHeader().length()) {
            headerLabel.setFont(boldFont);
        }
        panel.add((Component)headerLabel, "North");
        panel.add((Component)step, "Center");
        this.stepPanel.add((Component)panel, "");
        this.steps.addLast(step);
        this.cardLayout.first(this.stepPanel);
        this.update();
    }

    protected void update() {
        this.buttonPanel.removeAll();
        Action[] actions = this.currentStep().getActions();
        if (actions == null) {
            this.buttonPanel.add(this.backButton);
            this.buttonPanel.add(this.nextButton);
            this.buttonPanel.add(this.finishButton);
            if (JAlbum.isMac()) {
                this.buttonPanel.add(this.cancelButton);
                this.buttonPanel.add(this.okButton);
            } else {
                this.buttonPanel.add(this.okButton);
                this.buttonPanel.add(this.cancelButton);
            }
        } else {
            Action defaultAction = this.currentStep().getDefaultAction();
            for (int i2 = 0; i2 < actions.length; ++i2) {
                JIconButton button = new JIconButton(actions[i2]);
                if (JAlbum.isMac()) {
                    button.setIcon(null);
                }
                this.buttonPanel.add(button);
                if (actions[i2] != defaultAction) continue;
                this.getRootPane().setDefaultButton(button);
            }
        }
        this.buttonPanel.repaint();
        this.backAction.setEnabled(this.stepIndex > 0);
        this.nextAction.setEnabled(this.stepIndex < this.steps.size() - 1 && this.currentStep().allowNext());
        this.allowFinish(this.stepIndex == this.steps.size() - 1 && this.currentStep().allowNext());
        this.finishButton.setVisible(this.steps.size() > 1);
        this.okButton.setVisible(this.steps.size() == 1);
        this.backButton.setVisible(this.steps.size() > 1);
        this.nextButton.setVisible(this.steps.size() > 1);
        this.updateTitle();
    }

    protected void updateTitle() {
        if (this.steps.size() > 1) {
            this.setTitle(this.title + " - Step " + (this.stepIndex + 1) + " of " + this.steps.size());
        } else {
            this.setTitle(this.title);
        }
    }

    public JWizardStep currentStep() {
        return (JWizardStep)this.steps.get(this.stepIndex);
    }
}

