/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component.buttonbar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;
import se.datadosen.jalbum.JAlbum;

class JAlbumButtonUI
extends BasicButtonUI {
    private static Color blueishBackgroundOver;
    private static Color blueishBorderOver;
    private static Color blueishBackgroundSelected;
    private static Color blueishBorderSelected;

    public void installUI(JComponent c2) {
        super.installUI(c2);
        AbstractButton button = (AbstractButton)c2;
        if (!JAlbum.isMac() || !JAlbum.isUsingSystemLAF()) {
            button.setRolloverEnabled(true);
        }
        button.setBorder(BorderFactory.createEmptyBorder(4, 2, 2, 2));
    }

    public Dimension getPreferredSize(JComponent c2) {
        Dimension preferred = super.getPreferredSize(c2);
        return new Dimension(preferred.width < 59 ? 59 : preferred.width, preferred.height);
    }

    public void paint(Graphics g2, JComponent c2) {
        AbstractButton button = (AbstractButton)c2;
        if (button.getModel().isRollover() || button.getModel().isArmed() || button.getModel().isSelected()) {
            Color oldColor = g2.getColor();
            boolean isMac = JAlbum.isMac();
            if (button.getModel().isSelected() || isMac) {
                g2.setColor(blueishBorderSelected);
            } else {
                g2.setColor(blueishBorderOver);
            }
            g2.drawRect(0, 0, c2.getWidth() - 1, c2.getHeight() - 1);
            if (button.getModel().isSelected() || isMac) {
                g2.setColor(blueishBackgroundSelected);
            } else {
                g2.setColor(blueishBackgroundOver);
            }
            g2.fillRect(1, 0, c2.getWidth() - 2, c2.getHeight());
            g2.setColor(oldColor);
        }
        super.paint(g2, c2);
    }

    static {
        if (JAlbum.isMac()) {
            blueishBackgroundSelected = Color.decode("#dddddd");
            blueishBorderSelected = Color.decode("#b9b9b9");
        } else {
            int r2 = SystemColor.textHighlight.getRed();
            int g2 = SystemColor.textHighlight.getGreen();
            int b2 = SystemColor.textHighlight.getBlue();
            blueishBorderSelected = SystemColor.textHighlight;
            blueishBackgroundSelected = new Color(r2, g2, b2, 70);
            blueishBorderOver = new Color(r2, g2, b2, 100);
            blueishBackgroundOver = new Color(r2, g2, b2, 20);
        }
    }
}

