/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class SmartFlowLayout
implements LayoutManager,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    private static final long serialVersionUID = -7262534875583282631L;
    private static final int currentSerialVersion = 1;
    int align;
    int newAlign;
    int hgap;
    int vgap;
    private int serialVersionOnStream = 1;

    public SmartFlowLayout() {
        this(1, 5, 5);
    }

    public SmartFlowLayout(int align) {
        this(align, 5, 5);
    }

    public SmartFlowLayout(int align, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
    }

    public int getAlignment() {
        return this.newAlign;
    }

    public void setAlignment(int align) {
        this.newAlign = align;
        switch (align) {
            case 3: {
                this.align = 0;
                break;
            }
            case 4: {
                this.align = 2;
                break;
            }
            default: {
                this.align = align;
            }
        }
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container target) {
        int targetWidth = (int)target.getSize().getWidth();
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxwidth = targetWidth - (insets.left + insets.right + this.hgap);
            int nmembers = target.getComponentCount();
            int x2 = 0;
            int y2 = insets.top;
            int rowh = 0;
            for (int i2 = 0; i2 < nmembers; ++i2) {
                Component m2 = target.getComponent(i2);
                if (!m2.isVisible()) continue;
                Dimension d2 = m2.getPreferredSize();
                if (x2 == 0 || x2 + d2.width <= maxwidth) {
                    if (x2 > 0) {
                        x2 += this.hgap;
                    }
                    x2 += d2.width;
                    rowh = Math.max(rowh, d2.height);
                    continue;
                }
                x2 = d2.width;
                y2 += this.vgap + rowh;
                rowh = d2.height;
            }
            return new Dimension(targetWidth, y2 + rowh + insets.bottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            for (int i2 = 0; i2 < nmembers; ++i2) {
                Component m2 = target.getComponent(i2);
                if (!m2.isVisible()) continue;
                Dimension d2 = m2.getMinimumSize();
                dim.height = Math.max(dim.height, d2.height);
                if (i2 > 0) {
                    dim.width += this.hgap;
                }
                dim.width += d2.width;
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right;
            dim.height += insets.top + insets.bottom;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x2, int y2, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.newAlign) {
                case 0: {
                    x2 += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    x2 += width / 2;
                    break;
                }
                case 2: {
                    x2 += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    x2 += width;
                }
            }
            for (int i2 = rowStart; i2 < rowEnd; ++i2) {
                Component m2 = target.getComponent(i2);
                if (!m2.isVisible()) continue;
                if (ltr) {
                    m2.setLocation(x2, y2 + (height - m2.getHeight()) / 2);
                } else {
                    m2.setLocation(target.getWidth() - x2 - m2.getWidth(), y2 + (height - m2.getHeight()) / 2);
                }
                x2 += m2.getWidth() + this.hgap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxwidth = target.getWidth() - (insets.left + insets.right + this.hgap);
            int nmembers = target.getComponentCount();
            int x2 = 0;
            int y2 = insets.top;
            int rowh = 0;
            int start = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            for (int i2 = 0; i2 < nmembers; ++i2) {
                Component m2 = target.getComponent(i2);
                if (!m2.isVisible()) continue;
                Dimension d2 = m2.getPreferredSize();
                m2.setSize(d2.width, d2.height);
                if (x2 == 0 || x2 + d2.width <= maxwidth) {
                    if (x2 > 0) {
                        x2 += this.hgap;
                    }
                    x2 += d2.width;
                    rowh = Math.max(rowh, d2.height);
                    continue;
                }
                this.moveComponents(target, insets.left, y2, maxwidth - x2, rowh, start, i2, ltr);
                x2 = d2.width;
                y2 += this.vgap + rowh;
                rowh = d2.height;
                start = i2;
            }
            this.moveComponents(target, insets.left, y2, maxwidth - x2, rowh, start, nmembers, ltr);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.setAlignment(this.align);
        }
        this.serialVersionOnStream = 1;
    }

    public String toString() {
        String str = "";
        switch (this.align) {
            case 0: {
                str = ",align=left";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=right";
                break;
            }
            case 3: {
                str = ",align=leading";
                break;
            }
            case 4: {
                str = ",align=trailing";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

