/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.ParseException;
import bsh.Primitive;
import bsh.TargetError;
import bsh.UtilEvalError;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDescriptor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.ImageObserver;
import java.awt.image.Kernel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import marcoschmidt.ImageInfo;
import se.datadosen.imaging.exif.ImageInfoFormatter;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumFileFilter;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.FileCollection;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.jalbum.JAFilterNode;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.MetaObjectCache;
import se.datadosen.jalbum.ModifiesSize;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.scaling.ImageScaler;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;
import se.datadosen.tags.Elements;
import se.datadosen.util.FileFilters;
import se.datadosen.util.FormattedDate;
import se.datadosen.util.IO;
import se.datadosen.util.PrintSafeHashMap;
import se.datadosen.util.Replacer;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.Scope;
import se.datadosen.util.SmartResourceBundle;
import se.datadosen.util.Stopwatch;

public class AlbumBean
implements Serializable,
ImageObserver {
    public static final String PRODUCT_DISPLAY_VERSION = "7.2";
    public static final String PRODUCT_INTERNAL_VERSION = "7.2.1";
    public static final String ORDER_BY_DATE = "OrderByDate";
    public static final String ORDER_BY_NAME = "OrderByName";
    public static final String ORDER_BY_SIMPLE_NAME = "OrderBySimpleName";
    public static final String CUSTOM_ORDER_FILE = "albumfiles.txt";
    public static final String LINK_ORIGINALS = "LinkOriginals";
    public static final String LINK_ORIGINALS_VIA_SCALED = "LinkOriginalsViaScaled";
    public static final String LINK_SCALED = "LinkScaled";
    public static final String SCALE_SMOOTH = "ScaleSmooth";
    public static final String SCALE_MEDIUM = "ScaleMedium";
    public static final String SCALE_FAST = "ScaleFast";
    static final String GIFS_DIR = "gifs";
    private static final String STYLES_FILE = "styles.css";
    private static final String FOLDER_FILE = "folder.gif";
    static Image filmImage = new ImageIcon((class$se$datadosen$explorer$JAlbumObject == null ? (class$se$datadosen$explorer$JAlbumObject = AlbumBean.class$("se.datadosen.explorer.JAlbumObject")) : class$se$datadosen$explorer$JAlbumObject).getResource("images/bigfilm.png")).getImage();
    private static final String DEFAULT_INDEX_PAGE_NAME = "index";
    private static final int MAX_ROWS = 999;
    protected static final Map application = new PrintSafeHashMap();
    public HashMap evalStats = new HashMap();
    AlbumObjectFactory albumObjectFactory;
    private ImageInfoFormatter formatter = new ImageInfoFormatter();
    private Config cfg = Config.getConfig();
    Object using;
    private Map album;
    Scope globalVariables;
    Map fileVariables;
    private long startTime;
    private int processedFiles;
    private int totalFiles;
    private String directory = "";
    private String thumbSize = "124x124";
    private String imageSize = "800x800";
    private String lastThumbSize;
    private String lastImageSize;
    Dimension thumbDim = new Dimension(124, 124);
    Dimension imageDim = new Dimension(800, 800);
    private int cols = 6;
    private int rows = 4;
    private int qualityPercent = 75;
    private int sharpenPercent = 50;
    private boolean progressiveMode = true;
    private boolean classicReaders = true;
    private boolean useThumbForFolderIcon = false;
    private int nThreads = 1;
    private boolean slides = true;
    private transient Vector albumBeanListeners;
    private String dateFormat = "";
    private String scalingMethod = "ScaleMedium";
    private boolean subdirs = true;
    private boolean appendImages = false;
    private boolean updatedDirsOnly = false;
    private boolean excludeByDefault = false;
    private boolean keepMetaData = false;
    private String indexPageName = "index";
    private String framesetPageName;
    private boolean urlEncode = false;
    private String imageOrdering = "OrderByDate";
    private Comparator customImageOrdering;
    private boolean metaData = true;
    private boolean sameDirectory = false;
    private String outputDirectory = "album";
    private String imageLinking = "LinkScaled";
    private boolean copyOriginals;
    private String skin = "Chameleon";
    private String style = "Black.css";
    private String resourceDirectory = "res";
    private String thumbDirectory = "thumbs";
    private String closeupDirectory = "slides";
    private String slideDirectory = "slides";
    private String thumbnailPrefix = "";
    private String closeupPrefix = "";
    private String pageExtension = ".html";
    private boolean includeDirectories = true;
    private Map userVariables = new PrintSafeHashMap();
    private Map skinVariables = new PrintSafeHashMap();
    private Map extras = new PrintSafeHashMap();
    private boolean frames;
    private String accountProfileName = "";
    private String remoteDirectory = "album";
    private boolean reverseOrder;
    private LinkedList filters = new LinkedList();
    private String characterEncoding;
    private String textEncoding;
    private boolean writeUTF8 = true;
    private boolean directoriesFirst = true;
    private String ignorePattern = "\\..*";
    private String includePattern = "";
    boolean textFileComment = true;
    boolean jpegComment = false;
    boolean iptcCaption = true;
    boolean exifUserComment = true;
    boolean highQualityThumbs = true;
    boolean exifImageDescription = false;
    private DateFormat df = new SimpleDateFormat();
    private File skinDir;
    private File slidesDir;
    private File resDir;
    public File srcResDir;
    private File rootImageDir;
    private File rootOutputDir;
    int currentRows;
    int indexNum;
    File[] files;
    int imagesPerIndex;
    int indexImageCount;
    Scope indexVariables;
    Interpreter interpreter;
    TemplateParser parser;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;
    static /* synthetic */ Class class$com$drew$metadata$iptc$IptcDirectory;
    static /* synthetic */ Class class$se$datadosen$explorer$JAlbumObject;

    public AlbumBean() {
        this.skinDir = new File(this.cfg.skinsDir, this.skin);
        this.textEncoding = System.getProperty("file.encoding");
        if (this.textEncoding.equals("MacRoman") || this.textEncoding.equals("Cp1252")) {
            this.setTextEncoding("ISO-8859-1");
        }
        this.initInterpreter();
    }

    void initInterpreter() {
        this.interpreter = new Interpreter();
        File skinPluginsDir = new File(this.skinDir, "plugins");
        URLClassLoader loader = null;
        try {
            loader = skinPluginsDir.exists() ? new URLClassLoader(new URL[]{skinPluginsDir.toURL(), this.cfg.pluginsDir.toURL()}) : new URLClassLoader(new URL[]{this.cfg.pluginsDir.toURL()});
            this.interpreter.setClassLoader(loader);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    public void setDirectory(String newDirectory) {
        this.directory = newDirectory;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setThumbSize(String newThumbSize) throws ParameterException {
        this.thumbSize = newThumbSize;
        this.thumbDim = AlbumBean.parseSize(this.thumbSize);
    }

    public String getThumbSize() {
        return this.thumbSize;
    }

    public void setImageSize(String newImageSize) throws ParameterException {
        this.imageSize = newImageSize;
        this.imageDim = AlbumBean.parseSize(this.imageSize);
    }

    public String getImageSize() {
        return this.imageSize;
    }

    String getLastImageSize() {
        return this.lastImageSize;
    }

    String getLastThumbSize() {
        return this.lastThumbSize;
    }

    public void setCols(int newCols) {
        this.cols = newCols;
    }

    public int getCols() {
        return this.cols;
    }

    public void setQualityPercent(int newQualityPercent) {
        this.qualityPercent = newQualityPercent;
    }

    public int getQualityPercent() {
        return this.qualityPercent;
    }

    public void setSharpenPercent(int newSharpenPercent) {
        this.sharpenPercent = newSharpenPercent;
    }

    public int getSharpenPercent() {
        return this.sharpenPercent;
    }

    public void setProgressiveMode(boolean newProgressiveMode) {
        this.progressiveMode = newProgressiveMode;
    }

    public boolean isProgressiveMode() {
        return this.progressiveMode;
    }

    public void setClassicReaders(boolean newClassicReaders) {
        this.classicReaders = newClassicReaders;
    }

    public boolean isClassicReaders() {
        return this.classicReaders;
    }

    public void setUseThumbForFolderIcon(boolean newUseThumbForFolderIcon) {
        this.useThumbForFolderIcon = newUseThumbForFolderIcon;
    }

    public boolean isUseThumbForFolderIcon() {
        return this.useThumbForFolderIcon;
    }

    public void setNThreads(int nThreads) {
        this.nThreads = nThreads;
    }

    public int getNThreads() {
        return this.nThreads;
    }

    public void setSlides(boolean newSlides) {
        this.slides = newSlides;
    }

    public boolean isSlides() {
        return this.slides;
    }

    public void setDateFormat(String newDateFormat) {
        this.dateFormat = newDateFormat;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void processTemplateFile(File source, File dest) throws IOException, ElementException {
        String data = IO.readTextFile(source);
        data = this.processTemplate(data);
        IO.writeTextFile(data, dest, this.writeUTF8 ? "UTF-8" : this.textEncoding);
    }

    public String processTemplate(String template) throws ElementException {
        String data = template;
        Replacer replacer = AlbumBean.fillReplacer(new Replacer(), this.parser.getVariables());
        data = replacer.replace(data);
        data = this.parser.parseElements(data);
        return data;
    }

    public void processTemplateFile(File source, File dest, Map vars) throws IOException, ElementException {
        String data = IO.readTextFile(source);
        Replacer replacer = AlbumBean.fillReplacer(new Replacer(), vars);
        data = replacer.replace(data);
        this.parser.reset();
        this.parser.putAll(vars);
        data = this.parser.parseElements(data);
        IO.writeTextFile(data, dest, this.writeUTF8 ? "UTF-8" : this.textEncoding);
    }

    public File[] listFiles(File dir2, boolean includeDirs, File outputDir) throws IOException {
        FileCollection fc = new FileCollection(this, dir2);
        fc.setDoSort(true);
        AlbumFileFilter filter = includeDirs ? new AlbumFileFilter(this, outputDir, this.ignorePattern) : new AlbumFileFilter(this, null, this.ignorePattern);
        File[] files = fc.listFiles(filter);
        return files;
    }

    private void cleanIfRequested(File dir2) throws IOException {
        dir2.mkdir();
        if (this.cfg.isCleanOutputFiles() && !this.appendImages) {
            this.cleanDirectory(dir2);
        }
    }

    private void cleanDirectory(File dir2) throws IOException {
        File[] files = dir2.listFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (files[i2].isDirectory() || files[i2].lastModified() >= this.startTime) continue;
            files[i2].delete();
        }
    }

    private void cleanDirectoryTree(File dir2) throws IOException {
        File[] files = dir2.listFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (files[i2].isDirectory()) {
                this.cleanDirectoryTree(files[i2]);
            }
            if (files[i2].lastModified() >= this.startTime) continue;
            files[i2].delete();
        }
    }

    private void makeAlbumForDirectory(File dir2, File outputDir, int level) throws ParameterException, IOException, OperationAbortedException, ElementException {
        File gifsDir;
        File[] files;
        if (!dir2.isDirectory()) {
            throw new ParameterException(Msg.getString("engine.invalidDirectoryError"));
        }
        File[] filesDirs = files = this.listFiles(dir2, false, null);
        if (this.subdirs || this.includeDirectories) {
            filesDirs = this.listFiles(dir2, true, outputDir);
        }
        if (filesDirs.length == 0) {
            return;
        }
        outputDir.mkdirs();
        if (!outputDir.equals(dir2)) {
            this.cleanIfRequested(outputDir);
        }
        File thumbsDir = new File(outputDir, this.thumbDirectory);
        this.cleanIfRequested(thumbsDir);
        File srcResDir2 = new File(this.skinDir, "styles/" + IO.baseName(this.style));
        if (this.resDir != null && level == 0) {
            IO.copyDirectoryContent(this.srcResDir, this.resDir, true);
            if (srcResDir2.exists()) {
                IO.copyDirectoryContent(srcResDir2, this.resDir, true);
            }
            File styleFile = new File(this.skinDir, "styles/" + this.style);
            if (this.style != null && styleFile.exists()) {
                this.processTemplateFile(styleFile, new File(this.resDir, STYLES_FILE), this.globalVariables);
            }
        }
        if ((gifsDir = new File(this.skinDir, GIFS_DIR)).exists()) {
            File outputGifsDir = new File(outputDir, GIFS_DIR);
            this.cleanIfRequested(outputGifsDir);
            IO.copyDirectoryContent(gifsDir, outputGifsDir, true);
        }
        AlbumBeanEvent eventObject = new AlbumBeanEvent(this, dir2, IO.relativePath(dir2, this.rootImageDir.getParentFile()), Msg.getString("engine.readingMetadataInfo"), 0, files.length, this.processedFiles, this.totalFiles);
        this.fireImageProcessingStarted(eventObject);
        Collection errorFiles = this.registerVariables(dir2, filesDirs, outputDir);
        filesDirs = this.excludeErrorFiles(filesDirs, errorFiles);
        files = this.excludeErrorFiles(files, errorFiles);
        eventObject = new AlbumBeanEvent(this, dir2, IO.relativePath(dir2, this.rootImageDir.getParentFile()), Msg.getString("engine.makingIndexPages"), 0, files.length, this.processedFiles, this.totalFiles);
        this.fireImageProcessingStarted(eventObject);
        this.makeIndexPages(dir2, outputDir, this.includeDirectories ? filesDirs : files, files, level);
        if (this.slides || this.imageLinking != LINK_ORIGINALS) {
            this.slidesDir = new File(outputDir, this.slideDirectory);
            this.slidesDir.mkdir();
            this.cleanIfRequested(this.slidesDir);
        }
        this.adjustImageLinks(outputDir, files);
        Counter c2 = new Counter(0);
        if (this.nThreads > 1) {
            int i2;
            ThreadGroup threads = new ThreadGroup("Image processing threads");
            ImageProcessingThread[] processThreads = new ImageProcessingThread[this.nThreads];
            for (i2 = 0; i2 < this.nThreads; ++i2) {
                processThreads[i2] = new ImageProcessingThread(threads, "Processing thread " + i2, c2, dir2, outputDir, files);
                processThreads[i2].start();
            }
            for (i2 = 0; i2 < this.nThreads; ++i2) {
                try {
                    processThreads[i2].join();
                    continue;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            for (i2 = 0; i2 < this.nThreads; ++i2) {
                Throwable t2 = processThreads[i2].throwable;
                if (t2 == null) continue;
                if (t2 instanceof ElementException) {
                    throw (ElementException)t2;
                }
                if (t2 instanceof IOException) {
                    throw (IOException)t2;
                }
                if (t2 instanceof OperationAbortedException) {
                    throw (OperationAbortedException)t2;
                }
                if (t2 instanceof RuntimeException) {
                    throw (RuntimeException)t2;
                }
                if (t2 instanceof Error) {
                    throw (Error)t2;
                }
                throw new RuntimeException(t2);
            }
        } else {
            this.makeThumbs(c2, dir2, outputDir, files);
        }
        AlbumBean.removeIfEmpty(new File(outputDir, this.thumbDirectory));
        AlbumBean.removeIfEmpty(new File(outputDir, this.slideDirectory));
        if (this.subdirs) {
            for (int i3 = 0; i3 < filesDirs.length; ++i3) {
                File outputSubDir;
                File sourceSubDir;
                if (!filesDirs[i3].isDirectory() || !this.needsToProcessDir(sourceSubDir = filesDirs[i3], outputSubDir = new File(outputDir, sourceSubDir.getName()))) continue;
                this.makeAlbumForDirectory(filesDirs[i3], outputSubDir, level + 1);
            }
        }
    }

    private boolean needsToProcessDir(File inputDir, File outputDir) throws IOException {
        boolean needToProcessDir = !this.updatedDirsOnly || !outputDir.exists() || IO.deepLastModified(inputDir) > IO.deepLastModified(outputDir);
        return needToProcessDir;
    }

    private static void removeIfEmpty(File dir2) throws IOException {
        if (dir2.exists() && dir2.listFiles().length == 0) {
            dir2.delete();
        }
    }

    private File[] excludeErrorFiles(File[] files, Collection errorFiles) {
        if (errorFiles.size() == 0) {
            return files;
        }
        LinkedList<File> files2 = new LinkedList<File>();
        for (int i2 = 0; i2 < files.length; ++i2) {
            files2.addLast(files[i2]);
        }
        files2.removeAll(errorFiles);
        files = new File[files2.size()];
        Iterator it = files2.iterator();
        int i3 = 0;
        while (it.hasNext()) {
            files[i3] = (File)it.next();
            ++i3;
        }
        return files;
    }

    ImageInfo getImageInfo(File file) throws IOException {
        ImageInfo ii = new ImageInfo();
        FileInputStream fis = new FileInputStream(file);
        ii.setCollectComments(true);
        ii.setInput(fis);
        ii.setEncoding(this.textEncoding);
        if (!ii.check()) {
            throw new IOException(Msg.getString("engine.unsupportedFileFormatError") + file.getName());
        }
        fis.close();
        return ii;
    }

    private String getOriginalPath(File file, File fromDir, boolean inSlides) {
        String fromSlides = inSlides ? "../" : "";
        String path = this.outputDirectory.equals(this.directory) || this.copyOriginals || this.imageLinking == LINK_SCALED ? fromSlides + this.encode(file.getName()) : this.attemptRelativePath(file, fromDir);
        return path;
    }

    private String attemptRelativePath(File file, File fromDir) {
        String rel = IO.relativePath(file, fromDir);
        File relativeFile = new File(rel);
        if (relativeFile.isAbsolute()) {
            return "file:" + rel;
        }
        return this.encode(rel);
    }

    static Map getFolderProperties(File dir2) throws IOException {
        File mapFile = new File(dir2, "meta.properties");
        if (mapFile.exists()) {
            Map props = IO.readMapFile(mapFile);
            Iterator it = props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e2 = it.next();
                if (!((String)e2.getValue()).equals("")) continue;
                it.remove();
            }
            return props;
        }
        return new HashMap();
    }

    File getFolderThumbnailFile(File file) {
        File f2 = this.doGetFolderThumbnailFile(file);
        if (f2 == null && this.useThumbForFolderIcon) {
            try {
                File[] files = this.listFiles(file, false, this.rootOutputDir);
                for (int i2 = 0; i2 < files.length; ++i2) {
                    if (!FileFilters.isFileSupported(files[i2])) continue;
                    return files[i2];
                }
            }
            catch (IOException ex) {
                return null;
            }
        }
        return f2;
    }

    private File makeFile(File dir2, String path) {
        File f2 = new File(dir2, path);
        if (f2.exists()) {
            return f2;
        }
        FileCollection fc = new FileCollection(this, dir2);
        File[] files = fc.listFiles(new AlbumFileFilter(this, null, this.ignorePattern), true);
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (!files[i2].getName().equals(path)) continue;
            return files[i2];
        }
        return null;
    }

    private File doGetFolderThumbnailFile(File file) {
        try {
            Map props = AlbumBean.getFolderProperties(file);
            String fileName = (String)props.get("folderIcon");
            if (AlbumBean.exists(fileName)) {
                File f2;
                String directoryName = (String)props.get("folderIconDirectory");
                File dir2 = file;
                if (AlbumBean.exists(directoryName)) {
                    dir2 = new File(file, directoryName);
                }
                if ((f2 = this.makeFile(dir2, fileName)) == null || !f2.exists()) {
                    return null;
                }
                if (f2.isDirectory()) {
                    return this.getFolderThumbnailFile(f2);
                }
                return f2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private File addImageLinks(File file, Scope vars, File outputDir, File fromDir, boolean inSlides) throws IOException {
        String thumbPath;
        String imagePath;
        File representingFile;
        String toSlides = inSlides ? "" : this.slideDirectory + "/";
        String fromSlides = inSlides ? "../" : "";
        String fileName = file.getName();
        String label = IO.baseName(fileName);
        String closeupPath = null;
        String originalPath = null;
        String iconPath = null;
        String resPath = this.resDir != null ? IO.relativePath(this.resDir, fromDir) : fromSlides + GIFS_DIR;
        File thmFile = new File(file.getParentFile(), IO.baseName(file.getName()) + ".THM");
        if (file.isDirectory()) {
            closeupPath = fromSlides + this.encode(file.getName()) + "/" + this.getJAlbumWeb();
            AlbumObject ao = this.albumObjectFactory.createInstance(file);
            representingFile = ao.getRepresentingIconFile();
            if (representingFile != null) {
                File to = representingFile instanceof LinkFile ? ((LinkFile)representingFile).getLink() : representingFile;
                String path = IO.relativePath(to.getParentFile(), file);
                if (".".equals(path)) {
                    path = "";
                }
                path = IO.combinePaths(file.getName(), path);
                path = IO.combinePaths(path, this.thumbDirectory);
                path = IO.combinePaths(path, this.thumbnailPrefix + AlbumBean.jpegName(representingFile.getName()));
                thumbPath = imagePath = this.encode(path);
            } else {
                iconPath = imagePath = resPath + '/' + FOLDER_FILE;
                thumbPath = imagePath;
                representingFile = new File(this.srcResDir, FOLDER_FILE);
            }
        } else if (!AlbumBean.isSupported(file)) {
            closeupPath = originalPath = this.getOriginalPath(file, fromDir, inSlides);
            if (thmFile.exists()) {
                thumbPath = fromSlides + this.thumbDirectory + "/" + this.thumbnailPrefix + this.encode(AlbumBean.jpegName(fileName));
                imagePath = toSlides + this.encode(AlbumBean.jpegName(fileName));
                representingFile = thmFile;
            } else {
                representingFile = FileFilters.getIconFor(file, this);
                IO.copyFile(representingFile, this.resDir, false);
                iconPath = imagePath = resPath + '/' + representingFile.getName();
                thumbPath = imagePath;
            }
        } else {
            thumbPath = fromSlides + this.thumbDirectory + "/" + this.thumbnailPrefix + this.encode(AlbumBean.jpegName(fileName));
            representingFile = thmFile.exists() ? thmFile : file;
            if (this.slides || this.imageLinking == LINK_ORIGINALS_VIA_SCALED) {
                closeupPath = toSlides + this.encode(label) + this.pageExtension;
            }
            if (this.imageLinking == LINK_ORIGINALS) {
                imagePath = this.getOriginalPath(file, fromDir, inSlides);
                if (!this.slides) {
                    closeupPath = imagePath;
                }
            } else if (this.imageLinking == LINK_ORIGINALS_VIA_SCALED) {
                imagePath = toSlides + this.encode(AlbumBean.jpegName(fileName));
                originalPath = this.getOriginalPath(file, fromDir, inSlides);
            } else {
                imagePath = toSlides + this.encode(AlbumBean.jpegName(fileName));
                if (!this.slides) {
                    closeupPath = toSlides + this.encode(AlbumBean.jpegName(fileName));
                }
            }
        }
        vars.put("thumbPath", thumbPath);
        if (iconPath != null) {
            vars.put("iconPath", iconPath);
        }
        vars.put("closeupPath", closeupPath);
        vars.put("imagePath", imagePath);
        if (originalPath != null) {
            vars.put("originalPath", originalPath);
        }
        vars.put("representingFile", representingFile);
        return representingFile;
    }

    void addGlobals(Map vars) {
        vars.put("generator", "JAlbum 7.2");
        vars.put("generatorUrl", "http://jalbum.net");
        vars.put("internalVersion", PRODUCT_INTERNAL_VERSION);
        vars.put("styleFile", STYLES_FILE);
        vars.put("skin", this.skin);
        if (this.style != null) {
            vars.put("style", this.style);
        }
        vars.put("maxImageWidth", new Integer(this.imageDim.width));
        vars.put("maxImageHeight", new Integer(this.imageDim.height));
        vars.put("maxThumbWidth", new Integer(this.thumbDim.width));
        vars.put("maxThumbHeight", new Integer(this.thumbDim.height));
        vars.put("rows", new Integer(this.rows));
        vars.put("cols", new Integer(this.cols));
        vars.put("engine", this);
        vars.put("window", JAlbum.mainFrame);
        if (JAlbum.mainFrame != null) {
            vars.put("explorer", JAlbum.mainFrame.albumExplorer.explorer);
        }
        vars.put("album", this.album);
        vars.put("application", application);
        vars.put("programDirectory", this.cfg.progDir.getAbsoluteFile());
        vars.put("skinDirectory", this.skinDir);
        vars.put("rootImageDirectory", this.rootImageDir);
        vars.put("rootOutputDirectory", this.rootOutputDir);
        if (this.resDir != null) {
            vars.put("resDirectory", this.resDir);
        }
        if (this.srcResDir != null) {
            vars.put("skinResDirectory", this.srcResDir);
        }
        vars.put("currentDate", this.df.format(new Date()));
        int tf = this.totalFiles;
        if (this.updatedDirsOnly) {
            try {
                tf = this.countFiles(new File(this.directory));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        vars.put("totalAlbumImages", new Integer(tf));
        vars.put("textEncoding", this.writeUTF8 ? "UTF-8" : this.textEncoding);
        this.addInternationalTexts(vars);
    }

    String readComment(File file, File imageDir, Metadata metadata) {
        File commentFile;
        String comment = null;
        if (metadata != null) {
            try {
                String iptcComment;
                Directory directory;
                if (metadata.containsDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = AlbumBean.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory)) {
                    this.formatter.setMetadata(metadata);
                    this.formatter.setDateFormat(this.df);
                    directory = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = AlbumBean.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
                    ExifDescriptor desc = new ExifDescriptor(directory);
                    if (this.exifUserComment) {
                        comment = desc.getUserCommentDescription();
                    }
                    if (this.exifImageDescription && !AlbumBean.exists(comment)) {
                        comment = (String)this.formatter.format(270);
                    }
                }
                if (this.iptcCaption && metadata.containsDirectory(class$com$drew$metadata$iptc$IptcDirectory == null ? (class$com$drew$metadata$iptc$IptcDirectory = AlbumBean.class$("com.drew.metadata.iptc.IptcDirectory")) : class$com$drew$metadata$iptc$IptcDirectory) && AlbumBean.exists(iptcComment = (directory = metadata.getDirectory(class$com$drew$metadata$iptc$IptcDirectory == null ? (class$com$drew$metadata$iptc$IptcDirectory = AlbumBean.class$("com.drew.metadata.iptc.IptcDirectory")) : class$com$drew$metadata$iptc$IptcDirectory)).getString(632))) {
                    comment = iptcComment;
                }
            }
            catch (MetadataException ex) {
                // empty catch block
            }
        }
        if (this.jpegComment) {
            try {
                ImageInfo ii = this.getImageInfo(file);
                String jpegComment = "";
                int ncomm = ii.getNumberOfComments();
                for (int i2 = 0; i2 < ncomm; ++i2) {
                    if (i2 > 0) {
                        jpegComment = jpegComment + ", ";
                    }
                    jpegComment = jpegComment + ii.getComment(i2);
                }
                if (AlbumBean.exists(jpegComment) && !AlbumBean.isCopyright(jpegComment)) {
                    comment = jpegComment;
                }
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
        if (this.textFileComment && (commentFile = new File(imageDir, "comments.properties")).exists()) {
            try {
                Map comments = IO.readMapFile(commentFile);
                String textFileComment = (String)comments.get(file.getName());
                if (textFileComment != null) {
                    comment = textFileComment;
                }
            }
            catch (IOException ex1) {
                // empty catch block
            }
        }
        return comment != null ? comment : "";
    }

    private void addInternationalTexts(Map vars) {
        try {
            Locale locale = this.extras.containsKey("language") ? new Locale((String)this.extras.get("language"), "") : Locale.getDefault();
            SmartResourceBundle texts = null;
            try {
                texts = SmartResourceBundle.getBundle(new File(this.skinDir, "texts"), "texts", locale);
            }
            catch (MissingResourceException ex) {
                texts = SmartResourceBundle.getBundle(this.skinDir, "texts", locale);
            }
            Iterator it = texts.getKeys().iterator();
            while (it.hasNext()) {
                String k2 = (String)it.next();
                vars.put("text." + k2, texts.getString(k2));
            }
            vars.put("texts", texts);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private static boolean isCopyright(String s2) {
        return s2.startsWith("ACD Systems Digital Imaging") || s2.startsWith("LEAD Technologies") || s2.startsWith("AppleMark") || s2.startsWith("Intel(R) JPEG Library") || s2.startsWith("Created with The GIMP") || s2.startsWith("ASCII") || s2.startsWith("OLYMPUS DIGITAL CAMERA") || s2.startsWith("KONICA MINOLTA") || s2.startsWith("File written by Adobe Photoshop");
    }

    private void registerFolderVariables(File file, Scope vars) throws IOException {
        Map fp = AlbumBean.getFolderProperties(file);
        String desc = (String)fp.get("descript");
        if (desc != null) {
            fp.put("description", desc);
        }
        fp.remove("descript");
        String title = (String)fp.get("title");
        if (title != null) {
            fp.put("folderTitle", title);
        } else {
            fp.put("title", file.getName());
        }
        vars.putAll(fp);
    }

    public void registerVariables(File file, File outputDir) throws IOException {
        this.registerVariables(file, outputDir, true);
    }

    private void registerVariables(File file, File outputDir, boolean calculateSizes) throws IOException {
        int originalHeight;
        int originalWidth;
        File representingFile;
        String ext;
        Scope vars = (Scope)this.fileVariables.get(file);
        if (vars == null) {
            vars = new Scope(this.globalVariables);
            this.fileVariables.put(file, vars);
        }
        String fileName = file.getName();
        vars.put("fileName", fileName);
        vars.put("fileDate", new FormattedDate(file.lastModified(), this.df));
        if (!file.isDirectory()) {
            vars.put("fileSize", new Long(file.length()));
            vars.put("label", IO.baseName(fileName));
        } else {
            vars.put("folder", (Object)true);
            vars.put("label", fileName);
            this.registerFolderVariables(file, vars);
        }
        if (AlbumBean.isSupported(file)) {
            if (this.metaData) {
                try {
                    Metadata imageInfo = JpegMetadataReader.readMetadata(file);
                    if (imageInfo != null) {
                        this.addImageInfo(file, imageInfo, vars);
                        vars.put("orientation", RotationSupport.getOrientationAsString(file));
                    }
                }
                catch (MetadataException ex) {
                }
                catch (JpegProcessingException ex) {
                    System.err.println(ex);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    System.err.println(ex);
                }
                catch (IOException ex) {
                    System.err.println(ex);
                }
            } else {
                try {
                    vars.put("orientation", RotationSupport.getOrientationAsString(file));
                }
                catch (IOException ex) {
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    System.err.println(ex);
                }
            }
        }
        if ((ext = IO.extensionOf(representingFile = this.addImageLinks(file, vars, outputDir, outputDir, false)).toLowerCase()).equals("gif")) {
            ImageInfo ii = this.getImageInfo(representingFile);
            originalWidth = ii.getWidth();
            originalHeight = ii.getHeight();
            vars.put("formatName", ii.getFormatName());
        } else {
            FileImageInputStream iis = new FileImageInputStream(representingFile);
            Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
            if (!it.hasNext()) {
                throw new IOException("Unsupported file format for " + representingFile);
            }
            ImageReader reader = it.next();
            reader.setInput(iis, true, true);
            int minIndex = reader.getMinIndex();
            originalWidth = reader.getWidth(minIndex);
            originalHeight = reader.getHeight(minIndex);
            vars.put("formatName", reader.getFormatName());
            reader.dispose();
            iis.close();
        }
        if (this.jpegComment) {
            this.addOldJPEGComment(representingFile, vars);
        }
        vars.put("originalWidth", new Integer(originalWidth));
        vars.put("originalHeight", new Integer(originalHeight));
        if (calculateSizes) {
            this.addFilteredImageSizes(file, vars);
        }
    }

    private void addOldJPEGComment(File file, Map vars) {
        try {
            ImageInfo ii = this.getImageInfo(file);
            String comment = "";
            int ncomm = ii.getNumberOfComments();
            for (int i2 = 0; i2 < ncomm; ++i2) {
                if (i2 > 0) {
                    comment = comment + ", ";
                }
                comment = comment + ii.getComment(i2);
            }
            if (AlbumBean.exists(comment) && !AlbumBean.isCopyright(comment)) {
                vars.put("comment", comment);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Collection registerVariables(File imageDir, File[] files, File outputDir) {
        LinkedList<File> errorFiles = new LinkedList<File>();
        File commentFile = new File(imageDir, "comments.properties");
        Map comments = new HashMap();
        if (commentFile.exists()) {
            try {
                comments = IO.readMapFile(commentFile);
            }
            catch (IOException ex1) {
                // empty catch block
            }
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            try {
                String comment;
                Scope vars = new Scope(this.globalVariables);
                this.fileVariables.put(files[i2], vars);
                this.registerVariables(files[i2], outputDir, false);
                if (!this.textFileComment || (comment = (String)comments.get(files[i2].getName())) == null) continue;
                vars.put("comment", comment);
                continue;
            }
            catch (Throwable t2) {
                t2.printStackTrace(System.err);
                errorFiles.add(files[i2]);
                this.fireErrorOccured(t2, files[i2]);
            }
        }
        return errorFiles;
    }

    public void processBeanShellFile(File f2) throws ElementException, IOException {
        this.globalVariables = new Scope();
        this.addGlobals(this.globalVariables);
        this.globalVariables = this.globalVariables.push(this.extras);
        this.processBeanShellFile(f2, this.globalVariables);
    }

    void processBeanShellFile(File f2, Map vars) throws ElementException, IOException {
        if (f2.exists()) {
            String content = IO.readTextFile(f2);
            this.processExpression(content, vars);
        }
    }

    Object processExpression(String expr) throws ElementException {
        Scope vars = new Scope(this.globalVariables);
        vars = vars.push(this.extras);
        return this.processExpression(expr, vars);
    }

    Object processExpression(String expr, Map vars) throws ElementException {
        AlbumBean.setVars(vars, this.interpreter);
        return this.doProcessExpression(expr);
    }

    Object doProcessExpression(String expr) throws ElementException {
        try {
            return this.interpreter.eval(expr);
        }
        catch (ParseException e2) {
            throw new ElementException(e2.getMessage() + "\n\nDetails:\n" + e2.getErrorSourceFile());
        }
        catch (TargetError e3) {
            Throwable t2 = e3.getTarget();
            if (t2 instanceof OperationAbortedException) {
                throw (OperationAbortedException)t2;
            }
            String s2 = "Exception caused by line " + e3.getErrorLineNumber() + ": " + e3.getTarget() + "\n\nDetails:\n" + e3.getMessage();
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            e3.getTarget().printStackTrace(out);
            out.close();
            throw new ElementException(s2 + "\n\nStack trace:\n" + sw.toString());
        }
        catch (EvalError e4) {
            throw new ElementException("Evaluation error on line " + e4.getErrorLineNumber() + ":\n\nDetails:\n" + e4.getMessage());
        }
    }

    public int countFiles(File dir2) throws IOException {
        int counter = 0;
        FileCollection fc = new FileCollection(this, dir2);
        File[] filesDirs = fc.listFiles(new AlbumFileFilter(this, this.getInterpretedOutputDirectory(), this.ignorePattern));
        if (filesDirs == null) {
            return 0;
        }
        for (int i2 = 0; i2 < filesDirs.length; ++i2) {
            if (filesDirs[i2].isDirectory()) {
                if (!this.subdirs) continue;
                counter += this.countFiles(filesDirs[i2]);
                continue;
            }
            ++counter;
        }
        return counter;
    }

    int countChangedFiles(File inputDir, File outputDir) throws IOException {
        int counter = 0;
        FileCollection fc = new FileCollection(this, inputDir);
        File[] inputSubFiles = fc.listFiles(new AlbumFileFilter(this, this.getInterpretedOutputDirectory(), this.ignorePattern));
        if (inputSubFiles == null) {
            return 0;
        }
        for (int i2 = 0; i2 < inputSubFiles.length; ++i2) {
            File inputSubFile = inputSubFiles[i2];
            if (inputSubFile.isDirectory()) {
                File outputSubDir = new File(outputDir, inputSubFile.getName());
                if (!this.subdirs || !this.needsToProcessDir(inputSubFile, outputSubDir)) continue;
                counter += this.countChangedFiles(inputSubFiles[i2], outputSubDir);
                continue;
            }
            ++counter;
        }
        return counter;
    }

    public void init() throws ParameterException, IOException, OperationAbortedException, ElementException {
        this.makeAlbum(false);
    }

    public void makeAlbum() throws ParameterException, IOException, OperationAbortedException, ElementException {
        this.makeAlbum(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeAlbum(boolean doMake) throws ParameterException, IOException, OperationAbortedException, ElementException {
        this.startTime = System.currentTimeMillis();
        this.myAssert(this.directory != null, Msg.getString("engine.missingDirectoryError"));
        if (!this.sameDirectory) {
            this.myAssert(this.outputDirectory != null, Msg.getString("engine.missingOutputDirectoryError"));
        } else {
            this.outputDirectory = this.directory;
        }
        this.myAssert(this.thumbSize != null, Msg.getString("engine.missingThumbSizeError"));
        this.myAssert(this.imageSize != null, Msg.getString("engine.missingImageSizeError"));
        File inputDir = new File(this.directory);
        File outputDir = null;
        if (this.directory != null && this.directory.length() > 0 || doMake) {
            if (!inputDir.isDirectory()) {
                throw new IOException(Msg.getString("engine.notADirectoryError"));
            }
            outputDir = this.getInterpretedOutputDirectory();
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            this.rootImageDir = inputDir;
            this.rootOutputDir = outputDir;
        }
        this.srcResDir = new File(this.skinDir, "res");
        if (this.srcResDir.exists()) {
            this.resDir = new File(this.rootOutputDir, this.resourceDirectory);
            if (this.resDir.exists() && this.cfg.isCleanOutputFiles() && !this.appendImages) {
                this.cleanDirectoryTree(this.resDir);
            }
        } else {
            this.resDir = null;
            this.srcResDir = new File(this.skinDir, GIFS_DIR);
        }
        this.processedFiles = 0;
        this.totalFiles = this.countChangedFiles(inputDir, outputDir);
        this.fileVariables = new PrintSafeHashMap();
        this.album = new PrintSafeHashMap();
        this.df = this.dateFormat != null && !this.dateFormat.equals("") ? new SimpleDateFormat(this.dateFormat) : new SimpleDateFormat();
        if (!doMake) {
            return;
        }
        this.albumObjectFactory = new AlbumObjectFactory(this);
        this.initInterpreter();
        this.parser = new TemplateParser();
        this.globalVariables = new Scope();
        this.addGlobals(this.globalVariables);
        this.globalVariables = this.globalVariables.push(this.extras);
        this.processBeanShellFile(new File(this.cfg.progDir, "system/init.bsh"), this.globalVariables);
        this.parser.putAll(this.globalVariables);
        this.processBeanShellFile(new File(this.skinDir, "init.bsh"), this.globalVariables);
        if (this.imageLinking == LINK_ORIGINALS_VIA_SCALED) {
            this.setSlides(true);
        }
        try {
            File framesetFile = new File(this.skinDir, "frameset.htt");
            if (framesetFile.exists()) {
                this.frames = true;
                this.framesetPageName = this.indexPageName;
                this.indexPageName = this.indexPageName + "-frame";
            }
            this.makeAlbumForDirectory(inputDir, outputDir, 0);
        }
        finally {
            if (this.frames) {
                this.frames = false;
                this.indexPageName = this.framesetPageName;
                this.framesetPageName = null;
            }
        }
        inputDir = null;
    }

    public boolean imageUpdate(Image img, int infoflags, int x2, int y2, int width, int height) {
        return (infoflags & 0x20) == 0;
    }

    private void makeIndexPages(File imageDir, File outputDir, File[] files, File[] filesOnly, int level) throws IOException, ElementException {
        File framesetFile;
        this.files = files;
        this.imagesPerIndex = this.rows * this.cols;
        if (this.rows == 0) {
            this.imagesPerIndex = 999;
        }
        int totalIndexes = (int)Math.ceil((double)files.length / (double)this.imagesPerIndex);
        if (files.length == 0) {
            return;
        }
        Scope dirVars = new Scope(this.globalVariables);
        dirVars.put("level", new Integer(level));
        this.registerFolderVariables(imageDir, dirVars);
        dirVars.put("imageDirectory", imageDir);
        dirVars.put("outputDirectory", outputDir);
        dirVars.put("firstIndexPage", this.encode(this.getIndexName(0)));
        dirVars.put("lastIndexPage", this.encode(this.getIndexName(totalIndexes - 1)));
        dirVars.put("files", files);
        dirVars.put("fileVariables", this.fileVariables);
        dirVars.put("totalImages", new Integer(filesOnly.length));
        dirVars.put("currentDate", this.df.format(new Date()));
        Map parentVars = (Map)this.fileVariables.get(imageDir);
        if (parentVars != null && !this.frames) {
            dirVars.put("parentIndexPage", "../" + parentVars.get("indexPage"));
        } else {
            String parentWeb = this.getExistingWeb(outputDir.getParentFile());
            if (parentWeb != null) {
                dirVars.put("parentIndexPage", "../" + parentWeb);
            }
        }
        dirVars.put("rootPath", IO.relativePath(this.rootOutputDir, outputDir));
        dirVars.put("resPath", this.resDir != null ? IO.relativePath(this.resDir, outputDir) : GIFS_DIR);
        dirVars.put("stylePath", this.resDir != null ? IO.relativePath(this.resDir, outputDir) + '/' + STYLES_FILE : STYLES_FILE);
        if (this.resDir == null) {
            File styleFile = new File(this.skinDir, "styles/" + this.style);
            if (this.style != null && styleFile.exists()) {
                this.processTemplateFile(styleFile, new File(outputDir, STYLES_FILE), dirVars.push(this.extras));
            }
        }
        if ((framesetFile = new File(this.skinDir, "frameset.htt")).exists()) {
            this.processTemplateFile(framesetFile, new File(outputDir, this.framesetPageName + this.pageExtension), dirVars.push(this.extras));
        }
        this.indexNum = 0;
        while (this.indexNum < totalIndexes) {
            this.indexVariables = new Scope(dirVars);
            this.indexVariables.put("indexPage", this.encode(this.getIndexName(this.indexNum)));
            this.indexImageCount = Math.min(this.imagesPerIndex, files.length - this.indexNum * this.imagesPerIndex);
            this.indexVariables.put("indexImageCount", new Integer(this.indexImageCount));
            this.currentRows = (int)Math.ceil((double)this.indexImageCount / (double)this.cols);
            this.indexVariables.put("currentRows", new Integer(this.currentRows));
            if (totalIndexes > 1) {
                this.indexVariables.put("indexNum", new Integer(this.indexNum + 1));
                this.indexVariables.put("totalIndexes", new Integer(totalIndexes));
                if (this.indexNum > 0) {
                    this.indexVariables.put("previousIndexPage", this.encode(this.getIndexName(this.indexNum - 1)));
                }
                if (this.indexNum < totalIndexes - 1) {
                    this.indexVariables.put("nextIndexPage", this.encode(this.getIndexName(this.indexNum + 1)));
                }
            }
            for (int i2 = this.indexNum * this.imagesPerIndex; i2 < files.length && i2 < this.imagesPerIndex * (this.indexNum + 1); ++i2) {
                Scope locals = (Scope)this.fileVariables.get(files[i2]);
                locals.setOuter(this.indexVariables);
                locals.put("imageNum", new Integer(i2 + 1));
                locals.put("currentFile", files[i2]);
                locals.put("current", this.fileVariables.get(files[i2]));
                locals.put("local", locals.getMap());
                if (i2 > 0) {
                    locals.put("previous", this.fileVariables.get(files[i2 - 1]));
                }
                if (i2 < files.length - 1) {
                    locals.put("next", this.fileVariables.get(files[i2 + 1]));
                }
                this.addFilteredImageSizes(files[i2], locals);
            }
            Replacer replacer = AlbumBean.fillReplacer(new Replacer(), this.indexVariables.push(this.extras));
            String template = IO.readTextFile(new File(this.skinDir, "index.htt"));
            template = replacer.replace(template);
            StringBuffer buf = new StringBuffer();
            this.parser.reset();
            this.parser.putAll(this.indexVariables.push(this.extras));
            this.parser.parseElements(template, buf);
            String indexContent = buf.toString();
            File f2 = new File(outputDir, this.getIndexName(this.indexNum));
            IO.writeChangedTextFile(indexContent, f2, this.writeUTF8 ? "UTF-8" : this.textEncoding);
            ++this.indexNum;
        }
    }

    private void addFilteredImageSizes(File file, Scope vars) throws IOException {
        AlbumObject ao;
        boolean hasIcon = FileFilters.hasIcon(file);
        File repFile = new File(file.getParentFile(), IO.baseName(file.getName()) + ".THM");
        if (repFile.exists()) {
            hasIcon = false;
        }
        if ((repFile = (ao = this.albumObjectFactory.createInstance(file)).getRepresentingIconFile()) != null) {
            hasIcon = false;
        }
        int originalWidth = (Integer)vars.get("originalWidth");
        int originalHeight = (Integer)vars.get("originalHeight");
        String orientation = (String)vars.get("orientation");
        if (orientation == null && repFile != null) {
            try {
                orientation = RotationSupport.getOrientationAsString(repFile);
            }
            catch (IOException ok) {
            }
            catch (Throwable t2) {
                System.err.println("File " + repFile + " has broken data structures. Orientation data ignored");
            }
        }
        Dimension imageDim = orientation != null && !orientation.equals("normal") && originalWidth > originalHeight ? new Dimension(originalHeight, originalWidth) : new Dimension(originalWidth, originalHeight);
        Dimension closeupDim = imageDim;
        if (this.imageLinking != LINK_ORIGINALS) {
            imageDim = closeupDim = AlbumBean.calcDimension(imageDim.width, imageDim.height, this.imageDim);
            if (!hasIcon) {
                imageDim = this.getFilteredSize(imageDim, vars, 1);
                imageDim = this.getFilteredSize(imageDim, vars, 2);
                closeupDim = this.getFilteredSize(imageDim, vars, 3);
            }
            vars.put("imageWidth", new Integer(closeupDim.width));
            vars.put("imageHeight", new Integer(closeupDim.height));
        } else {
            vars.put("imageWidth", new Integer(originalWidth));
            vars.put("imageHeight", new Integer(originalHeight));
        }
        Dimension thumbDim = AlbumBean.calcDimension(imageDim.width, imageDim.height, this.thumbDim);
        if (!hasIcon) {
            imageDim = this.getFilteredSize(imageDim, vars, 4);
            thumbDim = AlbumBean.calcDimension(imageDim.width, imageDim.height, this.thumbDim);
            thumbDim = this.getFilteredSize(thumbDim, vars, 5);
        }
        vars.put("thumbWidth", new Integer(thumbDim.width));
        vars.put("thumbHeight", new Integer(thumbDim.height));
    }

    static Replacer fillReplacer(Replacer replacer, Map variables) {
        Iterator it = variables.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e2 = it.next();
            if (e2.getValue() == null || e2.getValue() instanceof Map) continue;
            replacer.add("$" + (String)e2.getKey(), e2.getValue().toString());
        }
        return replacer;
    }

    private String getJAlbumWeb() {
        return (this.framesetPageName != null ? this.framesetPageName : this.indexPageName) + this.pageExtension;
    }

    private String getExistingWeb(File dir2) {
        String[] indexFiles = new String[]{this.getJAlbumWeb(), "index.htm", "index.html", "index.jsp", "index.asp", "index.php3"};
        for (int i2 = 0; i2 < indexFiles.length; ++i2) {
            File test = new File(dir2, indexFiles[i2]);
            if (!test.exists()) continue;
            return indexFiles[i2];
        }
        return null;
    }

    public static String jpegName(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return name;
        }
        String ext = name.substring(dotIndex + 1).toLowerCase();
        if (!ext.equals("jpg") && !ext.equals("jpeg")) {
            return name.substring(0, dotIndex) + ".jpg";
        }
        return name;
    }

    private void adjustImageLinks(File outputDir, File[] files) throws IOException {
        if (this.slides) {
            File slidesDir = new File(outputDir, this.slideDirectory);
            String resPath = this.resDir != null ? IO.relativePath(this.resDir, slidesDir) : "../gifs";
            String stylePath = this.resDir != null ? IO.relativePath(this.resDir, slidesDir) + '/' + STYLES_FILE : "../styles.css";
            for (int i2 = 0; i2 < files.length; ++i2) {
                Scope locals = (Scope)this.fileVariables.get(files[i2]);
                locals.put("resPath", resPath);
                locals.put("stylePath", stylePath);
                this.addImageLinks(files[i2], locals, outputDir, new File(outputDir, this.slideDirectory), true);
                locals.put("files", files);
                locals.put("current", this.fileVariables.get(files[i2]));
                locals.put("local", locals.getMap());
                if (i2 > 0) {
                    locals.put("previous", this.fileVariables.get(files[i2 - 1]));
                }
                if (i2 < files.length - 1) {
                    locals.put("next", this.fileVariables.get(files[i2 + 1]));
                }
                locals.put("imageNum", new Integer(i2 + 1));
                locals.put("currentFile", files[i2]);
                locals.put("totalImages", new Integer(files.length));
                if (i2 > 0) {
                    locals.put("previousPage", this.encode(this.getSlideName(files[i2 - 1])));
                }
                locals.put("currentPage", this.encode(this.getSlideName(files[i2])));
                if (i2 < files.length - 1) {
                    locals.put("nextPage", this.encode(this.getSlideName(files[i2 + 1])));
                }
                locals.put("firstPage", this.encode(this.getSlideName(files[0])));
                locals.put("lastPage", this.encode(this.getSlideName(files[files.length - 1])));
            }
        }
    }

    private void makeThumbs(Counter c2, File dir2, File outputDir, File[] files) throws IOException, OperationAbortedException, ElementException {
        File thumbsDir = new File(outputDir, this.thumbDirectory);
        thumbsDir.mkdir();
        int i2 = c2.next();
        while (i2 < files.length) {
            Scope locals = (Scope)this.fileVariables.get(files[i2]);
            if (!this.outputDirectory.equals(this.directory) && (this.copyOriginals && this.imageLinking != LINK_SCALED || this.imageLinking == LINK_SCALED && !AlbumBean.isSupported(files[i2]))) {
                IO.copyFile(files[i2], outputDir, !this.appendImages);
            }
            if (this.slides) {
                this.makeSlide(files, i2);
            }
            AlbumBeanEvent eventObject = new AlbumBeanEvent(this, dir2, IO.relativePath(dir2, this.rootImageDir.getParentFile()), files[i2].getName(), i2 + 1, files.length, this.processedFiles, this.totalFiles);
            this.fireImageProcessingStarted(eventObject);
            File file = files[i2];
            File repFile = new File(file.getParentFile(), IO.baseName(file.getName()) + ".THM");
            if (repFile.exists()) {
                file = repFile;
            }
            if (repFile.exists() || AlbumBean.isSupported(files[i2])) {
                if (eventObject.isAborted()) {
                    throw new OperationAbortedException();
                }
                File thumbFile = new File(thumbsDir, this.thumbnailPrefix + AlbumBean.jpegName(files[i2].getName()));
                File scaledFile = new File(this.slidesDir, this.closeupPrefix + AlbumBean.jpegName(files[i2].getName()));
                try {
                    Graphics g2;
                    BufferedImage bi2;
                    BufferedImage original;
                    if (!this.appendImages || AlbumBean.isDirty(thumbFile, file) || this.imageLinking != LINK_ORIGINALS && AlbumBean.isDirty(scaledFile, file)) {
                        original = FileFilters.loadImage(file, this);
                        if (original.getWidth() > original.getHeight()) {
                            original = RotationSupport.adjustOrientation(original, (String)locals.get("orientation"));
                        }
                        if (this.imageLinking != LINK_ORIGINALS) {
                            bi2 = this.processFilters(original, locals, 1);
                            bi2 = this.scaleToFit(bi2, this.imageDim, this.getScalingMethod());
                            bi2 = this.processFilters(bi2, locals, 2);
                            original.flush();
                            original = bi2;
                            BufferedImage tmpImage = this.processFilters(bi2, locals, 3);
                            if (repFile.exists()) {
                                if (tmpImage == bi2) {
                                    tmpImage = AlbumBean.copyImage(bi2);
                                }
                                g2 = tmpImage.getGraphics();
                                g2.drawImage(filmImage, 1, 2, null);
                                g2.dispose();
                            }
                            IIOMetadata meta = null;
                            if (this.keepMetaData) {
                                ImageInputStream iis = ImageIO.createImageInputStream(file);
                                Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix(IO.extensionOf(file));
                                if (it.hasNext()) {
                                    ImageReader ir = it.next();
                                    ir.setInput(iis);
                                    meta = ir.getImageMetadata(ir.getMinIndex());
                                }
                            }
                            FileFilters.saveJPEG(tmpImage, scaledFile, this, meta);
                            this.lastImageSize = this.imageSize;
                        }
                    } else {
                        original = null;
                    }
                    if (!this.appendImages || AlbumBean.isDirty(thumbFile, file)) {
                        bi2 = this.processFilters(original, locals, 4);
                        BufferedImage thumb = this.scaleToFit(bi2, this.thumbDim, this.highQualityThumbs ? SCALE_SMOOTH : this.getScalingMethod());
                        if (repFile.exists()) {
                            g2 = thumb.getGraphics();
                            g2.drawImage(filmImage, 1, 2, null);
                            g2.dispose();
                        }
                        bi2 = this.processFilters(thumb, locals, 5);
                        FileFilters.saveJPEG(bi2, thumbFile, this);
                        this.lastThumbSize = this.thumbSize;
                    }
                }
                catch (Exception ex) {
                    this.fireErrorOccured(ex, files[i2]);
                }
            }
            eventObject = new AlbumBeanEvent(this, outputDir, IO.relativePath(dir2, this.rootImageDir.getParentFile()), files[i2].getName(), i2 + 1, files.length, ++this.processedFiles, this.totalFiles);
            this.fireImageProcessingFinished(eventObject);
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            i2 = c2.next();
        }
    }

    private static boolean isDirty(File dest, File source) {
        if (!dest.exists()) {
            return true;
        }
        return source.lastModified() > dest.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSlide(File[] files, int i2) throws IOException, ElementException {
        Scope locals = (Scope)this.fileVariables.get(files[i2]);
        Scope allLocals = locals.push(this.extras);
        locals.put("currentDate", this.df.format(new Date()));
        Replacer replacer = AlbumBean.fillReplacer(new Replacer(), allLocals);
        String template = IO.readTextFile(new File(this.skinDir, "slide.htt"));
        template = replacer.replace(template);
        TemplateParser templateParser = this.parser;
        synchronized (templateParser) {
            this.parser.reset();
            this.parser.putAll(allLocals);
            String slideContent = this.parser.parseElements(template);
            File f2 = new File(this.slidesDir, this.getSlideName(files[i2]));
            IO.writeChangedTextFile(slideContent, f2, this.writeUTF8 ? "UTF-8" : this.textEncoding);
        }
    }

    private void addImageInfo(File file, Metadata metadata, Map variables) throws MetadataException {
        this.formatter.setMetadata(metadata);
        this.formatter.setDateFormat(this.df);
        if (metadata.containsDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = AlbumBean.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory)) {
            Directory dir2 = metadata.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = AlbumBean.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
            ExifDescriptor desc = new ExifDescriptor(dir2);
            String comment = null;
            if (this.exifUserComment) {
                comment = desc.getUserCommentDescription();
            }
            if (this.exifImageDescription && !AlbumBean.exists(comment)) {
                comment = (String)this.formatter.format(270);
            }
            variables.put("comment", comment);
            variables.put("originalDate", this.formatter.format(36867));
            variables.put("resolution", this.formatter.format(40962) + " x " + this.formatter.format(40963));
            variables.put("flash", desc.getFlashDescription());
            variables.put("focalLength", this.formatter.format(37386));
            variables.put("exposureTime", this.formatter.format(33434));
            variables.put("aperture", this.formatter.format(33437));
            variables.put("focusDistance", this.formatter.format(37382));
            variables.put("meteringMode", desc.getDescription(37383));
            variables.put("cameraMake", this.formatter.format(271));
            variables.put("cameraModel", this.formatter.format(272));
            variables.put("sensorType", this.formatter.format(41495));
            variables.put("compressionLevel", this.formatter.format(37122));
            variables.put("originalWidthDpi", this.formatter.format(282));
            variables.put("originalHeightDpi", this.formatter.format(283));
            variables.put("isoEquivalent", this.formatter.format(34855));
            variables.put("orientation", dir2.getString(274));
        }
        String author = "";
        String objectName = "";
        String keywords = "";
        String copyright = "";
        String category = "";
        if (metadata.containsDirectory(class$com$drew$metadata$iptc$IptcDirectory == null ? (class$com$drew$metadata$iptc$IptcDirectory = AlbumBean.class$("com.drew.metadata.iptc.IptcDirectory")) : class$com$drew$metadata$iptc$IptcDirectory)) {
            Directory dir3 = metadata.getDirectory(class$com$drew$metadata$iptc$IptcDirectory == null ? (class$com$drew$metadata$iptc$IptcDirectory = AlbumBean.class$("com.drew.metadata.iptc.IptcDirectory")) : class$com$drew$metadata$iptc$IptcDirectory);
            String iptcComment = dir3.getString(632);
            if (this.iptcCaption && AlbumBean.exists(iptcComment)) {
                variables.put("comment", iptcComment);
            }
            author = dir3.getString(634);
            objectName = dir3.getString(517);
            keywords = dir3.getString(537);
            copyright = dir3.getString(628);
            category = dir3.getString(527);
        }
        variables.put("author", author);
        variables.put("objectName", objectName);
        variables.put("keywords", keywords);
        variables.put("copyright", copyright);
        variables.put("category", category);
        if (metadata.containsDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = AlbumBean.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory) || metadata.containsDirectory(class$com$drew$metadata$iptc$IptcDirectory == null ? (class$com$drew$metadata$iptc$IptcDirectory = AlbumBean.class$("com.drew.metadata.iptc.IptcDirectory")) : class$com$drew$metadata$iptc$IptcDirectory)) {
            variables.put("meta", new MetaObjectCache(file, null));
        }
    }

    static Map getMetaObjectContent(Metadata imageInfo) {
        PrintSafeHashMap meta = new PrintSafeHashMap();
        Iterator dirs = imageInfo.getDirectoryIterator();
        while (dirs.hasNext()) {
            Directory dir2 = (Directory)dirs.next();
            String prefix = dir2.getName() + ".";
            if (prefix.equalsIgnoreCase("exif.")) {
                prefix = "";
            }
            Iterator it = dir2.getTagIterator();
            while (it.hasNext()) {
                Tag tag = (Tag)it.next();
                try {
                    meta.put(prefix + tag.getTagName(), tag.getDescription());
                }
                catch (MetadataException ex) {}
            }
        }
        return meta;
    }

    private static boolean exists(String s2) {
        return s2 != null && s2.trim().length() > 0;
    }

    private String getSlideName(File file) {
        String imageFileName = file.getName();
        String base = IO.baseName(imageFileName);
        return base + this.pageExtension;
    }

    private String getIndexName(int indexNum) {
        if (indexNum == 0) {
            return this.indexPageName + this.pageExtension;
        }
        return this.indexPageName + (indexNum + 1) + this.pageExtension;
    }

    BufferedImage createBufferedImage(Image img) {
        int iw = img.getWidth(this);
        int ih = img.getHeight(this);
        return this.createBufferedImage(img, iw, ih);
    }

    private BufferedImage createBufferedImage(Image img, int iw, int ih) {
        BufferedImage bi2 = new BufferedImage(iw, ih, 1);
        Graphics2D g2 = bi2.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        img.flush();
        return bi2;
    }

    static Dimension calcDimension(int width, int height, Dimension boundingBox) {
        if (width <= boundingBox.width && height <= boundingBox.height) {
            return new Dimension(width, height);
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        return new Dimension((int)((double)width / maxScale), (int)((double)height / maxScale));
    }

    BufferedImage scaleToFit(Image image, Dimension boundingBox, String method) {
        int width = image.getWidth(this);
        int height = image.getHeight(this);
        if (width <= boundingBox.width && height <= boundingBox.height) {
            return this.createBufferedImage(image);
        }
        double widthScale = (double)width / (double)boundingBox.width;
        double heightScale = (double)height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        int newWidth = (int)((double)width / maxScale);
        int newHeight = (int)((double)height / maxScale);
        ImageScaler scaler = ImageScaler.getScaler(method);
        BufferedImage bufImage = scaler.scale(image, newWidth, newHeight);
        image.flush();
        if (this.sharpenPercent >= 5 && !SCALE_FAST.equals(method)) {
            BufferedImageOp sharpenOp = AlbumBean.getSharpenOperation(this.sharpenPercent);
            bufImage = sharpenOp.filter(bufImage, null);
        }
        try {
            System.gc();
            Thread.sleep(20L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        return bufImage;
    }

    private static BufferedImageOp getSharpenOperation(int percent) {
        float[] sharpenKernel = new float[]{-0.083333336f, -0.25f, -0.083333336f, -0.25f, 2.3333333f, -0.25f, -0.083333336f, -0.25f, -0.083333336f};
        float[] originalKernel = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        float[] resultingKernel = new float[9];
        float w2 = (float)((double)percent / 120.0);
        for (int i2 = 0; i2 < resultingKernel.length; ++i2) {
            resultingKernel[i2] = w2 * sharpenKernel[i2] + (1.0f - w2) * originalKernel[i2];
        }
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, resultingKernel), 1, null);
        return op;
    }

    private void myAssert(boolean test, String msg) throws ParameterException {
        if (!test) {
            throw new ParameterException(msg);
        }
    }

    private static Dimension parseSize(String sizeString) throws ParameterException {
        String size = sizeString.toLowerCase();
        StringTokenizer tokens = new StringTokenizer(size, "x ");
        try {
            int w2 = Integer.parseInt(tokens.nextToken());
            int h2 = Integer.parseInt(tokens.nextToken());
            if (w2 < 0 || h2 < 0) {
                throw new Exception();
            }
            return new Dimension(w2, h2);
        }
        catch (Exception ex) {
            throw new ParameterException(MessageFormat.format(Msg.getString("engine.invalidSizeError"), sizeString));
        }
    }

    private String encode(String s2) {
        if (!this.urlEncode) {
            return s2;
        }
        return IO.urlEncode(s2);
    }

    static boolean isSupported(File file) {
        return FileFilters.isFileSupported(file);
    }

    public synchronized void removeAlbumBeanListener(AlbumBeanListener l2) {
        if (this.albumBeanListeners != null && this.albumBeanListeners.contains(l2)) {
            Vector v2 = (Vector)this.albumBeanListeners.clone();
            v2.removeElement(l2);
            this.albumBeanListeners = v2;
        }
    }

    public synchronized void addAlbumBeanListener(AlbumBeanListener l2) {
        Vector v2;
        Vector vector = v2 = this.albumBeanListeners == null ? new Vector(2) : (Vector)this.albumBeanListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.albumBeanListeners = v2;
        }
    }

    public void addFilter(JAFilter filter) {
        this.addFilter(filter, 2);
    }

    public Iterator filterIterator(int stage) {
        Iterator all = this.filters.iterator();
        LinkedList<JAFilter> matching = new LinkedList<JAFilter>();
        while (all.hasNext()) {
            JAFilterNode node = (JAFilterNode)all.next();
            if (node.stage != stage) continue;
            matching.addLast(node.filter);
        }
        return matching.iterator();
    }

    public boolean addFilter(JAFilter filter, int stage) {
        this.filters.addLast(new JAFilterNode(filter, stage));
        return true;
    }

    public boolean removeFilter(JAFilter filter, int stage) {
        return this.filters.remove(new JAFilterNode(filter, stage));
    }

    public void removeAllFilters() {
        this.filters = new LinkedList();
    }

    private static BufferedImage copyImage(BufferedImage im) {
        BufferedImage bi2 = new BufferedImage(im.getWidth(), im.getHeight(), 1);
        Graphics2D g2 = bi2.createGraphics();
        g2.drawImage((Image)im, 0, 0, null);
        return bi2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage processFilters(BufferedImage im, Scope vars, int stage) {
        vars.put("stage", new Integer(stage));
        vars = vars.push(this.extras);
        boolean isACopy = false;
        Iterator it = this.filters.iterator();
        while (it.hasNext()) {
            JAFilter filter;
            JAFilterNode node = (JAFilterNode)it.next();
            if (node.stage != stage) continue;
            if (stage == 3 && !isACopy) {
                im = AlbumBean.copyImage(im);
                isACopy = true;
            }
            JAFilter jAFilter = filter = node.filter;
            synchronized (jAFilter) {
                im = filter.filter(im, vars);
            }
        }
        return im;
    }

    Dimension getFilteredSize(Dimension size, Scope vars, int stage) {
        vars.put("stage", new Integer(stage));
        vars = vars.push(this.extras);
        Iterator it = this.filters.iterator();
        while (it.hasNext()) {
            JAFilterNode node = (JAFilterNode)it.next();
            if (node.stage != stage || !(node.filter instanceof ModifiesSize)) continue;
            size = ((ModifiesSize)((Object)node.filter)).getModifiedSize(size, vars);
        }
        return size;
    }

    protected void fireImageProcessingStarted(AlbumBeanEvent e2) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((AlbumBeanListener)listeners.elementAt(i2)).imageProcessingStarted(e2);
            }
        }
    }

    protected void fireImageProcessingFinished(AlbumBeanEvent e2) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((AlbumBeanListener)listeners.elementAt(i2)).imageProcessingFinished(e2);
            }
        }
    }

    protected void fireErrorOccured(Throwable t2, File f2) {
        if (this.albumBeanListeners != null) {
            Vector listeners = this.albumBeanListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((AlbumBeanListener)listeners.elementAt(i2)).errorOccured(t2, f2);
            }
        }
    }

    public void setSubdirs(boolean newSubdirs) {
        this.subdirs = newSubdirs;
    }

    public boolean isSubdirs() {
        return this.subdirs;
    }

    public void setAppendImages(boolean newAppendImages) {
        this.appendImages = newAppendImages;
    }

    public boolean isAppendImages() {
        return this.appendImages;
    }

    public void setUpdatedDirsOnly(boolean newUpdatedDirsOnly) {
        this.updatedDirsOnly = newUpdatedDirsOnly;
    }

    public boolean isUpdatedDirsOnly() {
        return this.updatedDirsOnly;
    }

    public void setExcludeByDefault(boolean newExcludeByDefault) {
        this.excludeByDefault = newExcludeByDefault;
    }

    public boolean isExcludeByDefault() {
        return this.excludeByDefault;
    }

    public void setKeepMetaData(boolean newKeepMetaData) {
        this.keepMetaData = newKeepMetaData;
    }

    public boolean isKeepMetaData() {
        return this.keepMetaData;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyle() {
        return this.style;
    }

    public void setIndexPageName(String newIndexPageName) {
        this.indexPageName = newIndexPageName;
    }

    public String getIndexPageName() {
        return this.indexPageName;
    }

    public void setUrlEncode(boolean newUrlEncode) {
        this.urlEncode = newUrlEncode;
    }

    public boolean isUrlEncode() {
        return this.urlEncode;
    }

    public void setImageOrdering(String newImageOrdering) {
        this.imageOrdering = newImageOrdering.equals(ORDER_BY_DATE) ? ORDER_BY_DATE : (newImageOrdering.equals(ORDER_BY_NAME) ? ORDER_BY_NAME : ORDER_BY_SIMPLE_NAME);
        this.customImageOrdering = null;
    }

    public String getImageOrdering() {
        return this.imageOrdering;
    }

    public void setCustomImageOrdering(Comparator fileComparator) {
        this.customImageOrdering = fileComparator;
    }

    public Comparator getCustomImageOrdering() {
        return this.customImageOrdering;
    }

    public void setMetaData(boolean newMetaData) {
        this.metaData = newMetaData;
    }

    public boolean isMetaData() {
        return this.metaData;
    }

    public void setSameDirectory(boolean newSameDirectory) {
        this.sameDirectory = newSameDirectory;
    }

    public boolean isSameDirectory() {
        return this.sameDirectory;
    }

    public void setOutputDirectory(String newOutputDirectory) {
        this.outputDirectory = newOutputDirectory;
    }

    public String getOutputDirectory() {
        return this.sameDirectory ? this.directory : this.outputDirectory;
    }

    File getInterpretedOutputDirectory() {
        File f2 = new File(this.getOutputDirectory());
        if (!f2.isAbsolute()) {
            f2 = new File(this.directory, this.outputDirectory);
        }
        return f2;
    }

    public void setRows(int newRows) {
        this.rows = newRows;
    }

    public int getRows() {
        return this.rows;
    }

    public void setImageLinking(String newImageLinking) {
        this.imageLinking = newImageLinking.equals(LINK_ORIGINALS) ? LINK_ORIGINALS : (newImageLinking.equals(LINK_ORIGINALS_VIA_SCALED) ? LINK_ORIGINALS_VIA_SCALED : LINK_SCALED);
    }

    public String getImageLinking() {
        return this.imageLinking;
    }

    public void setCopyOriginals(boolean newCopyOriginals) {
        this.copyOriginals = newCopyOriginals;
    }

    public boolean isCopyOriginals() {
        return this.copyOriginals;
    }

    public void setSkin(String newSkin) {
        this.skin = newSkin;
        this.skinDir = new File(this.cfg.skinsDir, this.skin);
        this.srcResDir = new File(this.skinDir, "res");
    }

    public String getSkin() {
        return this.skin;
    }

    public void setPageExtension(String newPageExtension) {
        this.pageExtension = newPageExtension;
    }

    public String getPageExtension() {
        return this.pageExtension;
    }

    public String getResourceDirectory() {
        return this.resourceDirectory;
    }

    public String getThumbnailDirectory() {
        return this.thumbDirectory;
    }

    public String getCloseupDirectory() {
        return this.closeupDirectory;
    }

    public String getSlideDirectory() {
        return this.slideDirectory;
    }

    public String getThumbnailPrefix() {
        return this.thumbnailPrefix;
    }

    public String getCloseupPrefix() {
        return this.closeupPrefix;
    }

    public void setTextFileComment(boolean newtextFileComment) {
        this.textFileComment = newtextFileComment;
    }

    public boolean isTextFileComment() {
        return this.textFileComment;
    }

    public void setJpegComment(boolean newjpegComment) {
        this.jpegComment = newjpegComment;
    }

    public boolean isJpegComment() {
        return this.jpegComment;
    }

    public void setIptcCaption(boolean newiptcCaption) {
        this.iptcCaption = newiptcCaption;
    }

    public boolean isIptcCaption() {
        return this.iptcCaption;
    }

    public void setExifUserComment(boolean newexifUserComment) {
        this.exifUserComment = newexifUserComment;
    }

    public boolean isExifUserComment() {
        return this.exifUserComment;
    }

    public void setHighQualityThumbs(boolean newhighQualityThumbs) {
        this.highQualityThumbs = newhighQualityThumbs;
    }

    public boolean isHighQualityThumbs() {
        return this.highQualityThumbs;
    }

    public void setExifImageDescription(boolean newexifImageDescription) {
        this.exifImageDescription = newexifImageDescription;
    }

    public boolean isExifImageDescription() {
        return this.exifImageDescription;
    }

    public void setIncludeDirectories(boolean newIncludeDirectories) {
        this.includeDirectories = newIncludeDirectories;
    }

    public boolean isIncludeDirectories() {
        return this.includeDirectories;
    }

    public void setUserVariables(Map newUserVariables) {
        this.userVariables = newUserVariables;
        File f2 = new File(this.skinDir, "onload.bsh");
        if (f2.exists()) {
            Iterator it = this.userVariables.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e2 = it.next();
                if (!(e2.getValue() instanceof String)) continue;
                e2.setValue(this.interpretDataType((String)e2.getValue()));
            }
        }
        this.extras = new PrintSafeHashMap();
        this.extras.putAll(this.userVariables);
        this.extras.putAll(this.skinVariables);
    }

    public void setSkinVariables(Map newSkinVariables) {
        this.skinVariables = newSkinVariables;
        Iterator it = this.skinVariables.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e2 = it.next();
            if (!(e2.getValue() instanceof String)) continue;
            e2.setValue(this.interpretDataType((String)e2.getValue()));
        }
        this.extras = new PrintSafeHashMap();
        this.extras.putAll(this.userVariables);
        this.extras.putAll(this.skinVariables);
    }

    private Object interpretDataType(String s2) {
        if (s2.indexOf(0) == 34 && s2.length() >= 2) {
            return s2.substring(1, s2.length() - 2);
        }
        if (s2.equals("true")) {
            return true;
        }
        if (s2.equals("false")) {
            return false;
        }
        try {
            return new Integer(s2);
        }
        catch (NumberFormatException ex) {
            try {
                return new Double(s2);
            }
            catch (NumberFormatException numberFormatException) {
                return s2;
            }
        }
    }

    public Map getUserVariables() {
        return this.userVariables;
    }

    public Map getSkinVariables() {
        return this.skinVariables;
    }

    public void setRemoteDirectory(String newRemoteDirectory) {
        this.remoteDirectory = newRemoteDirectory.trim();
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public void setAccountProfileName(String newAccountProfileName) {
        this.accountProfileName = newAccountProfileName;
    }

    public String getAccountProfileName() {
        return this.accountProfileName;
    }

    public void setReverseOrder(boolean newReverseOrder) {
        this.reverseOrder = newReverseOrder;
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public void setCharacterEncoding(String newCharacterEncoding) {
        this.characterEncoding = newCharacterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setTextEncoding(String newTextEncoding) {
        this.textEncoding = newTextEncoding;
        System.setProperty("file.encoding", this.textEncoding);
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setWriteUTF8(boolean newWriteUTF8) {
        this.writeUTF8 = newWriteUTF8;
    }

    public boolean isWriteUTF8() {
        return this.writeUTF8;
    }

    public void setDirectoriesFirst(boolean newDirectoriesFirst) {
        this.directoriesFirst = newDirectoriesFirst;
    }

    public boolean isDirectoriesFirst() {
        return this.directoriesFirst;
    }

    public void setIgnorePattern(String ignorePattern) {
        this.ignorePattern = ignorePattern;
    }

    public String getIgnorePattern() {
        return this.ignorePattern;
    }

    public void setIncludePattern(String includePattern) {
        this.includePattern = includePattern;
    }

    public String getIncludePattern() {
        return this.includePattern;
    }

    static void setVars(Map variables, Interpreter interpreter) throws ElementException {
        Iterator it = variables.entrySet().iterator();
        try {
            while (it.hasNext()) {
                Map.Entry e2 = it.next();
                String name = (String)e2.getKey();
                if (name.indexOf(46) != -1) continue;
                Object val = e2.getValue();
                if (val instanceof Integer) {
                    interpreter.set(name, (Integer)val);
                    continue;
                }
                if (val instanceof Long) {
                    interpreter.set(name, (Long)val);
                    continue;
                }
                if (val instanceof Float) {
                    interpreter.set(name, ((Float)val).floatValue());
                    continue;
                }
                if (val instanceof Double) {
                    interpreter.set(name, (Double)val);
                    continue;
                }
                if (val instanceof Boolean) {
                    interpreter.set(name, (Boolean)val);
                    continue;
                }
                interpreter.set(name, val);
            }
        }
        catch (EvalError e3) {
            throw new ElementException(e3.getMessage());
        }
    }

    public void setUsing(Object using) {
        this.using = using;
    }

    public String getScalingMethod() {
        return this.scalingMethod;
    }

    public void setScalingMethod(String scalingMethod) {
        this.scalingMethod = scalingMethod;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TemplateParser {
        private Map variables = new HashMap();
        int imageNum;
        Set includedPages = new HashSet();
        Set evaluatedDefinitions = new HashSet();
        private final String[] names = new String[]{"ja:ignore", "ja:if", "ja:eval", "%", "ja:include", "ja:rowiterator", "ja:coliterator", "ja:fileiterator"};

        public TemplateParser() {
        }

        public TemplateParser(Map variables) throws ElementException {
            this();
            this.putAll(variables);
        }

        public void putAll(Map variables) throws ElementException {
            this.variables.putAll(variables);
            AlbumBean.setVars(variables, AlbumBean.this.interpreter);
        }

        public void reset() throws ElementException {
            try {
                Iterator it = this.variables.keySet().iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    if (name.indexOf(46) != -1) continue;
                    AlbumBean.this.interpreter.unset(name);
                }
                this.variables.clear();
            }
            catch (EvalError e2) {
                throw new ElementException(e2.getMessage());
            }
        }

        public void removeAll(Collection variableKeys) throws ElementException {
            try {
                this.variables.keySet().removeAll(variableKeys);
                Iterator it = variableKeys.iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    if (name.indexOf(46) != -1) continue;
                    AlbumBean.this.interpreter.unset(name);
                }
            }
            catch (EvalError e2) {
                throw new ElementException(e2.getMessage());
            }
        }

        public Map getVariables() {
            return this.variables;
        }

        public String parseElements(String doc) throws ElementException {
            StringBuffer buf = new StringBuffer();
            this.parseElements(doc, buf);
            return buf.toString();
        }

        public void parseElements(String doc, StringBuffer buf) throws ElementException {
            block13: {
                try {
                    doc = Elements.stripJSPComments(doc);
                    Element elem = Elements.getNextElement(this.names, doc, true);
                    if (elem == null) {
                        buf.append(doc);
                        return;
                    }
                    buf.append(elem.getPreElement());
                    if (elem.getName().equals("ja:if")) {
                        this.handleIfElse(elem, buf);
                        break block13;
                    }
                    if (elem.getName().equals("ja:ignore")) {
                        this.handleIgnore(elem, buf);
                        break block13;
                    }
                    if (elem.getName().equals("ja:include")) {
                        this.handleInclude(elem, buf);
                        break block13;
                    }
                    if (elem.getName().equals("ja:eval")) {
                        this.handleEval(elem, buf);
                        break block13;
                    }
                    if (elem.getName().equals("%")) {
                        this.handleScriptlet(elem, buf);
                        break block13;
                    }
                    if (elem.getName().equals("$")) {
                        this.handleExpressionLanguage(elem, buf);
                        break block13;
                    }
                    if (elem.getName().equals("ja:rowiterator")) {
                        this.handleRowIterator(elem, buf);
                        break block13;
                    }
                    if (elem.getName().equals("ja:coliterator")) {
                        this.handleColIterator(elem, buf);
                        break block13;
                    }
                    if (elem.getName().equals("ja:fileiterator")) {
                        this.handleFileIterator(elem, buf);
                        break block13;
                    }
                    throw new ElementException(Msg.getString("scripting.unknownElementError") + elem.getName());
                }
                catch (EvalError ex) {
                    throw new ElementException(ex.getMessage());
                }
                catch (UtilEvalError ex) {
                    throw new ElementException(ex.getMessage());
                }
            }
        }

        private void handleRowIterator(Element rowIterator, StringBuffer buf) throws ElementException {
            this.imageNum = AlbumBean.this.indexNum * AlbumBean.this.imagesPerIndex;
            for (int row = 0; row < AlbumBean.this.currentRows; ++row) {
                this.parseElements(rowIterator.getContent(), buf);
                this.imageNum += AlbumBean.this.cols;
            }
            this.parseElements(rowIterator.getPostElement(), buf);
        }

        private void handleColIterator(Element colsElement, StringBuffer buf) throws ElementException {
            for (int i2 = this.imageNum; i2 < AlbumBean.this.files.length && i2 < this.imageNum + AlbumBean.this.cols; ++i2) {
                Scope locals = (Scope)AlbumBean.this.fileVariables.get(AlbumBean.this.files[i2]);
                Map allLocals = locals.push(AlbumBean.this.extras).flatten();
                this.putAll(allLocals);
                Replacer replacer = AlbumBean.fillReplacer(new Replacer(), allLocals);
                this.parseElements(replacer.replace(colsElement.getContent()), buf);
                this.removeAll(allLocals.keySet());
            }
            this.putAll(AlbumBean.this.indexVariables.push(AlbumBean.this.extras));
            this.parseElements(colsElement.getPostElement(), buf);
        }

        private void handleFileIterator(Element fileIterator, StringBuffer buf) throws ElementException {
            this.imageNum = AlbumBean.this.indexNum * AlbumBean.this.imagesPerIndex;
            boolean dirs = fileIterator.getAttributes().containsKey("dirs");
            boolean nodirs = fileIterator.getAttributes().containsKey("nodirs");
            for (int i2 = this.imageNum; i2 < AlbumBean.this.files.length && i2 - this.imageNum < AlbumBean.this.currentRows * AlbumBean.this.cols; ++i2) {
                if (AlbumBean.this.files[i2].isDirectory() ? nodirs : dirs) continue;
                Scope locals = (Scope)AlbumBean.this.fileVariables.get(AlbumBean.this.files[i2]);
                Scope imageNumFix = new Scope(locals);
                imageNumFix.put("imageNum", new Integer(i2 + 1));
                Map allLocals = imageNumFix.push(AlbumBean.this.extras).flatten();
                this.putAll(allLocals);
                Replacer replacer = AlbumBean.fillReplacer(new Replacer(), allLocals);
                this.parseElements(replacer.replace(fileIterator.getContent()), buf);
                this.removeAll(allLocals.keySet());
            }
            this.putAll(AlbumBean.this.indexVariables.push(AlbumBean.this.extras));
            this.parseElements(fileIterator.getPostElement(), buf);
        }

        private void handleIfElse(Element ifElem, StringBuffer buf) throws ElementException {
            String whiteCheck;
            StringTokenizer testTokenizer;
            String existTest = ifElem.getAttribute("exists");
            String testExpression = ifElem.getAttribute("test");
            boolean not = ifElem.getAttributes().containsKey("not");
            if (existTest == null && testExpression == null) {
                throw new ElementException(Msg.getString("scripting.missingAttibutesForJaIfElement"));
            }
            Element elseElem = null;
            Element nextElem = Elements.getElementByName("ja:", ifElem.getPostElement(), true);
            if (nextElem != null && nextElem.getName().equals("ja:else") && (testTokenizer = new StringTokenizer(whiteCheck = (elseElem = nextElem).getPreElement())).hasMoreTokens()) {
                throw new ElementException(Msg.getString("scripting.elseNotFollowingIfError"));
            }
            try {
                if (existTest != null && (!not ? this.exists(this.variables.get(existTest)) : !this.exists(this.variables.get(existTest))) || testExpression != null && (not ? !this.parseAttributeValue(testExpression).equals("true") : this.parseAttributeValue(testExpression).equals("true"))) {
                    this.parseElements(ifElem.getContent(), buf);
                    if (elseElem == null) {
                        this.parseElements(ifElem.getPostElement(), buf);
                    } else {
                        this.parseElements(elseElem.getPostElement(), buf);
                    }
                } else if (elseElem == null) {
                    this.parseElements(ifElem.getPostElement(), buf);
                } else {
                    this.parseElements(elseElem.getContent(), buf);
                    this.parseElements(elseElem.getPostElement(), buf);
                }
            }
            catch (ElementException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                throw new ElementException(Msg.getString("scripting.expressionNotEvaluatingToBooleanError") + testExpression + Msg.getString("scripting.expressionNotEvaluatingToBooleanError2"));
            }
        }

        private boolean exists(Object o2) {
            if (o2 == null) {
                return false;
            }
            if (!(o2 instanceof String) && !(o2 instanceof StringBuffer)) {
                return true;
            }
            return o2.toString().length() > 0;
        }

        private void handleIgnore(Element elem, StringBuffer buf) throws ElementException {
            buf.append(elem.getContent());
            this.parseElements(elem.getPostElement(), buf);
        }

        private void handleInclude(Element elem, StringBuffer buf) throws ElementException, EvalError, UtilEvalError {
            String page = (String)elem.getAttributes().get("page");
            if (page == null) {
                throw new ElementException(Msg.getString("scripting.missingPageAttributeForJaIncludeElementError"));
            }
            page = this.parseAttributeValue(page);
            File f2 = new File(page);
            boolean once = elem.getAttributes().containsKey("once");
            boolean root = elem.getAttributes().containsKey("root");
            if (once && this.includedPages.contains(f2.getAbsolutePath())) {
                this.parseElements(elem.getPostElement(), buf);
                return;
            }
            this.includedPages.add(f2.getAbsolutePath());
            if (!f2.isAbsolute()) {
                File curdir;
                if (root) {
                    curdir = (File)this.variables.get("rootImageDirectory");
                    if (curdir != null) {
                        f2 = new File(curdir, page);
                    }
                } else {
                    curdir = (File)this.variables.get("imageDirectory");
                    if (curdir != null) {
                        f2 = new File(curdir, page);
                    }
                    if (!f2.exists() && (curdir = (File)this.variables.get("skinDirectory")) != null && !(f2 = new File(curdir, page)).exists()) {
                        curdir = new File(((AlbumBean)AlbumBean.this).cfg.progDir, "includes");
                        f2 = new File(curdir, page);
                    }
                }
            }
            try {
                if (f2.exists()) {
                    String data = IO.readTextFile(f2);
                    Replacer replacer = AlbumBean.fillReplacer(new Replacer(), this.variables);
                    data = replacer.replace(data);
                    this.parseElements(data, buf);
                } else {
                    this.parseElements(elem.getContent(), buf);
                }
            }
            catch (IOException ex) {
                buf.append(elem.getContent());
            }
            this.parseElements(elem.getPostElement(), buf);
        }

        private void handleEval(Element evalElem, StringBuffer buf) throws ElementException {
            StringWriter sw = new StringWriter();
            String result = this.eval(evalElem.getContent(), sw);
            buf.append(sw.toString());
            buf.append(result);
            this.parseElements(evalElem.getPostElement(), buf);
        }

        private String upperInitial(String s2) {
            return "" + Character.toUpperCase(s2.charAt(0)) + s2.substring(1);
        }

        private Object invokeGetter(Object bean, String name) throws SecurityException, NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
            Class<?> beanClass = bean.getClass();
            Method m2 = null;
            try {
                m2 = beanClass.getMethod("get" + this.upperInitial(name), null);
            }
            catch (NoSuchMethodException ex) {
                try {
                    m2 = beanClass.getMethod("is" + this.upperInitial(name), null);
                }
                catch (NoSuchMethodException ex2) {
                    throw ex;
                }
            }
            return m2.invoke(bean, null);
        }

        private void handleExpressionLanguage(Element exprElem, StringBuffer buf) throws ElementException {
            try {
                String expr = exprElem.getContent();
                Object o2 = null;
                if (expr.indexOf(46) != -1) {
                    StringTokenizer tokens = new StringTokenizer(expr, ".");
                    String token = tokens.nextToken();
                    String next = tokens.nextToken();
                    o2 = AlbumBean.this.interpreter.get(token);
                    while (true) {
                        if (o2 instanceof Map) {
                            o2 = ((Map)o2).get(next);
                        } else if (o2 != null) {
                            o2 = this.invokeGetter(o2, next);
                        }
                        if (tokens.hasMoreTokens()) {
                            next = tokens.nextToken();
                            continue;
                        }
                        break;
                    }
                } else if (AlbumBean.this.using != null) {
                    try {
                        Field f2 = AlbumBean.this.using.getClass().getField(expr);
                        o2 = f2.get(AlbumBean.this.using);
                    }
                    catch (NoSuchFieldException ex) {
                        NameSpace ns = AlbumBean.this.interpreter.getNameSpace();
                        o2 = ns.getVariable(expr);
                    }
                } else {
                    NameSpace ns = AlbumBean.this.interpreter.getNameSpace();
                    o2 = ns.getVariable(expr);
                }
                if (o2 != null && o2 != Primitive.NULL && o2 != Primitive.VOID) {
                    buf.append(o2.toString());
                }
            }
            catch (Exception ex) {
                throw new ElementException(ex.toString());
            }
            this.parseElements(exprElem.getPostElement(), buf);
        }

        private void handleScriptlet(Element scriptlet, StringBuffer buf) throws ElementException {
            if (scriptlet.isDefinitionScriptlet()) {
                Integer contentHash = new Integer(scriptlet.getContent().hashCode());
                if (this.evaluatedDefinitions.contains(contentHash)) {
                    this.parseElements(scriptlet.getPostElement(), buf);
                    return;
                }
                this.evaluatedDefinitions.add(contentHash);
            }
            StringWriter sw = new StringWriter();
            String result = this.eval(scriptlet.getContent(), sw);
            buf.append(sw.toString());
            if (scriptlet.isEvalScriptlet()) {
                buf.append(result);
            }
            this.parseElements(scriptlet.getPostElement(), buf);
        }

        private String parseAttributeValue(String s2) throws ElementException, EvalError, UtilEvalError {
            StringWriter sw = new StringWriter();
            StringBuffer buf = new StringBuffer();
            Element scriptlet = Elements.getScriptlet(s2);
            if (scriptlet == null) {
                scriptlet = Elements.getExpressionLanguage(s2);
                if (scriptlet == null) {
                    return s2;
                }
                buf.append(scriptlet.getPreElement());
                this.handleExpressionLanguage(scriptlet, buf);
                return buf.toString();
            }
            buf.append(scriptlet.getPreElement());
            String result = this.eval(scriptlet.getContent(), sw);
            buf.append(sw.toString());
            if (scriptlet.isEvalScriptlet()) {
                buf.append(result);
            }
            buf.append(scriptlet.getPostElement());
            return buf.toString();
        }

        private String eval(String expr, Writer writer) throws ElementException {
            PrintWriter out = new PrintWriter(writer);
            try {
                AlbumBean.this.interpreter.set("out", out);
                Object ret = AlbumBean.this.doProcessExpression(expr);
                out.flush();
                return ret != null ? ret.toString() : "";
            }
            catch (EvalError e2) {
                throw new ElementException("Evaluation error on line " + e2.getErrorLineNumber() + ":\n\nDetails:\n" + e2.getMessage());
            }
        }
    }

    static class Counter {
        private int x;

        public Counter(int startValue) {
            this.x = startValue;
        }

        public synchronized int value() {
            return this.x;
        }

        public synchronized int next() {
            return this.x++;
        }
    }

    class EvalStat {
        String expr;
        int invocations;
        Stopwatch stopwatch = new Stopwatch();

        EvalStat() {
        }

        public String toString() {
            return this.stopwatch + "\tInvocations: " + this.invocations + "\tExpr: " + this.expr.substring(0, this.expr.length() <= 40 ? this.expr.length() - 1 : 40);
        }
    }

    private class ImageProcessingThread
    extends Thread {
        private Counter counter;
        private File dir;
        private File outputDir;
        private File[] files;
        Throwable throwable;

        public ImageProcessingThread(ThreadGroup tg, String name, Counter counter, File dir2, File outputDir, File[] files) {
            super(tg, name);
            this.counter = counter;
            this.dir = dir2;
            this.outputDir = outputDir;
            this.files = files;
            this.setDaemon(true);
        }

        public void run() {
            block2: {
                try {
                    AlbumBean.this.makeThumbs(this.counter, this.dir, this.outputDir, this.files);
                }
                catch (Throwable t2) {
                    this.throwable = t2;
                    if (t2 instanceof OperationAbortedException) break block2;
                    t2.printStackTrace(System.err);
                }
            }
        }
    }
}

