/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.util.FileFilters;

public class AlbumFileFilter
implements FileFilter {
    private String outputPath;
    private Set ignoreDirs = new HashSet();
    private Pattern ignorePattern;
    private Pattern includePattern;
    String pageExtension;

    public AlbumFileFilter(AlbumBean engine, File outputDir, String ignorePattern) {
        this.pageExtension = engine.getPageExtension();
        if (outputDir != null) {
            this.outputPath = outputDir.getAbsolutePath();
            this.ignoreDirs.add(engine.getResourceDirectory().toLowerCase());
            this.ignoreDirs.add("gifs".toLowerCase());
            this.ignoreDirs.add(engine.getThumbnailDirectory().toLowerCase());
            this.ignoreDirs.add(engine.getSlideDirectory().toLowerCase());
        }
        this.ignorePattern = Pattern.compile(ignorePattern, 2);
        String ip = engine.getIncludePattern();
        if (ip != null && ip.length() > 0) {
            this.includePattern = Pattern.compile(engine.getIncludePattern(), 2);
        }
    }

    public boolean accept(File file) {
        String name = file.getName();
        Matcher m2 = this.ignorePattern.matcher(name);
        if (m2.matches() || name.endsWith(".jap") || name.endsWith(".properties") || name.endsWith(this.pageExtension) || name.equals("albumfiles.txt")) {
            return false;
        }
        if (file.isDirectory()) {
            return this.outputPath != null && !this.ignoreDirs.contains(name.toLowerCase()) && !this.outputPath.startsWith(file.getAbsolutePath());
        }
        if (this.includePattern != null) {
            Matcher includeMatcher = this.includePattern.matcher(name);
            return includeMatcher.matches();
        }
        if (FileFilters.isFileSupported(file)) {
            return true;
        }
        return FileFilters.hasIcon(file);
    }
}

