/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.sun.image.codec.jpeg.ImageFormatException;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.JAFilter;
import se.datadosen.util.FileFilters;
import se.datadosen.util.RotationSupport;
import se.datadosen.util.Scope;

public class AlbumImage {
    final BufferedImage im;
    final File file;
    final int stage;
    final AlbumBean engine;

    public AlbumImage(BufferedImage image, AlbumBean engine) {
        this.file = null;
        this.im = image;
        this.engine = engine;
        this.stage = 1;
    }

    public AlbumImage(File imageFile, AlbumBean engine) throws ImageFormatException, IOException {
        this.file = imageFile;
        BufferedImage bi2 = FileFilters.loadImage(imageFile, engine);
        this.engine = engine;
        this.stage = 1;
        this.im = bi2.getWidth() > bi2.getHeight() ? RotationSupport.adjustOrientation(bi2, imageFile) : bi2;
    }

    protected AlbumImage(File file, BufferedImage im, int stage, AlbumBean engine) {
        this.file = file;
        this.im = im;
        this.stage = stage;
        this.engine = engine;
    }

    protected static BufferedImage cloneImage(BufferedImage im) {
        BufferedImage bi2 = new BufferedImage(im.getWidth(), im.getHeight(), 1);
        Graphics2D g2 = bi2.createGraphics();
        g2.drawImage((Image)im, 0, 0, null);
        g2.dispose();
        return bi2;
    }

    public AlbumImage scaleToFit(Dimension dim) {
        return new AlbumImage(this.file, this.engine.scaleToFit(this.im, dim, this.engine.getScalingMethod()), this.stage, this.engine);
    }

    protected AlbumImage scaleToFit(Dimension dim, int stage) {
        String scaleMethod = stage == 2 && this.engine.highQualityThumbs ? "ScaleSmooth" : this.engine.getScalingMethod();
        return new AlbumImage(this.file, this.engine.scaleToFit(this.im, dim, scaleMethod), stage, this.engine);
    }

    public AlbumImage scaleToThumbnail() {
        return this.scaleToFit(this.engine.thumbDim, 4);
    }

    public AlbumImage scaleToCloseup() {
        return this.scaleToFit(this.engine.imageDim, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlbumImage applyFilter(JAFilter filter, Map vars) {
        JAFilter jAFilter = filter;
        synchronized (jAFilter) {
            return new AlbumImage(this.file, filter.filter(AlbumImage.cloneImage(this.im), vars), this.stage, this.engine);
        }
    }

    public AlbumImage applyFilter(JAFilter filter) {
        HashMap vars;
        HashMap hashMap = vars = this.file != null ? (HashMap)this.engine.fileVariables.get(this.file) : null;
        if (vars == null) {
            vars = new HashMap();
        }
        return this.applyFilter(filter, vars);
    }

    public AlbumImage applyFilters(int stage) {
        Scope vars;
        Scope scope = vars = this.file != null ? (Scope)this.engine.fileVariables.get(this.file) : null;
        if (vars == null) {
            vars = new Scope();
        }
        return new AlbumImage(this.file, this.engine.processFilters(this.im, vars, stage), stage, this.engine);
    }

    public AlbumImage applyFilters() {
        return this.applyFilters(this.stage);
    }

    public Image getImage() {
        return this.im;
    }

    public AlbumImage saveJPEG(File output, int qualityPercent) throws ImageFormatException, IOException {
        if (output.isDirectory()) {
            output = new File(output, this.file.getName());
        }
        FileFilters.saveJPEG(this.im, output, this.engine);
        return this;
    }

    public AlbumImage saveJPEG(File output) throws IOException, ImageFormatException {
        return this.saveJPEG(output, this.engine.getQualityPercent());
    }
}

