/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileInputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.AlbumUtils;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.jalbum.UploadListener;
import se.datadosen.util.BeanBinder;

public class JAlbumConsole
implements AlbumBeanListener,
UploadListener {
    AlbumBean engine = new AlbumBean();
    UploadBean uploadBean = new UploadBean();

    public JAlbumConsole(Properties props) throws Exception {
        this.engine.addAlbumBeanListener(this);
        System.out.println(MessageFormat.format(Msg.getString("console.startupInfo"), "7.2.1"));
        if (props.containsKey("help") || props.containsKey("?")) {
            Properties defs = BeanBinder.getProperties((Object)this.engine, true);
            BeanBinder.getProperties((Object)this.uploadBean, defs);
            defs.setProperty("projectFile", "");
            defs.setProperty("programDirectory", Config.getConfig().progDir.toString());
            defs.setProperty("skinsDirectory", Config.getConfig().skinsDir.toString());
            defs.setProperty("runTool", "");
            defs.setProperty("uploadAll", "");
            defs.setProperty("smartUpload", "");
            System.out.println("\n" + Msg.getString("console.helpInfo"));
            Iterator<Map.Entry<Object, Object>> it = defs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> e2 = it.next();
                if (e2.getKey().equals("class") || e2.getKey().equals("userVariables") || e2.getKey().equals("skinVariables")) continue;
                System.out.println("-" + e2.getKey() + " " + e2.getValue());
            }
            System.out.println(Msg.getString("console.userVariableInfo"));
            System.out.println(Msg.getString("console.requiredArgumentsInfo"));
            return;
        }
        if (props.containsKey("projectFile")) {
            Properties fileProps = new Properties();
            FileInputStream fis = new FileInputStream(props.getProperty("projectFile"));
            fileProps.load(fis);
            fis.close();
            fileProps.putAll((Map<?, ?>)props);
            props = fileProps;
        }
        BeanBinder.setProperties((Object)this.engine, props);
        this.engine.setSkinVariables(AlbumUtils.getSkinVariables(props));
        this.engine.setUserVariables(AlbumUtils.getUserVariables(props));
        String toolName = props.getProperty("runTool");
        if (toolName != null) {
            this.engine.init();
            this.engine.processBeanShellFile(new File(toolName));
        } else if (props.containsKey("uploadAll")) {
            BeanBinder.setProperties((Object)this.uploadBean, props);
            this.uploadAlbum(true);
        } else if (props.containsKey("smartUpload")) {
            BeanBinder.setProperties((Object)this.uploadBean, props);
            this.uploadAlbum(false);
        } else {
            this.engine.makeAlbum();
            System.out.println(Msg.getString("console.albumCreationInfo") + " " + this.engine.getOutputDirectory());
        }
    }

    public static void main(String[] args) throws Exception {
        Properties commandLineProperties = BeanBinder.parseArgsOptions(args);
        new JAlbumConsole(commandLineProperties);
    }

    private void uploadAlbum(boolean fullUpdate) throws Exception {
        this.uploadBean.addUploadListener(this);
        this.uploadBean.connect();
        this.uploadBean.uploadAlbum(this.engine, fullUpdate);
    }

    public void imageProcessingStarted(AlbumBeanEvent e2) {
        if (e2.imageNum == 0) {
            System.out.println("\n" + MessageFormat.format(Msg.getString("console.processingInfo"), e2.directory, this.engine.getOutputDirectory()));
            System.out.println(e2.msg);
        } else {
            System.out.print(Msg.getString("console.FileInfo") + " " + e2.msg + " (" + e2.processedFiles + "/" + e2.totalFiles + ") ");
        }
    }

    public void imageProcessingFinished(AlbumBeanEvent e2) {
        System.out.println(Msg.getString("console.processingDoneInfo"));
    }

    public void errorOccured(Throwable t2, File f2) {
        System.err.println(MessageFormat.format(Msg.getString("console.errorProcessingInfo"), f2, t2.toString()));
    }

    public void bytesTransferred(long count) {
        System.out.print(".");
    }
}

