/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import com.incors.plaf.alloy.AlloyLookAndFeel;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import net.jalbum.slideshow.SlideShowFactory;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JSmartDialog;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JPrefsPanel_language_actionAdapter;
import se.datadosen.jalbum.JPrefsPanel_lookAndFeel_actionAdapter;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.Item;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.LanguageMapper;
import se.datadosen.util.PropertyBinder;

public class JPreferencesWindow
extends JSmartDialog
implements JComponentHolder {
    JAlbumFrame parent;
    JCheckBox debugMode = new JCheckBox();
    JCheckBox checkForUpdates = new JCheckBox();
    JCheckBox closeProgressDialog = new JCheckBox();
    JCheckBox useLayoutHints = new JCheckBox();
    JCheckBox restorePreviousSettings = new JCheckBox();
    JCheckBox autoWriteCommentsToFile = new JCheckBox();
    JComboBox language = new JComboBox<Object>(JPreferencesWindow.fillLanguages());
    JComboBox lookAndFeel = new JComboBox<Object>(JPreferencesWindow.fillLookAndFeels());
    ControlPanel skins = new ControlPanel();
    ControlPanel editing = new ControlPanel();
    ControlPanel guides = new ControlPanel();
    JCheckBox showWarnings = new JCheckBox();
    ControlPanel multipleProcessors = new ControlPanel();
    JLabel nThreadsLabel = new JLabel();
    JComboBox nThreads = new JComboBox<Object>(JPreferencesWindow.fillNThreads());
    JLabel myAlbumsLocationLabel = new JLabel();
    JTextField myAlbumsLocation = new JSmartTextField();
    JLabel languageLabel = new JLabel();
    JLabel lookAndFeelLabel = new JLabel();
    JLabel slideShowLabel = new JLabel();
    JCheckBox cleanOutputFiles = new JCheckBox();

    public JPreferencesWindow(JAlbumFrame parent) {
        super((Frame)parent, false);
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Container c2 = this.getContentPane();
        c2.setLayout(new RiverLayout());
        this.setTexts();
        this.useLayoutHints.setSelected(true);
        this.restorePreviousSettings.setSelected(true);
        this.showWarnings.setSelected(true);
        this.cleanOutputFiles.setSelected(true);
        this.checkForUpdates.setSelected(true);
        File userHome = FileSystemView.getFileSystemView().getDefaultDirectory();
        File myAlbums = new File(userHome, Msg.getString("newproject.myAlbumsDirectory"));
        this.myAlbumsLocation.setText(myAlbums.getAbsolutePath());
        this.nThreads.setSelectedIndex(0);
        this.debugMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                System.setProperty("log.level", JPreferencesWindow.this.debugMode.isSelected() ? "DEBUG" : "OFF");
                String logLevel = System.getProperty("log.level");
                if (logLevel == null || logLevel.equals("OFF")) {
                    Logger.setLevel(Level.OFF);
                } else {
                    Logger.setLevel(Level.getLevel(logLevel));
                }
            }
        });
        AbstractAction okAction = new AbstractAction(Msg.getString("ok")){

            public void actionPerformed(ActionEvent e2) {
                JPreferencesWindow.this.setVisible(false);
                JPreferencesWindow.this.savePreferences();
            }
        };
        AbstractAction cancelAction = new AbstractAction(Msg.getString("cancel")){

            public void actionPerformed(ActionEvent e2) {
                JPreferencesWindow.this.setVisible(false);
                JPreferencesWindow.this.cancelPreferences();
            }
        };
        this.registerActions(okAction, cancelAction);
        this.language.addActionListener(new JPrefsPanel_language_actionAdapter(this));
        this.lookAndFeel.addActionListener(new JPrefsPanel_lookAndFeel_actionAdapter(this));
        c2.add("br", this.languageLabel);
        c2.add("tab", this.language);
        c2.add("br", this.lookAndFeelLabel);
        c2.add("tab", this.lookAndFeel);
        c2.add("br", this.nThreadsLabel);
        c2.add("tab", this.nThreads);
        c2.add("br", this.myAlbumsLocationLabel);
        c2.add("tab hfill", this.myAlbumsLocation);
        if (Runtime.getRuntime().availableProcessors() < 2) {
            this.multipleProcessors.setEnabled(false);
        }
        c2.add("p", this.checkForUpdates);
        c2.add("br", this.closeProgressDialog);
        c2.add("br", this.showWarnings);
        c2.add("br", this.debugMode);
        c2.add("br", this.cleanOutputFiles);
        this.skins.add(this.useLayoutHints);
        this.skins.add("br", this.restorePreviousSettings);
        c2.add("br", this.skins);
        this.editing.add(this.autoWriteCommentsToFile);
        c2.add("br", this.editing);
    }

    public void setTexts() {
        this.languageLabel.setText(Msg.getString("prefs.language"));
        this.lookAndFeelLabel.setText(Msg.getString("prefs.lookAndFeel"));
        this.slideShowLabel.setText(Msg.getString("prefs.slideShow"));
        this.debugMode.setText(Msg.getString("ui.debugMode"));
        this.debugMode.setToolTipText(Msg.getString("ui.debugModeToolTip"));
        this.cleanOutputFiles.setText(Msg.getString("prefs.cleanOutputFiles"));
        this.checkForUpdates.setText(Msg.getString("ui.checkForUpdates"));
        this.checkForUpdates.setToolTipText(Msg.getString("ui.checkForUpdatesToolTip"));
        this.closeProgressDialog.setText(Msg.getString("prefs.closeProgressDialog"));
        this.useLayoutHints.setText(Msg.getString("ui.useLayoutHints"));
        this.useLayoutHints.setToolTipText(Msg.getString("ui.useLayoutHintsToolTip"));
        this.restorePreviousSettings.setText(Msg.getString("ui.restorePreviousSettings"));
        this.restorePreviousSettings.setToolTipText(Msg.getString("ui.restorePreviousSettingsToolTip"));
        this.autoWriteCommentsToFile.setText(Msg.getString("prefs.autoWriteCommentsToFile"));
        this.skins.setTitle(Msg.getString("prefs.skinsBorder"));
        this.editing.setTitle(Msg.getString("prefs.imageEditingBorder"));
        this.guides.setTitle(Msg.getString("prefs.guidesBorder"));
        this.showWarnings.setText(Msg.getString("prefs.showWarnings"));
        this.multipleProcessors.setTitle(Msg.getString("prefs.multipleProcessorsBorder"));
        this.nThreadsLabel.setText(Msg.getString("prefs.nThreadsLabel"));
        this.myAlbumsLocationLabel.setText(Msg.getString("prefs.myAlbumsLocation"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePreferences() {
        FileOutputStream fos = null;
        try {
            Properties defaults = new Properties();
            if (JAlbumFrame.defaultProjectFile.exists()) {
                defaults = IO.readPropertyFile(JAlbumFrame.defaultProjectFile);
            }
            PropertyBinder.getProperties(this, defaults);
            BeanBinder.setProperties((Object)Config.getConfig(), defaults);
            fos = new FileOutputStream(JAlbumFrame.defaultProjectFile);
            defaults.store(fos, "JAlbum Project");
            IO.close(fos);
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.parent.statusBar.setText(ex.getMessage());
        }
        finally {
            IO.close(fos);
        }
    }

    private void cancelPreferences() {
        try {
            Properties defaults = new Properties();
            if (JAlbumFrame.defaultProjectFile.exists()) {
                defaults = IO.readPropertyFile(JAlbumFrame.defaultProjectFile);
            }
            PropertyBinder.syncUI(defaults, this);
        }
        catch (Exception ex) {
            Debug.showErrorDialog(this, ex);
            this.parent.statusBar.setText(ex.getMessage());
        }
    }

    private static Object[] fillLanguages() {
        File dir2 = new File(Config.getConfig().progDir, "texts");
        File[] files = dir2.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".properties");
            }
        });
        Object[] result = new Object[files.length + 1];
        for (int i2 = 0; i2 < files.length; ++i2) {
            String name = files[i2].getName();
            int underscoreIndex = name.indexOf(95);
            String iso2 = underscoreIndex == -1 ? "en" : name.substring(underscoreIndex + 1, name.lastIndexOf(46));
            result[i2 + 1] = new Item(iso2, LanguageMapper.getFullName(iso2));
        }
        Arrays.sort(result, 1, result.length - 1);
        result[0] = new Item("default", Msg.getString("prefs.systemDefault"));
        return result;
    }

    private static Object[] fillLookAndFeels() {
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        Object[] result = new Object[lafInfo.length + 2];
        result[0] = new Item(UIManager.getSystemLookAndFeelClassName(), Msg.getString("prefs.systemDefault"));
        result[1] = new Item("com.incors.plaf.alloy.AlloyLookAndFeel", "Alloy");
        for (int i2 = 0; i2 < lafInfo.length; ++i2) {
            result[i2 + 2] = new Item(lafInfo[i2].getClassName(), lafInfo[i2].getName());
        }
        return result;
    }

    private static Object[] fillSlideShow() {
        Object[] slideShowKeys = SlideShowFactory.getSlideShowKeys();
        return slideShowKeys;
    }

    private static Object[] fillNThreads() {
        Object[] result = new Object[Runtime.getRuntime().availableProcessors()];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = new Integer(i2 + 1);
        }
        return result;
    }

    void language_actionPerformed(ActionEvent e2) {
        Item lang = (Item)this.language.getSelectedItem();
        String newLang = (String)lang.value;
        Config config = Config.getConfig();
        if (!config.getLanguage().equals(newLang)) {
            config.setLanguage(newLang);
            this.parent.setTexts();
        }
    }

    void lookAndFeel_actionPerformed(ActionEvent e2) {
        String laf = (String)((Item)this.lookAndFeel.getSelectedItem()).value;
        Config config = Config.getConfig();
        if (!config.getLookAndFeel().equals(laf)) {
            config.setLookAndFeel(laf);
            try {
                UIManager.setLookAndFeel(laf);
                AlloyLookAndFeel.updateAllUIs();
                this.pack();
                this.parent.validate();
            }
            catch (Exception ex) {
                this.parent.statusBar.setText(ex.toString());
            }
        }
    }
}

