/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import se.datadosen.component.JIconToggleButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Stopwatch;

public class JProgressDialog
extends JDialog
implements AlbumBeanListener {
    private JPanel thePanel = new JPanel();
    private JPanel mainPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JButton abortOrCloseButton = new JButton();
    private JButton viewAlbumButton = new JButton();
    private JToggleButton pauseButton = new JIconToggleButton();
    private JLabel directory = new JLabel();
    private JProgressBar progressBar = new JProgressBar();
    private JLabel file = new JLabel();
    private JLabel timeInfo = new JLabel();
    private Stopwatch timer = new Stopwatch();
    boolean abort = false;
    private boolean finished = false;
    private Window parent;
    static /* synthetic */ Class class$se$datadosen$jalbum$JAlbumFrame;
    static /* synthetic */ Class class$se$datadosen$jalbum$JProgressDialog;

    public JProgressDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.init();
    }

    public JProgressDialog(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.init();
    }

    public JProgressDialog(Dialog parent, String title, boolean modal, boolean abortOnly) {
        super(parent, title, modal);
        this.parent = parent;
        try {
            this.initComponents(abortOnly);
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void init() {
        try {
            this.initComponents(false);
            this.pack();
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents(boolean abortOnly) throws Exception {
        this.thePanel.setLayout(new BorderLayout());
        if (!abortOnly) {
            this.viewAlbumButton.setAction(((JAlbumFrame)this.parent).actions.viewAlbumAction);
            this.viewAlbumButton.setText(Msg.getString("ui.viewAlbum"));
            this.viewAlbumButton.setIcon(new ImageIcon((class$se$datadosen$jalbum$JProgressDialog == null ? (class$se$datadosen$jalbum$JProgressDialog = JProgressDialog.class$("se.datadosen.jalbum.JProgressDialog")) : class$se$datadosen$jalbum$JProgressDialog).getResource("images/earth_view.png")));
            this.viewAlbumButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (JProgressDialog.this.finished) {
                        JProgressDialog.this.dispose();
                    }
                }
            });
            this.getRootPane().setDefaultButton(this.viewAlbumButton);
            this.pauseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    JProgressDialog.this.pauseButton_actionPerformed(e2);
                }
            });
            this.pauseButton.setText(Msg.getString("progress.pause"));
            this.pauseButton.setIcon(new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JProgressDialog.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/media_pause.png")));
        }
        this.abortOrCloseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JProgressDialog.this.abortOrClosePerformed(e2);
            }
        });
        this.abortOrCloseButton.setText(Msg.getString("abort"));
        this.abortOrCloseButton.setIcon(new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JProgressDialog.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/media_stop.png")));
        Dimension a2 = this.abortOrCloseButton.getPreferredSize();
        this.abortOrCloseButton.setPreferredSize(new Dimension((int)((double)a2.width * 1.25), a2.height));
        this.buttonPanel.setLayout(new RiverLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.mainPanel.setLayout(new RiverLayout());
        this.directory.setText(Msg.getString("progress.processingInfo"));
        this.file.setText(Msg.getString("progress.fileInfo"));
        this.timeInfo.setText(Msg.getString("progress.estimatedTimeLeftInfo"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e2) {
                JProgressDialog.this.this_windowClosing(e2);
            }
        });
        this.getContentPane().add(this.thePanel);
        this.thePanel.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.directory, null);
        this.mainPanel.add("br", this.file);
        this.mainPanel.add("br", Box.createRigidArea(new Dimension(4, 4)));
        this.mainPanel.add("br hfill", this.progressBar);
        this.mainPanel.add("br", Box.createRigidArea(new Dimension(4, 4)));
        this.mainPanel.add("br", this.timeInfo);
        this.thePanel.add((Component)this.buttonPanel, "South");
        if (!abortOnly) {
            this.buttonPanel.add("center", this.viewAlbumButton);
            this.buttonPanel.add(this.pauseButton);
        }
        this.buttonPanel.add("center", this.abortOrCloseButton);
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane pane = this.getLayeredPane();
        AbstractAction closeAction = new AbstractAction("close"){

            public void actionPerformed(ActionEvent e2) {
                JProgressDialog.this.abortOrClosePerformed(null);
            }
        };
        pane.registerKeyboardAction(closeAction, "close", ks, 2);
    }

    private static String twoDigits(int x2) {
        if (x2 < 10) {
            return "0" + x2;
        }
        return "" + x2;
    }

    private static String timerFormat(int secs) {
        int hours = secs / 3600;
        int minutes = secs % 3600 / 60;
        int seconds = secs % 60;
        return "" + hours + ":" + JProgressDialog.twoDigits(minutes) + ":" + JProgressDialog.twoDigits(seconds);
    }

    public synchronized void imageProcessingStarted(AlbumBeanEvent e2) {
        if (this.finished) {
            return;
        }
        if (this.pauseButton.isSelected()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isVisible() && !this.abort) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JProgressDialog.this.updateStateAndSetVisible(true);
                }
            });
        }
        if (this.abort) {
            e2.abortProcessing();
        }
        if (!this.timer.isRunning()) {
            this.timer.start();
            this.directory.setText(Msg.getString("progress.processingInfo"));
            this.directory.setVisible(true);
            this.file.setText(e2.msg);
            this.file.setVisible(true);
            if (!this.progressBar.isIndeterminate()) {
                this.progressBar.setValue(1);
                this.progressBar.setMaximum(e2.totalFiles);
                this.progressBar.setStringPainted(true);
                this.progressBar.setString(MessageFormat.format(Msg.getString("progress.processingInfo2"), new Integer(e2.processedFiles), new Integer(e2.totalFiles)));
            }
        }
        this.directory.setText(Msg.getString("progress.processingInfo") + " " + e2.directory);
        this.file.setText(e2.msg);
    }

    public synchronized void imageProcessingFinished(AlbumBeanEvent e2) {
        if (this.finished) {
            return;
        }
        if (this.abort) {
            e2.abortProcessing();
        }
        int processedImages = e2.processedFiles;
        if (this.progressBar.getValue() < processedImages) {
            if (!this.progressBar.isIndeterminate()) {
                this.progressBar.setValue(processedImages);
                this.progressBar.setMaximum(e2.totalFiles);
                this.progressBar.setStringPainted(true);
                this.progressBar.setString(MessageFormat.format(Msg.getString("progress.processingInfo2"), new Integer(processedImages), new Integer(e2.totalFiles)));
            }
            if (processedImages < e2.totalFiles) {
                long elapsed = this.timer.getMillis();
                long totalMillis = (long)e2.totalFiles * elapsed / (long)processedImages;
                int secsLeft = (int)(totalMillis - elapsed) / 1000;
                this.timeInfo.setText(Msg.getString("progress.estimatedTimeLeftInfo") + " " + JProgressDialog.timerFormat(secsLeft));
            } else {
                this.setDialogToFinishedState();
            }
        }
    }

    void setDialogToFinishedState() {
        final JProgressDialog theDialog = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (JProgressDialog.this.finished) {
                    return;
                }
                JProgressDialog.this.finished = true;
                JProgressDialog.this.progressBar.setIndeterminate(false);
                JProgressDialog.this.progressBar.setValue(JProgressDialog.this.progressBar.getMaximum());
                JProgressDialog.this.pauseButton.setEnabled(false);
                JProgressDialog.this.abortOrCloseButton.setText(Msg.getString("close"));
                JProgressDialog.this.directory.setVisible(false);
                JProgressDialog.this.file.setText(Msg.getString("ui.albumGenerationDone"));
                JProgressDialog.this.timer.stop();
                long secsElapsed = JProgressDialog.this.timer.getMillis() / 1000L;
                JProgressDialog.this.timeInfo.setText(Msg.getString("progress.timeElapsedInfo") + " " + JProgressDialog.timerFormat((int)secsElapsed));
                if (JAlbum.isMac()) {
                    if (!theDialog.isFocused()) {
                        theDialog.setVisible(false);
                        theDialog.setVisible(true);
                    }
                } else {
                    theDialog.toFront();
                    theDialog.requestFocus();
                }
            }
        });
    }

    public void errorOccured(Throwable t2, File f2) {
    }

    synchronized void abortOrClosePerformed(ActionEvent e2) {
        this.updateStateAndSetVisible(false);
        if (!this.finished) {
            this.abort = true;
            this.pauseButton.setSelected(false);
            this.notifyAll();
        }
    }

    synchronized void pauseButton_actionPerformed(ActionEvent e2) {
        if (this.pauseButton.isSelected()) {
            this.timer.stop();
        } else {
            this.timer.start();
            this.notifyAll();
        }
    }

    public void setIndeterminate(boolean b2) {
        this.progressBar.setIndeterminate(b2);
    }

    public void updateStateAndSetVisible(boolean visible) {
        if (visible) {
            this.pauseButton.setSelected(false);
            this.pauseButton.setEnabled(true);
            Dimension parentSize = this.parent.getSize();
            Dimension mySize = this.getSize();
            Point loc = this.parent.getLocation();
            this.setLocation(loc.x + (parentSize.width - mySize.width) / 2, loc.y + (parentSize.height - mySize.height) / 2);
            this.directory.setText(" ");
            this.file.setText(" ");
            this.timeInfo.setText(" ");
            this.progressBar.setValue(0);
            this.progressBar.setString("");
            this.timer.reset();
            this.abort = false;
            this.finished = false;
            this.abortOrCloseButton.setText(Msg.getString("abort"));
            this.abortOrCloseButton.setIcon(new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JProgressDialog.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/media_stop.png")));
        }
        super.setVisible(visible);
    }

    void this_windowClosing(WindowEvent e2) {
        if (!this.finished) {
            this.abort = true;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

