/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFile;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.datadosen.component.AutoSelectingTreeCellEditor;
import se.datadosen.component.ControlPanel;
import se.datadosen.component.JIconButton;
import se.datadosen.component.JLinkLabel;
import se.datadosen.component.JSmartTextField;
import se.datadosen.component.JWizard;
import se.datadosen.component.JWizardStep;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AccountProfile;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.JAddAccountDialog;
import se.datadosen.jalbum.JAdvancedAccountSettingsDialog;
import se.datadosen.jalbum.JAlbum;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumSite;
import se.datadosen.jalbum.JProgressDialog;
import se.datadosen.jalbum.JUploadProgressDialog;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.RemoteFSNode;
import se.datadosen.jalbum.RemoteFSTreeCellRenderer;
import se.datadosen.jalbum.RemoteFSTreeTransferHandler;
import se.datadosen.jalbum.SlowOperation;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.tags.Element;
import se.datadosen.tags.Elements;
import se.datadosen.tags.XMLDocument;
import se.datadosen.util.BeanBinder;
import se.datadosen.util.Debug;
import se.datadosen.util.IO;
import se.datadosen.util.httpClient.HttpConnection;
import se.datadosen.util.httpClient.HttpResponse;

public class JPublishWizard
extends JWizard {
    static final File accountsFile = new File(System.getProperty("user.home"), ".jalbum-ftp-accounts.xml");
    DefaultListModel accounts = new DefaultListModel();
    AccountProfile currentAccount;
    AlbumBean engine;
    UploadBean uploadBean = new UploadBean();
    RemoteFSNode rootNode;
    AccountsStep accountsStep;
    PublishStep publishStep;
    String currentWorkingDirectory = "";
    static /* synthetic */ Class class$se$datadosen$component$JSmartTextComponentSupport;
    static /* synthetic */ Class class$se$datadosen$jalbum$JAlbumFrame;
    static /* synthetic */ Class class$se$datadosen$jalbum$JPublishWizard;

    public JPublishWizard(JAlbumFrame owner, AlbumBean engine) {
        super(owner, Msg.getString("ui.publishPanel"), false, new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("dor.png")));
        this.engine = engine;
        this.allowFinish(false);
        this.backAction.putValue("Name", Msg.getString("wiz.back"));
        this.cancelAction.putValue("Name", Msg.getString("close"));
        this.accountsStep = new AccountsStep();
        this.publishStep = new PublishStep();
        this.addStep(this.accountsStep);
        this.addStep(this.publishStep);
    }

    protected void updateTitle() {
        if (this.steps.size() > 1) {
            this.setTitle(this.title + " - " + MessageFormat.format(Msg.getString("wiz.stepInfo"), new Integer(this.stepIndex + 1), new Integer(this.steps.size())));
        } else {
            this.setTitle(this.title);
        }
    }

    public void onHide() {
        try {
            this.uploadBean.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onHide();
    }

    private static String showPasswordInputDialog(Component parent, String message, String title, String initialValue) {
        JPasswordField jpf = new JPasswordField();
        if (initialValue != null) {
            jpf.setText(initialValue);
        }
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new RiverLayout());
        messagePanel.add(new JLabel(message));
        messagePanel.add("br hfill", jpf);
        JOptionPane pane = new JOptionPane(messagePanel, 1, 2, null, null, null);
        JDialog dialog = pane.createDialog(parent, title);
        dialog.show();
        Object val = pane.getValue();
        if (val instanceof Integer && (Integer)val == 0) {
            return new String(jpf.getPassword());
        }
        return null;
    }

    String getFtpWebRootDirectory() {
        if (this.currentAccount.getFtpWebRootDirectory().equals("VALUE_UNSET")) {
            return "VALUE_UNSET";
        }
        return this.currentAccount.isShowServerRootDirectory() ? this.toAbsolute(this.currentAccount.getFtpWebRootDirectory()) : this.toRelative(this.currentAccount.getFtpWebRootDirectory());
    }

    void setFtpWebRootDirectory(String path) {
        this.currentAccount.setFtpWebRootDirectory(this.currentAccount.isShowServerRootDirectory() ? "/" + path : path);
    }

    String getRemoteDirectory() {
        return this.currentAccount.isShowServerRootDirectory() ? this.toAbsolute(this.engine.getRemoteDirectory()) : this.toRelative(this.engine.getRemoteDirectory());
    }

    void setRemoteDirectory(String path) {
        this.engine.setRemoteDirectory(this.currentAccount.isShowServerRootDirectory() ? "/" + path : path);
    }

    private String toAbsolute(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        return IO.combinePaths(this.currentWorkingDirectory, path);
    }

    private String toRelative(String path) {
        if (!path.startsWith("/")) {
            return path;
        }
        String rel = IO.relativePath(path, this.currentWorkingDirectory);
        if (rel.startsWith("..")) {
            return path;
        }
        return rel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PublishStep
    extends JWizardStep {
        ImageIcon folderEarthIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/folder_earth.png"));
        ImageIcon folderNewIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/folder_new.png"));
        ImageIcon folderDeleteIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/folder_delete.png"));
        ImageIcon folderRefreshIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/folder_refresh.png"));
        ImageIcon folderEditIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/folder_edit.png"));
        ImageIcon uploadIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/server_from_client.png"));
        ImageIcon gaugeIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/gauge.png"));
        ImageIcon copyIcon = new ImageIcon((class$se$datadosen$component$JSmartTextComponentSupport == null ? (class$se$datadosen$component$JSmartTextComponentSupport = JPublishWizard.class$("se.datadosen.component.JSmartTextComponentSupport")) : class$se$datadosen$component$JSmartTextComponentSupport).getResource("images/copy.png"));
        Action newDirectoryAction = new AbstractAction(Msg.getString("publish.newDirectory"), this.folderNewIcon){

            public void actionPerformed(ActionEvent e2) {
                DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)PublishStep.this.tree.getLastSelectedPathComponent();
                if (selNode != null) {
                    String dirName;
                    String defaultAlbumName = Msg.getString("publish.newDirectory");
                    ((JAlbumFrame)JPublishWizard.this.getOwner()).ui2Engine();
                    if (((PublishStep)PublishStep.this).JPublishWizard.this.engine.getDirectory() != null && (dirName = new File(((PublishStep)PublishStep.this).JPublishWizard.this.engine.getDirectory()).getName()).length() > 0) {
                        defaultAlbumName = dirName;
                    }
                    RemoteFSNode newNode = new RemoteFSNode(defaultAlbumName, null, ((PublishStep)PublishStep.this).JPublishWizard.this.uploadBean.getRemoteFSBean(), (Window)JPublishWizard.this);
                    PublishStep.this.treeModel.insertNodeInto(newNode, selNode, 0);
                    Object[] nodes = PublishStep.this.treeModel.getPathToRoot(newNode);
                    TreePath path = new TreePath(nodes);
                    PublishStep.this.tree.scrollPathToVisible(path);
                    PublishStep.this.tree.setSelectionPath(path);
                    PublishStep.this.tree.startEditingAtPath(path);
                }
            }
        };
        Action deleteDirectoryAction = new AbstractAction(Msg.getString("publish.deleteDirectory"), this.folderDeleteIcon){

            public void actionPerformed(ActionEvent e2) {
                final RemoteFSNode node = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (!node.isLink()) {
                    try {
                        int answer;
                        RemoteFile[] files = ((PublishStep)PublishStep.this).JPublishWizard.this.uploadBean.getRemoteFSBean().getFiles(node.remotePath(), RemoteFSBean.noDotDotDotFileFilter);
                        if (files.length > 0 && (answer = JOptionPane.showConfirmDialog(JPublishWizard.this, MessageFormat.format(Msg.getString("publish.DeleteDirectoryWarning"), node), Msg.getString("publish.deleteDirectory"), 0, 2)) != 0) {
                            return;
                        }
                    }
                    catch (Exception ex) {
                        return;
                    }
                }
                final JProgressDialog progressDialog = new JProgressDialog((Dialog)JPublishWizard.this, MessageFormat.format(Msg.getString("publish.deletingDirectoryInfo"), node), true, true);
                progressDialog.setSize(new Dimension(350, 180));
                progressDialog.setIndeterminate(true);
                ((PublishStep)PublishStep.this).JPublishWizard.this.uploadBean.addUploadListener(progressDialog);
                new Thread("DirectoryDeletingThread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            if (node.isLink()) {
                                ((PublishStep)(this).PublishStep.this).JPublishWizard.this.uploadBean.getRemoteFSBean().removeFile(node.remotePath());
                            } else {
                                ((PublishStep)(this).PublishStep.this).JPublishWizard.this.uploadBean.deleteDirectory(node.remotePath());
                            }
                            (this).PublishStep.this.tree.setSelectionPath(new TreePath(node.getParent()));
                            (this).PublishStep.this.treeModel.removeNodeFromParent(node);
                        }
                        catch (OperationAbortedException ex) {
                            PublishStep.this.refreshFrom(node);
                        }
                        catch (Exception ex) {
                            Debug.showErrorDialog(JPublishWizard.this, ex);
                            (this).PublishStep.this.tree.setSelectionPath(new TreePath(node.getParent()));
                            PublishStep.this.refreshFrom((RemoteFSNode)node.getParent());
                        }
                        finally {
                            ((PublishStep)(this).PublishStep.this).JPublishWizard.this.uploadBean.removeUploadListener(progressDialog);
                            progressDialog.updateStateAndSetVisible(false);
                        }
                    }
                }.start();
                progressDialog.updateStateAndSetVisible(true);
            }
        };
        Action renameDirectoryAction = new AbstractAction(Msg.getString("publish.renameDirectory"), this.folderEditIcon){

            public void actionPerformed(ActionEvent e2) {
                PublishStep.this.tree.startEditingAtPath(PublishStep.this.tree.getSelectionPath());
            }
        };
        Action refreshDirectoryAction = new AbstractAction(Msg.getString("publish.refreshDirectory"), this.folderRefreshIcon){

            public void actionPerformed(ActionEvent e2) {
                RemoteFSNode node = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    node = (RemoteFSNode)PublishStep.this.tree.getModel().getRoot();
                }
                PublishStep.this.refreshFrom(node);
            }
        };
        Action markAsWebRootAction = new AbstractAction(Msg.getString("publish.markAsWebRoot"), this.folderEarthIcon){

            public void actionPerformed(ActionEvent e2) {
                String answer = (String)JOptionPane.showInputDialog(JPublishWizard.this, Msg.getString("publish.markAsWebRootInfo"), Msg.getString("publish.markAsWebRoot"), 1, null, null, ((PublishStep)PublishStep.this).JPublishWizard.this.currentAccount.getWebRootURL());
                if (answer != null) {
                    ((PublishStep)PublishStep.this).JPublishWizard.this.currentAccount.setWebRootURL(answer);
                    JPublishWizard.this.setFtpWebRootDirectory(((RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent()).remotePath());
                    ((PublishStep)PublishStep.this).JPublishWizard.this.accountsStep.saveAccounts();
                    TreePath webRootPath = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), PublishStep.this.treeModel);
                    PublishStep.this.customRenderer.setWebRoot((TreeNode)webRootPath.getLastPathComponent());
                    PublishStep.this.tree.repaint();
                    PublishStep.this.updateView();
                }
            }
        };
        Action getQuotaAction = new AbstractAction(Msg.getString("publish.getQuota"), this.gaugeIcon){

            public void actionPerformed(ActionEvent e2) {
                try {
                    URL quotaURL = new URL(JAlbumSite.getInstance().getMyJAlbumQuotaUrl());
                    HttpConnection conn = new HttpConnection(quotaURL);
                    Properties data = new Properties();
                    data.setProperty("userName", ((PublishStep)PublishStep.this).JPublishWizard.this.currentAccount.getFtpUser());
                    HttpResponse resp = conn.Post(data);
                    if (resp.getStatusCode() != 200) {
                        throw new IOException(Msg.getString("wiz.httpError") + " " + resp.getStatusCode() + ": " + resp.getReasonLine());
                    }
                    String content = resp.getContentAsString();
                    Element result = Elements.getElementByName("result", content, false);
                    if (result != null) {
                        float usage = (float)Integer.parseInt(result.getAttribute("usage")) / 1024.0f;
                        float quota = (float)Integer.parseInt(result.getAttribute("quota")) / 1024.0f;
                        JProgressBar meter = new JProgressBar(0, (int)quota);
                        meter.setValue((int)usage);
                        meter.setStringPainted(true);
                        DecimalFormat twoDec = new DecimalFormat("0.##");
                        meter.setString(MessageFormat.format(Msg.getString("publish.quotaInfo"), twoDec.format(usage), twoDec.format(quota)));
                        JOptionPane.showMessageDialog(JPublishWizard.this, meter, Msg.getString("publish.getQuota"), 1);
                    }
                }
                catch (Exception ex) {
                    Debug.showErrorDialog(JPublishWizard.this, ex);
                }
            }
        };
        Action copyURLAction = new AbstractAction(null, this.copyIcon){

            public void actionPerformed(ActionEvent e2) {
                StringSelection stringSelection = new StringSelection(PublishStep.this.previewLink.getURL());
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
        };
        Action smartUploadAction = new AbstractAction(Msg.getString("ui.smartUpload"), this.uploadIcon){

            public void actionPerformed(ActionEvent e2) {
                PublishStep.this.doUploadAlbum(false);
            }
        };
        Action uploadAllAction = new AbstractAction(Msg.getString("ui.uploadAll"), this.uploadIcon){

            public void actionPerformed(ActionEvent e2) {
                PublishStep.this.doUploadAlbum(true);
            }
        };
        JToolBar remoteToolBar = new JToolBar();
        JTree tree = new JTree((TreeModel)null);
        DefaultTreeModel treeModel;
        RemoteFSTreeCellRenderer customRenderer;
        JPopupMenu treeMenu;
        JScrollPane remoteTreeScrollPane = new JScrollPane(this.tree);
        JLabel previewLinkLabel = new JLabel(Msg.getString("share.url"));
        JLinkLabel previewLink = new JLinkLabel();
        JButton copyURLButton = new JButton(this.copyURLAction);

        PublishStep() {
            super(Msg.getString("publish.selectDirectory"));
            this.newDirectoryAction.putValue("ShortDescription", Msg.getString("publish.newDirectory"));
            this.deleteDirectoryAction.putValue("ShortDescription", Msg.getString("publish.deleteDirectory"));
            this.renameDirectoryAction.putValue("ShortDescription", Msg.getString("publish.renameDirectory"));
            this.refreshDirectoryAction.putValue("ShortDescription", Msg.getString("publish.refreshDirectory"));
            this.markAsWebRootAction.putValue("ShortDescription", Msg.getString("publish.markAsWebRoot"));
            this.getQuotaAction.putValue("ShortDescription", Msg.getString("publish.getQuota"));
            this.copyURLAction.putValue("ShortDescription", Msg.getString("share.urlToolTip"));
            this.treeMenu = new JPopupMenu();
            this.treeMenu.add(this.newDirectoryAction);
            this.treeMenu.add(this.renameDirectoryAction);
            this.treeMenu.add(this.deleteDirectoryAction);
            this.treeMenu.add(this.refreshDirectoryAction);
            this.treeMenu.add(this.markAsWebRootAction);
            this.tree.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e2) {
                    TreePath selPath = PublishStep.this.tree.getPathForLocation(e2.getX(), e2.getY());
                    int selRow = PublishStep.this.tree.getRowForLocation(e2.getX(), e2.getY());
                    if (selRow != -1 && e2.getClickCount() == 2 && e2.getButton() == 1) {
                        PublishStep.this.previewLink.doClick();
                    }
                    if (e2.getButton() != 1) {
                        PublishStep.this.tree.getSelectionModel().setSelectionPath(selPath);
                    }
                    if (e2.isPopupTrigger() && selPath != null) {
                        PublishStep.this.treeMenu.show(e2.getComponent(), e2.getX(), e2.getY());
                    }
                }

                public void mouseReleased(MouseEvent e2) {
                    TreePath path = PublishStep.this.tree.getPathForLocation(e2.getX(), e2.getY());
                    if (e2.isPopupTrigger() && path != null) {
                        PublishStep.this.treeMenu.show(e2.getComponent(), e2.getX(), e2.getY());
                    }
                }
            });
            this.tree.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e2) {
                    if (e2.getKeyCode() == 127 || JAlbum.isMac() && e2.getKeyCode() == 8) {
                        PublishStep.this.deleteDirectoryAction.actionPerformed(null);
                    } else if (e2.getKeyCode() == 116) {
                        PublishStep.this.refreshDirectoryAction.actionPerformed(null);
                    }
                }
            });
            this.smartUploadAction.putValue("ShortDescription", Msg.getString("ui.smartUploadToolTip"));
            this.uploadAllAction.putValue("ShortDescription", Msg.getString("ui.uploadAllToolTip"));
            this.remoteTreeScrollPane.setPreferredSize(new Dimension(150, 150));
            this.remoteToolBar.setFloatable(false);
            this.remoteToolBar.setOpaque(false);
            this.remoteToolBar.setBorderPainted(false);
            this.remoteToolBar.add(this.newDirectoryAction);
            this.remoteToolBar.add(this.renameDirectoryAction);
            this.remoteToolBar.add(this.deleteDirectoryAction);
            this.remoteToolBar.add(this.refreshDirectoryAction);
            this.remoteToolBar.add(this.markAsWebRootAction);
            this.remoteToolBar.add(this.getQuotaAction);
            this.add(this.remoteToolBar);
            this.add("br hfill vfill", this.remoteTreeScrollPane);
            this.add("p", this.previewLinkLabel);
            this.add("tab", this.previewLink);
            this.add(this.copyURLButton);
        }

        private void refreshFrom(RemoteFSNode node) {
            node.invalidate();
            this.treeModel.nodeStructureChanged(node);
            TreePath webRootPath = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), this.treeModel);
            this.customRenderer.setWebRoot((TreeNode)webRootPath.getLastPathComponent());
        }

        private String discoverWebRoot(TreeModel model) {
            TreePath tp = new TreePath(model.getRoot());
            TreeNode tn = (TreeNode)tp.getLastPathComponent();
            tn.getChildCount();
            Enumeration<? extends TreeNode> children = tn.children();
            HashSet<String> webRootNames = new HashSet<String>();
            webRootNames.add("public_html");
            webRootNames.add("htdocs");
            webRootNames.add("wwwroot");
            webRootNames.add("httpdocs");
            webRootNames.add("www");
            while (children.hasMoreElements()) {
                TreeNode child = children.nextElement();
                if (!webRootNames.contains(child.toString())) continue;
                return child.toString();
            }
            return null;
        }

        public Action[] getActions() {
            if (JAlbum.isMac()) {
                return new Action[]{JPublishWizard.this.cancelAction, JPublishWizard.this.backAction, this.smartUploadAction, this.uploadAllAction};
            }
            return new Action[]{JPublishWizard.this.backAction, this.smartUploadAction, this.uploadAllAction, JPublishWizard.this.cancelAction};
        }

        public void onShow() {
            this.markAsWebRootAction.setEnabled(!JPublishWizard.this.currentAccount.isMyjalbum());
            this.getQuotaAction.setEnabled(JPublishWizard.this.currentAccount.isMyjalbum());
            this.treeModel = new DefaultTreeModel(JPublishWizard.this.rootNode);
            this.tree.setModel(this.treeModel);
            this.tree.setEditable(true);
            this.tree.getSelectionModel().setSelectionMode(1);
            new RemoteFSTreeTransferHandler(this.tree, JPublishWizard.this.uploadBean, 2);
            this.treeModel.addTreeModelListener(new TreeModelListener(){

                public void treeNodesChanged(TreeModelEvent e2) {
                    RemoteFSNode node = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                    try {
                        if (!node.isRealDirectory()) {
                            ((PublishStep)PublishStep.this).JPublishWizard.this.uploadBean.getRemoteFSBean().createDirectory(node.remotePath());
                        } else if (!node.oldRemotePath().equals(node.remotePath())) {
                            ((PublishStep)PublishStep.this).JPublishWizard.this.uploadBean.getRemoteFSBean().rename(node.oldRemotePath(), node.remotePath());
                        }
                        node.setRemoteName(node.toString());
                        JPublishWizard.this.setRemoteDirectory(node.remotePath());
                        PublishStep.this.updateView();
                    }
                    catch (RemoteFSException ex) {
                        UploadBean.showErrorDialog(JPublishWizard.this, ex, Msg.getString("publish.serverReportedInfo"), Msg.getString("publish.renameDirectory"));
                        ((AutoSelectingTreeCellEditor)PublishStep.this.tree.getCellEditor()).ignoreFocusLost = true;
                        PublishStep.this.tree.startEditingAtPath(PublishStep.this.tree.getSelectionPath());
                    }
                    catch (IOException ex) {
                        Debug.showErrorDialog(JPublishWizard.this, ex);
                        ((AutoSelectingTreeCellEditor)PublishStep.this.tree.getCellEditor()).ignoreFocusLost = true;
                        PublishStep.this.tree.startEditingAtPath(PublishStep.this.tree.getSelectionPath());
                    }
                }

                public void treeNodesInserted(TreeModelEvent e2) {
                }

                public void treeNodesRemoved(TreeModelEvent e2) {
                }

                public void treeStructureChanged(TreeModelEvent e2) {
                }
            });
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e2) {
                    String remotePath = RemoteFSNode.remotePath(e2.getPath());
                    JPublishWizard.this.setRemoteDirectory(remotePath);
                    PublishStep.this.updateView();
                }
            });
            this.customRenderer = new RemoteFSTreeCellRenderer();
            String webRoot = JPublishWizard.this.getFtpWebRootDirectory();
            if (webRoot.equals("VALUE_UNSET")) {
                webRoot = this.discoverWebRoot(this.treeModel);
                if (webRoot == null) {
                    webRoot = JPublishWizard.this.currentAccount.isShowServerRootDirectory() ? JPublishWizard.this.currentWorkingDirectory : "";
                }
                JPublishWizard.this.setFtpWebRootDirectory(webRoot);
            }
            TreePath webRootPath = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), this.treeModel);
            this.customRenderer.setWebRoot((TreeNode)webRootPath.getLastPathComponent());
            this.tree.setCellRenderer(this.customRenderer);
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            AutoSelectingTreeCellEditor editor = new AutoSelectingTreeCellEditor(this.tree, this.customRenderer);
            this.tree.setCellEditor(editor);
            this.tree.getCellEditor().addCellEditorListener(new CellEditorListener(){

                public void editingCanceled(ChangeEvent e2) {
                    RemoteFSNode lastNode = (RemoteFSNode)PublishStep.this.tree.getLastSelectedPathComponent();
                    if (lastNode != null && !lastNode.isRealDirectory()) {
                        PublishStep.this.tree.setSelectionPath(new TreePath(lastNode.getParent()));
                        PublishStep.this.treeModel.removeNodeFromParent(lastNode);
                    }
                }

                public void editingStopped(ChangeEvent e2) {
                }
            });
            TreePath tp = RemoteFSNode.treePath(JPublishWizard.this.getRemoteDirectory(), this.treeModel);
            boolean notFound = false;
            if (tp.getLastPathComponent() == this.treeModel.getRoot()) {
                notFound = true;
                tp = RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), this.treeModel);
            }
            this.tree.setSelectionPath(tp);
            this.tree.scrollPathToVisible(tp);
            this.updateView();
            if (notFound) {
                this.newDirectoryAction.actionPerformed(null);
            }
        }

        public void onHide() {
            this.tree.setModel(null);
            try {
                ToolTipManager.sharedInstance().unregisterComponent(this.tree);
                JPublishWizard.this.uploadBean.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void updateView() {
            String uri;
            boolean underWebDir = false;
            String webRoot = JPublishWizard.this.getFtpWebRootDirectory();
            if (webRoot == null) {
                webRoot = "";
            }
            if ((uri = IO.relativePath(JPublishWizard.this.getRemoteDirectory(), webRoot)).startsWith("..")) {
                this.previewLink.setText(Msg.getString("publish.NoWebDirectorySelected"));
                this.previewLink.setURL(null);
                this.copyURLAction.setEnabled(false);
            } else {
                underWebDir = true;
                if (uri.equals(".")) {
                    uri = "";
                }
                String url = IO.combinePaths(JPublishWizard.this.currentAccount.getWebRootURL(), uri);
                this.previewLink.setText(url);
                this.previewLink.setURL(url + '/');
                this.copyURLAction.setEnabled(true);
            }
            RemoteFSNode node = (RemoteFSNode)this.tree.getLastSelectedPathComponent();
            boolean isRootSelected = node == null || node.isRoot();
            this.renameDirectoryAction.setEnabled(!isRootSelected);
            this.deleteDirectoryAction.setEnabled(!isRootSelected);
            this.smartUploadAction.setEnabled(underWebDir && (!JPublishWizard.this.currentAccount.isMyjalbum() || !isRootSelected));
            this.uploadAllAction.setEnabled(underWebDir && (!JPublishWizard.this.currentAccount.isMyjalbum() || !isRootSelected));
        }

        private void doUploadAlbum(final boolean fullUpdate) {
            int answer;
            ((JAlbumFrame)JPublishWizard.this.getOwner()).ui2Engine();
            File dir2 = JPublishWizard.this.engine.getInterpretedOutputDirectory();
            if (!dir2.isDirectory()) {
                JOptionPane.showMessageDialog(this, Msg.getString("publish.invalidOutputDirectoryError"), Msg.getString("publish.publishAlbumTitle"), 0);
                return;
            }
            if (this.tree.getLastSelectedPathComponent() == RemoteFSNode.treePath(JPublishWizard.this.getFtpWebRootDirectory(), this.treeModel).getLastPathComponent() && (JAlbum.mainFrame.preferencesWindow.showWarnings.isSelected() || fullUpdate) && (answer = JOptionPane.showConfirmDialog(this, Msg.getString("publish.publishToRootWarning"), Msg.getString("publish.publishAlbumTitle"), 0, 2)) != 0) {
                return;
            }
            int res = JOptionPane.showConfirmDialog(this, MessageFormat.format(Msg.getString("publish.uploadConfirmation"), this.previewLink.getURL()), Msg.getString("ui.uploadConfirmationTitle"), 2, 1);
            if (res != 0) {
                return;
            }
            final JUploadProgressDialog uploadProgress = new JUploadProgressDialog(JPublishWizard.this, Msg.getString("ui.uploadingAlbumTitle"), false);
            Thread uploadThread = new Thread("Upload thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ((PublishStep)PublishStep.this).JPublishWizard.this.uploadBean.addUploadListener(uploadProgress);
                        ((PublishStep)PublishStep.this).JPublishWizard.this.uploadBean.uploadAlbum(((PublishStep)PublishStep.this).JPublishWizard.this.engine, fullUpdate);
                        uploadProgress.setVisible(false);
                        uploadProgress.dispose();
                        if (((PublishStep)PublishStep.this).JPublishWizard.this.currentAccount.isMyjalbum()) {
                            PublishStep.this.previewLink.doClick();
                        }
                    }
                    catch (OperationAbortedException ex) {
                    }
                    catch (Throwable t2) {
                        if ("2: No such file".equals(t2.getMessage())) {
                            JOptionPane.showMessageDialog(JPublishWizard.this, Msg.getString("publish.quotaExceeded"), Msg.getString("ui.uploadingAlbumTitle"), 0);
                            return;
                        }
                        Debug.showErrorDialog(JPublishWizard.this, t2);
                    }
                    finally {
                        ((PublishStep)PublishStep.this).JPublishWizard.this.uploadBean.removeUploadListener(uploadProgress);
                    }
                }
            };
            uploadThread.start();
            this.enableActions(false);
            uploadProgress.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e2) {
                    PublishStep.this.enableActions(true);
                }

                public void windowClosed(WindowEvent e2) {
                    PublishStep.this.enableActions(true);
                }
            });
            uploadProgress.setVisible(true);
        }

        private void enableActions(boolean enable) {
            if (!enable) {
                JPublishWizard.this.setDefaultCloseOperation(0);
            } else {
                JPublishWizard.this.setDefaultCloseOperation(1);
            }
            JPublishWizard.this.backAction.setEnabled(enable);
            JPublishWizard.this.finishAction.setEnabled(enable);
            JPublishWizard.this.cancelAction.setEnabled(enable);
            this.newDirectoryAction.setEnabled(enable);
            this.renameDirectoryAction.setEnabled(enable);
            this.deleteDirectoryAction.setEnabled(enable);
            this.refreshDirectoryAction.setEnabled(enable);
            this.markAsWebRootAction.setEnabled(enable && !JPublishWizard.this.currentAccount.isMyjalbum());
            this.tree.setEnabled(enable);
            this.uploadAllAction.setEnabled(enable);
            this.smartUploadAction.setEnabled(enable);
        }
    }

    class AccountsStep
    extends JWizardStep {
        ImageIcon addAccountIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/user1_add.png"));
        ImageIcon deleteAccountIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/user1_delete.png"));
        ImageIcon accountWizardIcon = new ImageIcon((class$se$datadosen$jalbum$JAlbumFrame == null ? (class$se$datadosen$jalbum$JAlbumFrame = JPublishWizard.class$("se.datadosen.jalbum.JAlbumFrame")) : class$se$datadosen$jalbum$JAlbumFrame).getResource("images/publish/magic-wand.png"));
        ImageIcon advancedIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/wrench16.png"));
        ImageIcon plugIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/plug.png"));
        ImageIcon serverIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/server_large.png"));
        ImageIcon serverConnectionIcon = new ImageIcon((class$se$datadosen$jalbum$JPublishWizard == null ? (class$se$datadosen$jalbum$JPublishWizard = JPublishWizard.class$("se.datadosen.jalbum.JPublishWizard")) : class$se$datadosen$jalbum$JPublishWizard).getResource("images/publish/server_connection_large.png"));
        JButton addAccountButton = new JIconButton();
        JButton removeAccountButton = new JIconButton();
        JList accountList;
        JScrollPane accountsScrollPane;
        ControlPanel currentAccountPanel;
        JLabel ftpServerLabel;
        JTextField ftpServer;
        JLabel ftpUserNameLabel;
        JTextField ftpUser;
        JLabel ftpPasswordLabel;
        JPasswordField ftpPassword;
        JButton advancedAccountSettingsButton;
        JAdvancedAccountSettingsDialog advancedSettingsDialog;
        Action connectAction;

        AccountsStep() {
            super(Msg.getString("acc.profilesLabel"));
            this.accountList = new JList(JPublishWizard.this.accounts);
            this.accountsScrollPane = new JScrollPane(this.accountList);
            this.currentAccountPanel = new ControlPanel(Msg.getString("publish.currentAccountBorder"));
            this.ftpServerLabel = new JLabel(Msg.getString("ui.ftpServer"));
            this.ftpServer = new JSmartTextField(16);
            this.ftpUserNameLabel = new JLabel(Msg.getString("ui.userName"));
            this.ftpUser = new JSmartTextField(16);
            this.ftpPasswordLabel = new JLabel(Msg.getString("ui.password"));
            this.ftpPassword = new JPasswordField(16);
            this.advancedAccountSettingsButton = new JIconButton(Msg.getString("ui.advancedPanel"), this.advancedIcon);
            this.advancedSettingsDialog = new JAdvancedAccountSettingsDialog(JPublishWizard.this, false);
            this.connectAction = new AbstractAction(Msg.getString("publish.connect"), this.plugIcon){

                public void actionPerformed(ActionEvent e2) {
                    BeanBinder.setProperties((Object)((AccountsStep)AccountsStep.this).JPublishWizard.this.uploadBean, AccountsStep.this);
                    BeanBinder.setProperties((Object)((AccountsStep)AccountsStep.this).JPublishWizard.this.uploadBean, AccountsStep.this.advancedSettingsDialog);
                    BeanBinder.setProperties((Object)((AccountsStep)AccountsStep.this).JPublishWizard.this.currentAccount, AccountsStep.this);
                    BeanBinder.setProperties((Object)((AccountsStep)AccountsStep.this).JPublishWizard.this.currentAccount, AccountsStep.this.advancedSettingsDialog);
                    if (AccountsStep.this.ftpPassword.getPassword().length == 0) {
                        String password = JPublishWizard.showPasswordInputDialog(JPublishWizard.this, Msg.getString("publish.enterPasswordInfo"), Msg.getString("publish.connect"), null);
                        if (password != null) {
                            ((AccountsStep)AccountsStep.this).JPublishWizard.this.uploadBean.setFtpPassword(password);
                        } else {
                            return;
                        }
                    }
                    SlowOperation connectOp = new SlowOperation(){

                        public void operation() throws Throwable {
                            ((AccountsStep)(this).AccountsStep.this).JPublishWizard.this.uploadBean.connect();
                            RemoteFSNode.setLateDiscovery(!((AccountsStep)(this).AccountsStep.this).JPublishWizard.this.currentAccount.isMyjalbum());
                            ((AccountsStep)(this).AccountsStep.this).JPublishWizard.this.currentWorkingDirectory = ((AccountsStep)(this).AccountsStep.this).JPublishWizard.this.uploadBean.getRemoteFSBean().getDirectory();
                            if (((AccountsStep)(this).AccountsStep.this).JPublishWizard.this.currentAccount.isShowServerRootDirectory()) {
                                ((AccountsStep)(this).AccountsStep.this).JPublishWizard.this.uploadBean.getRemoteFSBean().setDirectory("/");
                            }
                            ((AccountsStep)(this).AccountsStep.this).JPublishWizard.this.engine.setAccountProfileName(((AccountsStep)(this).AccountsStep.this).JPublishWizard.this.currentAccount.getName());
                            ((AccountsStep)(this).AccountsStep.this).JPublishWizard.this.rootNode = new RemoteFSNode((this).AccountsStep.this.ftpServer.getText(), false, ((AccountsStep)(this).AccountsStep.this).JPublishWizard.this.uploadBean.getRemoteFSBean(), (Window)JPublishWizard.this);
                        }

                        public void abort() {
                            try {
                                ((AccountsStep)(this).AccountsStep.this).JPublishWizard.this.uploadBean.getRemoteFSBean().abortConnect();
                            }
                            catch (RemoteFSException ex) {
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    };
                    try {
                        boolean done = connectOp.launch(JPublishWizard.this, new JLabel(Msg.getString("ui.connectingToServer") + " " + AccountsStep.this.ftpServer.getText() + "...", AccountsStep.this.serverIcon, 10), AccountsStep.this.serverConnectionIcon, Msg.getString("publish.connect"));
                        if (done) {
                            ((AccountsStep)AccountsStep.this).JPublishWizard.this.nextAction.actionPerformed(null);
                        }
                    }
                    catch (RemoteFSException ex) {
                        UploadBean.showErrorDialog(JPublishWizard.this, ex, Msg.getString("publish.connectionError") + ". " + Msg.getString("publish.serverReportedInfo"), Msg.getString("publish.connect"));
                    }
                    catch (Throwable ex) {
                        ((AccountsStep)AccountsStep.this).JPublishWizard.this.uploadBean.disconnect();
                        Debug.showErrorDialog(JPublishWizard.this, ex);
                    }
                }
            };
            this.addAccountButton.setText(Msg.getString("add"));
            this.addAccountButton.setIcon(this.addAccountIcon);
            this.addAccountButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    AccountsStep.this.addAccountButton_actionPerformed(e2);
                }
            });
            this.removeAccountButton.setText(Msg.getString("remove"));
            this.removeAccountButton.setIcon(this.deleteAccountIcon);
            this.removeAccountButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    AccountsStep.this.removeAccountButton_actionPerformed(e2);
                }
            });
            this.advancedAccountSettingsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    AccountsStep.this.advancedSettingsDialog.setVisible(true);
                }
            });
            this.ftpServer.setToolTipText(Msg.getString("ui.ftpServerToolTip"));
            this.ftpUser.setToolTipText(Msg.getString("ui.userNameToolTip"));
            this.ftpPassword.setToolTipText(Msg.getString("ui.passwordToolTip"));
            this.ftpServer.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e2) {
                    char c2 = e2.getKeyChar();
                    if (c2 == ':' || c2 == '/' || c2 == ' ' || c2 == ',') {
                        e2.consume();
                    }
                }

                public void keyReleased(KeyEvent e2) {
                    AccountsStep.this.modifyAccountName();
                }
            });
            this.ftpUser.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e2) {
                    AccountsStep.this.modifyAccountName();
                }
            });
            this.add(this.addAccountButton);
            this.add(this.removeAccountButton);
            this.add("br hfill vfill", this.accountsScrollPane);
            this.currentAccountPanel.add(this.ftpServerLabel);
            this.currentAccountPanel.add("tab", this.ftpServer);
            this.currentAccountPanel.add("br", this.ftpUserNameLabel);
            this.currentAccountPanel.add("tab", this.ftpUser);
            this.currentAccountPanel.add("br", this.ftpPasswordLabel);
            this.currentAccountPanel.add("tab", this.ftpPassword);
            this.currentAccountPanel.add("tab", this.advancedAccountSettingsButton);
            this.add("br hfill", this.currentAccountPanel);
            this.loadAccounts();
            this.accountList.setSelectionMode(0);
            this.accountList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e2) {
                    if (((AccountsStep)AccountsStep.this).JPublishWizard.this.currentAccount != null) {
                        BeanBinder.setProperties((Object)((AccountsStep)AccountsStep.this).JPublishWizard.this.currentAccount, AccountsStep.this);
                        BeanBinder.setProperties((Object)((AccountsStep)AccountsStep.this).JPublishWizard.this.currentAccount, AccountsStep.this.advancedSettingsDialog);
                    }
                    ((AccountsStep)AccountsStep.this).JPublishWizard.this.currentAccount = (AccountProfile)AccountsStep.this.accountList.getSelectedValue();
                    AccountsStep.this.updateView();
                }
            });
            this.accountList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e2) {
                    if (e2.getClickCount() == 2) {
                        AccountsStep.this.connectAction.actionPerformed(null);
                    }
                }
            });
            try {
                this.accountList.setSelectedValue(new AccountProfile(JPublishWizard.this.engine.getAccountProfileName()), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.accountList.getSelectedIndex() == -1 && this.accountList.getModel().getSize() > 0) {
                this.accountList.setSelectedIndex(0);
            }
            this.updateView();
        }

        private void modifyAccountName() {
            String finalName = this.ftpServer.getText();
            String userName = this.ftpUser.getText();
            if (userName.length() > 0) {
                finalName = finalName + " - " + userName;
            }
            if (finalName.length() > 0) {
                JPublishWizard.this.currentAccount.setName(finalName);
            } else {
                JPublishWizard.this.currentAccount.setName(Msg.getString("publish.NewAccount"));
            }
            this.accountList.updateUI();
        }

        public Action[] getActions() {
            if (JAlbum.isMac()) {
                return new Action[]{JPublishWizard.this.cancelAction, this.connectAction};
            }
            return new Action[]{this.connectAction, JPublishWizard.this.cancelAction};
        }

        public Action getDefaultAction() {
            return this.connectAction;
        }

        private void updateView() {
            this.removeAccountButton.setEnabled(this.accountList.getSelectedIndex() >= 0);
            if (JPublishWizard.this.accounts.getSize() > 0) {
                AccountProfile a2 = (AccountProfile)this.accountList.getSelectedValue();
                if (a2 == null) {
                    this.accountList.setSelectedIndex(JPublishWizard.this.accounts.getSize() - 1);
                    a2 = (AccountProfile)this.accountList.getSelectedValue();
                }
                BeanBinder.getProperties((Object)a2, this);
                BeanBinder.getProperties((Object)a2, this.advancedSettingsDialog);
                this.accountList.setEnabled(true);
                this.currentAccountPanel.setEnabled(true);
                this.connectAction.setEnabled(true);
                this.currentAccountPanel.setEnabled(!a2.isProtected());
                this.advancedAccountSettingsButton.setEnabled(!a2.isProtected());
                if (JPublishWizard.this.accountsStep != null) {
                    JPublishWizard.this.accountsStep.ftpPasswordLabel.setEnabled(true);
                    JPublishWizard.this.accountsStep.ftpPassword.setEnabled(true);
                }
            } else {
                this.accountList.setEnabled(false);
                this.currentAccountPanel.setEnabled(false);
                this.connectAction.setEnabled(false);
            }
        }

        void addAccountButton_actionPerformed(ActionEvent e2) {
            try {
                String activationUrl;
                JAlbumSite theSite = JAlbumSite.getInstance();
                String string = activationUrl = (e2.getModifiers() & 8) != 0 ? theSite.getMyJAlbumAltActivationUrl() : theSite.getMyJAlbumActivationUrl();
                if (activationUrl != null && activationUrl.length() > 0) {
                    JAddAccountDialog dialog = new JAddAccountDialog(JPublishWizard.this, true, (e2.getModifiers() & 8) != 0);
                    dialog.setVisible(true);
                    return;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, Msg.getString("ui.softwareFirewallInfo"), Msg.getString("publish.connectionError"), 0);
            }
            this.addAccount(new AccountProfile(Msg.getString("publish.NewAccount")));
        }

        void removeAccountButton_actionPerformed(ActionEvent e2) {
            AccountProfile account = (AccountProfile)this.accountList.getSelectedValue();
            if (account == null) {
                return;
            }
            int answer = JOptionPane.showConfirmDialog(this, MessageFormat.format(Msg.getString("acc.removeAccountInfo"), account.getName()), Msg.getString("acc.removeAccountTitle"), 0);
            if (answer == 0) {
                this.removeAccount(account);
            }
        }

        String uniqueName(String name, AbstractCollection names) {
            if (names.contains(name)) {
                int i2;
                for (i2 = name.length() - 1; i2 >= 0 && Character.isDigit(name.charAt(i2)); --i2) {
                }
                String base = name.substring(0, i2 + 1);
                i2 = 1;
                while (names.contains(name = base + i2)) {
                    ++i2;
                }
            }
            return name;
        }

        public void addAccount(AccountProfile newAccount) {
            Vector<String> names = new Vector<String>();
            Enumeration e2 = JPublishWizard.this.accounts.elements();
            while (e2.hasMoreElements()) {
                AccountProfile account = (AccountProfile)e2.nextElement();
                names.add(account.getName());
            }
            newAccount.setName(this.uniqueName(newAccount.getName(), names));
            JPublishWizard.this.accounts.addElement(newAccount);
            this.accountList.setSelectedIndex(JPublishWizard.this.accounts.getSize() - 1);
            this.updateView();
            this.ftpServer.requestFocus();
        }

        void saveAccounts() {
            try {
                FileWriter out = new FileWriter(accountsFile);
                Element ftpAccounts = new Element("ftp-accounts");
                Enumeration e2 = JPublishWizard.this.accounts.elements();
                while (e2.hasMoreElements()) {
                    AccountProfile account = (AccountProfile)e2.nextElement();
                    Element el = new Element("account");
                    el.setAttributes(BeanBinder.getProperties(account));
                    ftpAccounts.addContentElement(el);
                }
                XMLDocument doc = new XMLDocument(ftpAccounts);
                out.write(doc.toString());
                out.close();
            }
            catch (Exception ex) {
                Debug.showErrorDialog(this, ex);
            }
        }

        void loadAccounts() {
            try {
                Element ae;
                String doc;
                if (!accountsFile.exists()) {
                    return;
                }
                String rest = doc = IO.readTextFile(accountsFile);
                while ((ae = Elements.getElementByName("account", rest, false)) != null) {
                    AccountProfile a2 = new AccountProfile();
                    BeanBinder.setProperties((Object)a2, ae.getAttributes());
                    JPublishWizard.this.accounts.addElement(a2);
                    rest = ae.getPostElement();
                }
            }
            catch (Exception ex) {
                Debug.showErrorDialog(this, ex);
            }
        }

        public void removeAccount(AccountProfile oldAccount) {
            int oldIndex = this.accountList.getSelectedIndex();
            JPublishWizard.this.accounts.removeElement(oldAccount);
            if (oldIndex < JPublishWizard.this.accounts.size()) {
                this.accountList.setSelectedIndex(oldIndex);
            }
        }

        public void onShow() {
        }

        public void onHide() {
            if (JPublishWizard.this.currentAccount != null) {
                BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, this);
                BeanBinder.setProperties((Object)JPublishWizard.this.currentAccount, this.advancedSettingsDialog);
            }
            this.saveAccounts();
        }
    }
}

