/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFile;
import java.awt.Cursor;
import java.awt.Window;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import se.datadosen.util.IO;

public class RemoteFSNode
extends DefaultMutableTreeNode {
    private boolean childrenDefined = false;
    private boolean albumChecked = false;
    private RemoteFSBean bean;
    private Window window;
    private String remoteName;
    private int plainFileCount = 0;
    private boolean link;
    private boolean album;
    private static boolean lateDiscovery = true;

    public RemoteFSNode(String name, String remoteName, RemoteFSBean remoteFSBean, Window window) {
        this(name, false, remoteFSBean, window);
        this.remoteName = remoteName;
    }

    public RemoteFSNode(String name, boolean link, RemoteFSBean remoteFSBean, Window window) {
        this.remoteName = name;
        this.link = link;
        this.bean = remoteFSBean;
        this.window = window;
        super.setUserObject(name);
    }

    public static boolean isLateDiscovery() {
        return lateDiscovery;
    }

    public static void setLateDiscovery(boolean lateDiscovery) {
        RemoteFSNode.lateDiscovery = lateDiscovery;
    }

    public void setUserObject(Object userObject) {
        super.setUserObject(userObject);
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean isLink() {
        return this.link;
    }

    public boolean isAlbum() {
        if (!lateDiscovery && !this.albumChecked) {
            this.albumChecked = true;
            String path = RemoteFSNode.remotePath(new TreePath(this.getPath()));
            path = IO.combinePaths(path, "thumbs");
            try {
                this.album = this.bean.exists(path);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                return false;
            }
        }
        return this.album;
    }

    public boolean areChildrenDefined() {
        return this.childrenDefined;
    }

    public int getChildCount() {
        if (!this.childrenDefined) {
            this.defineChildNodes();
        }
        return super.getChildCount();
    }

    public int getPlainFileCount() {
        if (!this.childrenDefined) {
            this.defineChildNodes();
        }
        return this.plainFileCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defineChildNodes() {
        this.childrenDefined = true;
        this.plainFileCount = 0;
        String path = RemoteFSNode.remotePath(new TreePath(this.getPath()));
        if (this.window != null) {
            this.window.setCursor(new Cursor(3));
        }
        try {
            RemoteFile[] files = this.bean.getFiles(path, RemoteFSBean.noDotDotDotFileFilter);
            for (int i2 = 0; i2 < files.length; ++i2) {
                RemoteFile file = files[i2];
                if (file.isDirectory() || file.isLink()) {
                    String name = file.getName();
                    if (name.equals("slides") || name.equals("thumbs") || name.equals("res")) {
                        this.album = true;
                        continue;
                    }
                    this.add(new RemoteFSNode(file.getName(), file.isLink(), this.bean, this.window));
                    continue;
                }
                ++this.plainFileCount;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            if (this.window != null) {
                this.window.setCursor(new Cursor(0));
            }
        }
    }

    public boolean isRealDirectory() {
        return this.remoteName != null && this.remoteName.length() > 0;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public void invalidate() {
        this.removeAllChildren();
        this.childrenDefined = false;
    }

    public String remotePath() {
        return RemoteFSNode.remotePath(new TreePath(this.getPath()));
    }

    public String oldRemotePath() {
        return RemoteFSNode.oldRemotePath(new TreePath(this.getPath()));
    }

    public static String remotePath(TreePath tp) {
        StringBuffer buf = new StringBuffer();
        Object[] path = tp.getPath();
        for (int i2 = 1; i2 < path.length; ++i2) {
            if (i2 > 1) {
                buf.append('/');
            }
            buf.append(path[i2]);
        }
        return buf.toString();
    }

    public static String oldRemotePath(TreePath tp) {
        StringBuffer buf = new StringBuffer();
        Object[] nodes = tp.getPath();
        for (int i2 = 1; i2 < nodes.length; ++i2) {
            if (i2 > 1) {
                buf.append('/');
            }
            buf.append(((RemoteFSNode)nodes[i2]).getRemoteName());
        }
        return buf.toString();
    }

    public static TreePath treePath(String remotePath, TreeModel model) {
        StringTokenizer pathComponents = new StringTokenizer(remotePath, "/");
        TreePath tp = new TreePath(model.getRoot());
        while (pathComponents.hasMoreTokens()) {
            String pathComponent = pathComponents.nextToken();
            TreeNode tn = (TreeNode)tp.getLastPathComponent();
            tn.getChildCount();
            Enumeration<? extends TreeNode> children = tn.children();
            TreeNode found = null;
            while (children.hasMoreElements()) {
                TreeNode child = children.nextElement();
                if (!pathComponent.equals(child.toString())) continue;
                found = child;
                tp = tp.pathByAddingChild(child);
                break;
            }
            if (found != null) continue;
            return tp;
        }
        return tp;
    }
}

