/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import info.cqs.remotefs.RemoteFSBean;
import info.cqs.remotefs.RemoteFSException;
import info.cqs.remotefs.RemoteFSProgressMonitor;
import info.cqs.remotefs.RemoteFile;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.OperationAbortedException;
import se.datadosen.jalbum.ParameterException;
import se.datadosen.jalbum.UploadFileFilter;
import se.datadosen.jalbum.UploadListener;
import se.datadosen.util.IO;

public class UploadBean
implements RemoteFSProgressMonitor {
    private static final String TIME_DIFF_TEST_NAME = "timedifftester";
    private transient Vector uploadListeners;
    private RemoteFSBean remoteFSBean = new RemoteFSBean();
    private int processedFiles;
    private int totalFiles;
    private AlbumBean engine;
    private String remoteDirectory = "album";
    private String ftpServer = "";
    private String ftpUser = "";
    private String ftpPassword = "";
    private boolean ftpForceUTF8 = false;
    private boolean secureFtp = false;
    private boolean passiveMode = true;
    private int ftpPort = 21;
    private long timeDifference = 0L;

    public static void showErrorDialog(Component owner, RemoteFSException ex, String messagePrefix, String title) {
        String message = messagePrefix != null ? messagePrefix + ": " : "";
        message = message + (ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage());
        JOptionPane.showMessageDialog(owner, message, title, 0);
    }

    protected void finalize() throws Throwable {
        if (this.remoteFSBean.isConnected()) {
            this.remoteFSBean.disconnect();
        }
    }

    public RemoteFSBean getRemoteFSBean() {
        return this.remoteFSBean;
    }

    private void deleteDirectory2(String remotePath) throws RemoteFSException, IOException {
        RemoteFile[] files = this.remoteFSBean.getFiles(remotePath, RemoteFSBean.noDotDotDotFileFilter);
        for (int i2 = 0; i2 < files.length; ++i2) {
            AlbumBeanEvent eventObject = new AlbumBeanEvent(this, null, remotePath, files[i2].getName(), 0, 1, 0, 1);
            this.fireImageProcessingStarted(eventObject);
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            String fullPath = IO.combinePaths(remotePath, files[i2].getName());
            if (files[i2].isDirectory()) {
                this.deleteDirectory2(fullPath);
            } else {
                this.remoteFSBean.removeFile(fullPath);
            }
            this.fireImageProcessingFinished(eventObject);
        }
        this.remoteFSBean.removeDirectory(remotePath);
    }

    public void deleteDirectory(String remoteDir) throws ParameterException, RemoteFSException, IOException {
        if (remoteDir.length() == 0) {
            throw new ParameterException("Cannot delete ftp root (security)");
        }
        this.deleteDirectory2(remoteDir);
    }

    public void setFtpServer(String newFtpServer) {
        this.ftpServer = newFtpServer.trim();
        int colonIndex = this.ftpServer.indexOf("://");
        if (colonIndex != -1) {
            this.ftpServer = this.ftpServer.substring(colonIndex + 3);
        }
    }

    public String getFtpServer() {
        return this.ftpServer;
    }

    public void setFtpPort(int newFtpPort) throws RemoteFSException {
        this.ftpPort = newFtpPort;
    }

    public int getFtpPort() throws RemoteFSException {
        return this.ftpPort;
    }

    public void setFtpUser(String newFtpUser) {
        this.ftpUser = newFtpUser.trim();
    }

    public String getFtpUser() {
        return this.ftpUser;
    }

    public void setFtpPassword(String newFtpPassword) {
        this.ftpPassword = newFtpPassword.trim();
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    public void setRemoteDirectory(String newRemoteDirectory) {
        this.remoteDirectory = newRemoteDirectory.trim();
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public boolean isFtpForceUTF8() throws RemoteFSException {
        return this.ftpForceUTF8;
    }

    public void setFtpForceUTF8(boolean force) throws RemoteFSException {
        this.ftpForceUTF8 = force;
    }

    public void setSecureFtp(boolean newSecureFtp) {
        this.secureFtp = newSecureFtp;
    }

    public boolean isSecureFtp() {
        return this.secureFtp;
    }

    public void setPassiveMode(boolean newPassiveMode) throws RemoteFSException {
        this.passiveMode = newPassiveMode;
    }

    public boolean isPassiveMode() throws RemoteFSException {
        return this.passiveMode;
    }

    public void connect() throws RemoteFSException, IOException {
        this.remoteFSBean.setSecure(this.isSecureFtp());
        this.remoteFSBean.setProgressMonitor(this);
        this.remoteFSBean.setForceUTF8(this.isFtpForceUTF8());
        this.remoteFSBean.setPassiveMode(this.isPassiveMode());
        this.remoteFSBean.setPort(this.getFtpPort());
        this.remoteFSBean.connect(this.getFtpServer(), this.getFtpUser(), this.getFtpPassword());
    }

    public void disconnect() {
        try {
            this.remoteFSBean.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testConnection(AlbumBean engine) throws IOException, RemoteFSException {
        this.remoteFSBean.testConnection(this.getFtpServer(), this.getFtpUser(), this.getFtpPassword());
    }

    public void uploadAlbum(AlbumBean engine, boolean fullUpdate) throws ParameterException, RemoteFSException, IOException, OperationAbortedException {
        this.engine = engine;
        File dir2 = engine.getInterpretedOutputDirectory();
        if (!dir2.isDirectory()) {
            throw new IOException(Msg.getString("publish.invalidOutputDirectoryError"));
        }
        this.processedFiles = 0;
        this.remoteFSBean.setProgressMonitor(this);
        String remoteDir = engine.getRemoteDirectory();
        Map remoteFiles = null;
        if (!fullUpdate) {
            AlbumBeanEvent eventObject = new AlbumBeanEvent(this, dir2, dir2.getName(), Msg.getString("upload.comparingFilesInfo"), 1, 1, 1, 1);
            this.fireImageProcessingStarted(eventObject);
            this.timeDifference = this.calcTimeDifference();
            remoteFiles = this.scanRemoteFiles(dir2, remoteDir);
        }
        this.totalFiles = this.countFiles(dir2, remoteFiles);
        this.uploadAlbumDirectory(dir2, remoteFiles, remoteDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calcTimeDifference() {
        File tempfile = null;
        long diff = 0L;
        try {
            tempfile = File.createTempFile("JAlbumDateDiffTester", ".tmp");
            String remotePath = IO.combinePaths(this.engine.getRemoteDirectory(), TIME_DIFF_TEST_NAME);
            Date localTime = new Date();
            this.remoteFSBean.putFile(tempfile, remotePath);
            RemoteFile[] files = this.remoteFSBean.getFiles(this.engine.getRemoteDirectory());
            this.remoteFSBean.removeFile(remotePath);
            for (int i2 = 0; i2 < files.length; ++i2) {
                if (!files[i2].getName().equals(TIME_DIFF_TEST_NAME)) continue;
                diff = files[i2].getModificationDate().getTime() - localTime.getTime();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (RemoteFSException ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            if (tempfile != null) {
                tempfile.delete();
            }
        }
        return diff;
    }

    private void uploadAlbumDirectory(File dir2, Map remoteFiles, String remotePath) throws RemoteFSException, IOException, OperationAbortedException {
        File[] filesDirs = dir2.listFiles(new UploadFileFilter());
        for (int i2 = 0; i2 < filesDirs.length; ++i2) {
            RemoteFile rf;
            Object o2;
            if (filesDirs[i2].isDirectory()) {
                String newPath = IO.combinePaths(remotePath, filesDirs[i2].getName());
                try {
                    this.remoteFSBean.createDirectory(newPath);
                }
                catch (RemoteFSException ex) {
                    // empty catch block
                }
                this.uploadAlbumDirectory(filesDirs[i2], remoteFiles, newPath);
                continue;
            }
            if (remoteFiles != null && (o2 = remoteFiles.get(filesDirs[i2])) != null && this.identical(filesDirs[i2], rf = (RemoteFile)o2)) continue;
            AlbumBeanEvent eventObject = new AlbumBeanEvent(this, dir2, dir2.getName(), filesDirs[i2].getName(), i2 + 1, filesDirs.length, this.processedFiles + 1, this.totalFiles);
            this.fireImageProcessingStarted(eventObject);
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            int attempt = 1;
            while (true) {
                try {
                    if (attempt > 1) {
                        if (this.remoteFSBean.isConnected()) {
                            this.remoteFSBean.disconnect();
                        }
                        this.remoteFSBean.reconnect();
                    }
                    this.remoteFSBean.putFile(filesDirs[i2], IO.combinePaths(remotePath, filesDirs[i2].getName()));
                }
                catch (IOException ex) {
                    if (attempt > 6) {
                        throw ex;
                    }
                    System.err.println("Caught " + ex.toString() + " while uploading " + filesDirs[i2] + ". Attempt " + attempt);
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000 * attempt * attempt);
                    }
                    catch (InterruptedException ex2) {
                        // empty catch block
                    }
                    ++attempt;
                    continue;
                }
                break;
            }
            this.fireImageProcessingFinished(eventObject);
            if (eventObject.isAborted()) {
                throw new OperationAbortedException();
            }
            ++this.processedFiles;
        }
    }

    private Map scanRemoteFiles(File dir2, String remotePath) throws RemoteFSException, IOException {
        File[] filesDirs = dir2.listFiles(new UploadFileFilter());
        HashMap<String, File> localFiles = new HashMap<String, File>();
        for (int i2 = 0; i2 < filesDirs.length; ++i2) {
            localFiles.put(filesDirs[i2].getName(), filesDirs[i2]);
        }
        HashMap remoteFiles = new HashMap();
        RemoteFile[] res2 = this.remoteFSBean.getFiles(remotePath);
        for (int i3 = 0; i3 < res2.length; ++i3) {
            RemoteFile remoteFile = res2[i3];
            if (remoteFile.isFile() && localFiles.containsKey(remoteFile.getName())) {
                remoteFiles.put(localFiles.get(remoteFile.getName()), remoteFile);
                continue;
            }
            File localFile = (File)localFiles.get(remoteFile.getName());
            if (localFile == null || !localFile.isDirectory()) continue;
            remoteFiles.putAll(this.scanRemoteFiles(localFile, IO.combinePaths(remotePath, remoteFile.getName())));
        }
        return remoteFiles;
    }

    private int countFiles(File dir2, Map remoteFiles) {
        int counter = 0;
        File[] filesDirs = dir2.listFiles(new UploadFileFilter());
        if (filesDirs == null) {
            return 0;
        }
        for (int i2 = 0; i2 < filesDirs.length; ++i2) {
            RemoteFile rf;
            Object o2;
            if (filesDirs[i2].isDirectory()) {
                counter += this.countFiles(filesDirs[i2], remoteFiles);
                continue;
            }
            if (remoteFiles != null && (o2 = remoteFiles.get(filesDirs[i2])) != null && this.identical(filesDirs[i2], rf = (RemoteFile)o2)) continue;
            ++counter;
        }
        return counter;
    }

    private boolean identical(File local, RemoteFile remote) {
        long adjustedRemoteTime = remote.getModificationDate().getTime() - this.timeDifference;
        return local.length() == remote.size() && adjustedRemoteTime > local.lastModified();
    }

    private void myAssert(boolean test, String msg) throws ParameterException {
        if (!test) {
            throw new ParameterException(msg);
        }
    }

    public synchronized void addUploadListener(AlbumBeanListener l2) {
        Vector v2;
        Vector vector = v2 = this.uploadListeners == null ? new Vector(2) : (Vector)this.uploadListeners.clone();
        if (!v2.contains(l2)) {
            v2.addElement(l2);
            this.uploadListeners = v2;
        }
    }

    public synchronized void removeUploadListener(AlbumBeanListener l2) {
        if (this.uploadListeners != null && this.uploadListeners.contains(l2)) {
            Vector v2 = (Vector)this.uploadListeners.clone();
            v2.removeElement(l2);
            this.uploadListeners = v2;
        }
    }

    protected void fireImageProcessingStarted(AlbumBeanEvent e2) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((AlbumBeanListener)listeners.elementAt(i2)).imageProcessingStarted(e2);
            }
        }
    }

    protected void fireImageProcessingFinished(AlbumBeanEvent e2) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((AlbumBeanListener)listeners.elementAt(i2)).imageProcessingFinished(e2);
            }
        }
    }

    protected void fireErrorOccured(Exception param1, File param2) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                ((AlbumBeanListener)listeners.elementAt(i2)).errorOccured(param1, param2);
            }
        }
    }

    protected void fireBytesTransferred(long bytes) {
        if (this.uploadListeners != null) {
            Vector listeners = this.uploadListeners;
            int count = listeners.size();
            for (int i2 = 0; i2 < count; ++i2) {
                if (!(listeners.elementAt(i2) instanceof UploadListener)) continue;
                ((UploadListener)listeners.elementAt(i2)).bytesTransferred(bytes);
            }
        }
    }

    public void bytesTransferred(long bytes) {
        this.fireBytesTransferred(bytes);
    }
}

