/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.tags;

import java.util.NoSuchElementException;
import java.util.Properties;
import se.datadosen.tags.ElementException;

public class AttributeTokenizer {
    private char[] buf;
    int offset = 0;

    public AttributeTokenizer(String text) {
        this.buf = text.toCharArray();
    }

    public AttributeTokenizer(String text, int startPosition) {
        this.buf = text.toCharArray();
        this.offset = startPosition;
    }

    public static Properties getProperties(String text) throws ElementException {
        Properties p2 = new Properties();
        AttributeTokenizer tokens = new AttributeTokenizer(text);
        while (tokens.hasMoreTokens()) {
            String n2 = tokens.nextName();
            String v2 = tokens.nextValue();
            p2.setProperty(n2, v2);
        }
        return p2;
    }

    public int getPosition() {
        return this.offset;
    }

    private boolean isWhiteSpace(char c2) {
        return c2 == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\t' || c2 == '\f';
    }

    public boolean hasMoreTokens() {
        this.offset = this.skipWhiteSpace();
        return this.offset != -1 && this.buf[this.offset] != '/' && this.buf[this.offset] != '>';
    }

    public int skipWhiteSpace() {
        for (int i2 = this.offset; i2 < this.buf.length; ++i2) {
            if (this.isWhiteSpace(this.buf[i2])) continue;
            return i2;
        }
        return -1;
    }

    public int skipPastName() {
        int i2;
        for (i2 = this.offset; i2 < this.buf.length; ++i2) {
            if (!this.isWhiteSpace(this.buf[i2]) && this.buf[i2] != '=' && this.buf[i2] != '/' && this.buf[i2] != '>') continue;
            return i2;
        }
        return i2;
    }

    public int skipPastScriptlet(int i2) {
        while (i2 < this.buf.length - 1) {
            if (this.buf[i2] == '%' && this.buf[i2 + 1] == '>') {
                return i2 + 2;
            }
            ++i2;
        }
        return -1;
    }

    public int skipPastValue() {
        int i2;
        for (i2 = this.offset; i2 < this.buf.length; ++i2) {
            if (this.isWhiteSpace(this.buf[i2]) || this.buf[i2] == '>') {
                return i2;
            }
            if (this.buf[i2] != '<' || i2 >= this.buf.length - 1 || this.buf[i2 + 1] != '%') continue;
            i2 = this.skipPastScriptlet(i2 + 2) - 1;
        }
        return i2;
    }

    public int skipPastQuotation() {
        for (int i2 = this.offset; i2 < this.buf.length; ++i2) {
            if (this.buf[i2] == '\"') {
                return i2 + 1;
            }
            if (this.buf[i2] != '<' || i2 >= this.buf.length - 1 || this.buf[i2 + 1] != '%') continue;
            i2 = this.skipPastScriptlet(i2 + 2) - 1;
        }
        return -1;
    }

    public String nextName() throws NoSuchElementException {
        this.offset = this.skipWhiteSpace();
        if (this.offset == -1) {
            throw new NoSuchElementException();
        }
        int endOffset = this.skipPastName();
        String s2 = new String(this.buf, this.offset, endOffset - this.offset);
        this.offset = endOffset;
        return s2;
    }

    public String nextValue() throws NoSuchElementException, ElementException {
        int nextOffset = this.skipWhiteSpace();
        if (nextOffset == -1) {
            return null;
        }
        this.offset = nextOffset;
        if (this.buf[this.offset] == '/' || this.buf[this.offset] == '>') {
            return null;
        }
        if (this.offset == this.buf.length || this.buf[this.offset] != '=') {
            return null;
        }
        ++this.offset;
        this.offset = this.skipWhiteSpace();
        if (this.buf[this.offset] == '\"') {
            ++this.offset;
            int endOffset = this.skipPastQuotation();
            if (endOffset == -1) {
                throw new ElementException("No matching closing quote for attribute value");
            }
            String value = new String(this.buf, this.offset, endOffset - this.offset - 1);
            this.offset = endOffset;
            return value;
        }
        int endOffset = this.skipPastValue();
        String value = new String(this.buf, this.offset, endOffset - this.offset);
        this.offset = endOffset;
        return value;
    }
}

