/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.tags;

import se.datadosen.tags.AttributeTokenizer;
import se.datadosen.tags.Element;
import se.datadosen.tags.ElementException;

public class Elements {
    public static String stripComments(String doc) {
        int cEnd;
        int cStart = doc.indexOf("<!--");
        if (cStart == -1) {
            return doc;
        }
        StringBuffer buf = new StringBuffer();
        do {
            buf.append(doc.substring(0, cStart));
            doc = doc.substring(cStart);
            cEnd = doc.indexOf("-->");
            if (cEnd != -1) continue;
            return buf.toString();
        } while ((cStart = (doc = doc.substring(cEnd + 3)).indexOf("<!--")) != -1);
        buf.append(doc);
        return buf.toString();
    }

    public static String stripJSPComments(String doc) {
        int cEnd;
        int cStart = doc.indexOf("<%--");
        if (cStart == -1) {
            return doc;
        }
        StringBuffer buf = new StringBuffer();
        do {
            buf.append(doc.substring(0, cStart));
            doc = doc.substring(cStart);
            cEnd = doc.indexOf("--%>");
            if (cEnd != -1) continue;
            return buf.toString();
        } while ((cStart = (doc = doc.substring(cEnd + 4)).indexOf("<%--")) != -1);
        buf.append(doc);
        return buf.toString();
    }

    public static Element getNextElement(String[] names, String doc, boolean startsWith) throws ElementException {
        return Elements.getNextElement(names, doc, 0, startsWith);
    }

    static final int indexOfIntroducer(String s2, int start) {
        int boff = s2.indexOf(60, start);
        int doff = s2.indexOf(36, start);
        if (boff == -1 && doff == -1) {
            return -1;
        }
        if (boff == -1) {
            boff = Integer.MAX_VALUE;
        }
        if (doff == -1) {
            doff = Integer.MAX_VALUE;
        }
        return boff < doff ? boff : doff;
    }

    public static Element getNextElement(String[] names, String doc, int start, boolean startsWith) throws ElementException {
        int offset = start;
        while ((offset = Elements.indexOfIntroducer(doc, offset)) != -1) {
            char c2;
            int i2;
            if (doc.charAt(offset) == '$') {
                if (offset + 1 < doc.length() && doc.charAt(offset + 1) == '{') {
                    return Elements.getExpressionLanguage(doc);
                }
                ++offset;
                continue;
            }
            for (i2 = 0; i2 < names.length && (!doc.startsWith(names[i2], offset + 1) || !startsWith && (c2 = doc.charAt(offset + 1 + names[i2].length())) != '=' && Character.isJavaIdentifierPart(c2)); ++i2) {
            }
            if (i2 == names.length) {
                ++offset;
                continue;
            }
            if (names[i2].equals("%")) {
                return Elements.getScriptlet(doc);
            }
            Element e2 = new Element();
            e2.preElement = doc.substring(0, offset);
            AttributeTokenizer at = new AttributeTokenizer(doc, offset + 1);
            String name = e2.name = at.nextName();
            while (at.hasMoreTokens()) {
                e2.attributes.put(at.nextName(), at.nextValue());
            }
            offset = at.getPosition();
            char c3 = doc.charAt(offset);
            if (c3 == '/') {
                e2.content = "";
                e2.postElement = doc.substring(offset + 2);
                e2.postIndex = offset + 2;
                return e2;
            }
            if (c3 != '>') {
                throw new ElementException("Begin tag not closed");
            }
            int contentStart = offset + 1;
            while ((offset = doc.indexOf(60, offset)) != -1) {
                if (doc.startsWith(name, offset + 1)) {
                    Element subElem = Elements.getNextElement(new String[]{name}, doc, offset, startsWith);
                    offset = subElem.getPostIndex() - 1;
                } else if (doc.startsWith("/" + name, offset + 1)) {
                    e2.content = doc.substring(contentStart, offset);
                    if ((offset = doc.indexOf(62, offset)) == -1) {
                        throw new ElementException("Element " + e2.name + " has malformad ending tag");
                    }
                    e2.postElement = doc.substring(offset + 1);
                    e2.postIndex = offset + 1;
                    return e2;
                }
                ++offset;
            }
            throw new ElementException("Element " + e2.name + " has no matching ending tag");
        }
        return null;
    }

    public static Element getElementByName(String name, String doc, boolean startsWith) throws ElementException {
        return Elements.getNextElement(new String[]{name}, doc, startsWith);
    }

    public static Element getScriptlet(String doc) throws ElementException {
        int offset = 0;
        while ((offset = doc.indexOf(60, offset)) != -1) {
            if (doc.charAt(offset + 1) != '%') {
                ++offset;
                continue;
            }
            Element e2 = new Element();
            e2.name = "%";
            e2.preElement = doc.substring(0, offset);
            int contentStart = offset + 2;
            switch (doc.charAt(contentStart)) {
                case '=': {
                    e2.evalScriptlet = true;
                    ++contentStart;
                    break;
                }
                case '!': {
                    e2.definitionScriptlet = true;
                    ++contentStart;
                }
            }
            offset = contentStart;
            while ((offset = doc.indexOf(37, offset)) != -1) {
                if (doc.charAt(offset + 1) != '>') {
                    ++offset;
                    continue;
                }
                e2.content = doc.substring(contentStart, offset);
                e2.postElement = doc.substring(offset + 2);
                return e2;
            }
            throw new ElementException("Scriptlet has no ending");
        }
        return null;
    }

    public static Element getExpressionLanguage(String doc) throws ElementException {
        int offset = 0;
        while ((offset = doc.indexOf(36, offset)) != -1) {
            int contentStart;
            if (doc.charAt(offset + 1) != '{') {
                ++offset;
                continue;
            }
            Element e2 = new Element();
            e2.name = "$";
            e2.preElement = doc.substring(0, offset);
            offset = contentStart = offset + 2;
            if ((offset = doc.indexOf(125, offset)) == -1) {
                throw new ElementException("Expression has no ending brace");
            }
            e2.content = doc.substring(contentStart, offset);
            e2.postElement = doc.substring(offset + 1);
            return e2;
        }
        return null;
    }
}

