/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import se.datadosen.util.Replacer;
import se.datadosen.util.StringCodec;

public class IO {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String readTextFile(File file, String encoding) throws IOException {
        byte[] buf = IO.readBytes(file);
        StringCodec codec = new StringCodec();
        return codec.decode(buf, encoding);
    }

    public static String readTextFile(File file) throws IOException {
        return IO.readTextFile(file, System.getProperty("file.encoding"));
    }

    public static String readTextFile(String fileName) throws IOException {
        return IO.readTextFile(new File(fileName));
    }

    public static String readTextUrl(URL textUrl) throws IOException {
        int offset;
        URLConnection conn = textUrl.openConnection();
        int length = conn.getContentLength();
        if (length == -1) {
            throw new IOException("Couldn't connect to " + textUrl);
        }
        byte[] bytes = new byte[length];
        InputStream is = conn.getInputStream();
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read from " + textUrl);
        }
        is.close();
        StringCodec codec = new StringCodec();
        return codec.decode(bytes, System.getProperty("file.encoding"));
    }

    public static byte[] readBytes(File f2) throws IOException {
        byte[] buf = new byte[(int)f2.length()];
        FileInputStream in = new FileInputStream(f2);
        in.read(buf);
        in.close();
        return buf;
    }

    public static void writeBytes(byte[] buf, File f2) throws IOException {
        FileOutputStream out = new FileOutputStream(f2);
        out.write(buf);
        out.close();
    }

    public static void writeTextFile(String content, File file) throws IOException {
        IO.writeTextFile(content, file, System.getProperty("file.encoding"));
    }

    public static void writeTextFile(String content, File file, String encoding) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        writer.write(content);
        writer.close();
    }

    public static boolean writeChangedTextFile(String content, File file, String encoding) throws IOException {
        if (!file.exists()) {
            IO.writeTextFile(content, file, encoding);
            return true;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, encoding);
        writer.write(content);
        writer.close();
        byte[] outBytes = out.toByteArray();
        byte[] inBytes = IO.readBytes(file);
        if (!Arrays.equals(outBytes, inBytes)) {
            IO.writeBytes(outBytes, file);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertyFile(File file) throws IOException {
        FileInputStream fis = null;
        try {
            Properties props = new Properties();
            fis = new FileInputStream(file);
            props.load(fis);
            Properties properties = props;
            return properties;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readMapFile(File file) throws IOException {
        Pattern backslashPattern = Pattern.compile("\\\\\\\\", 2);
        String s2 = IO.readTextFile(file);
        BufferedReader in = new BufferedReader(new StringReader(s2));
        try {
            String line;
            HashMap<String, String> theMap = new HashMap<String, String>();
            while ((line = in.readLine()) != null) {
                int equalsIndex;
                if ((line = line.trim()).startsWith("#") || (equalsIndex = line.indexOf(61)) == -1) continue;
                String key = line.substring(0, equalsIndex).trim();
                String value = line.substring(equalsIndex + 1).trim();
                while (IO.continueLine(line)) {
                    value = value.substring(0, value.length() - 1);
                    line = in.readLine();
                    if (line == null) break;
                    value = value + "\n" + line;
                }
                value = backslashPattern.matcher(value).replaceAll("\\\\");
                theMap.put(key, value);
            }
            HashMap<String, String> hashMap = theMap;
            return hashMap;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void writeMapFile(Map map, File f2) throws IOException {
        Replacer backslashEncoder = new Replacer();
        backslashEncoder.add("\\", "\\\\");
        backslashEncoder.add("\n", "\\" + System.getProperty("line.separator"));
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e2 = it.next();
            out.println(e2.getKey().toString() + "=" + backslashEncoder.replace(e2.getValue().toString()));
        }
        out.close();
        String s2 = writer.getBuffer().toString();
        StringCodec codec = new StringCodec();
        byte[] bytes = codec.encode(s2);
        if (!s2.equals(codec.decode(bytes))) {
            bytes = codec.encode(s2, "UTF-8");
        }
        IO.writeBytes(bytes, f2);
    }

    private static boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    public static void copyFile(File src, File dest) throws IOException {
        IO.copyFile(src, dest, true);
    }

    public static void copyFile(String name, File dest) throws IOException {
        IO.copyFile(name, dest, true);
    }

    public static void copyFile(String name, File dest, boolean forceCopy) throws IOException {
        IO.copyFile(new File(name), dest, forceCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest, boolean forceCopy) throws IOException {
        if (src.isDirectory()) {
            if (!dest.isDirectory()) {
                throw new IOException("copyFile: Cannot copy directory onto single file");
            }
            File[] files = src.listFiles();
            for (int i2 = 0; i2 < files.length; ++i2) {
                IO.copyFile(files[i2], dest, forceCopy);
            }
        } else {
            if (dest.isDirectory()) {
                dest = new File(dest, src.getName());
            }
            if (src.getName().equalsIgnoreCase("Thumbs.db")) {
                return;
            }
            if (!forceCopy && dest.exists()) {
                return;
            }
            if (dest.exists() && !dest.canWrite()) {
                return;
            }
            long lastModified = src.lastModified();
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
            try {
                int bytesRead;
                byte[] buffer = new byte[65536];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            finally {
                in.close();
                out.close();
                dest.setLastModified(lastModified);
            }
        }
    }

    public static String readAll(Reader in) throws IOException {
        int bytesRead;
        char[] buffer = new char[65536];
        StringBuffer sb = new StringBuffer();
        while ((bytesRead = in.read(buffer)) != -1) {
            sb.append(buffer, 0, bytesRead);
        }
        in.close();
        return sb.toString();
    }

    public boolean isSubdirectoryOf(File subdir, File dir2) {
        File parent = subdir.getParentFile();
        if (parent == null) {
            return false;
        }
        if (parent.equals(dir2)) {
            return true;
        }
        return this.isSubdirectoryOf(parent, dir2);
    }

    public static void copyDirectoryContent(String srcPath, File dest, boolean forceCopy) throws IOException {
        IO.copyDirectoryContent(new File(srcPath), dest, forceCopy);
    }

    public static void copyDirectoryContent(File srcDir, File dest, boolean forceCopy) throws IOException {
        dest.mkdir();
        if (!srcDir.isDirectory()) {
            throw new IOException("Missing directory " + srcDir.getAbsolutePath());
        }
        File[] files = srcDir.listFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (files[i2].isDirectory()) {
                IO.copyDirectoryContent(files[i2], new File(dest, files[i2].getName()), forceCopy);
                continue;
            }
            if (!files[i2].isFile()) continue;
            IO.copyFile(files[i2].getAbsolutePath(), dest, forceCopy);
        }
    }

    public static String baseName(String fullName) {
        int dotIndex = fullName.lastIndexOf(46);
        return dotIndex != -1 ? fullName.substring(0, dotIndex) : fullName;
    }

    public static String baseName(File file) {
        return IO.baseName(file.getName());
    }

    public static String extensionOf(String name) {
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            dotIndex = name.length() - 1;
        }
        return name.substring(dotIndex + 1);
    }

    public static String extensionOf(File file) {
        return IO.extensionOf(file.getName());
    }

    public static String relativePath(File file, File rel) {
        return IO.relativePath(file.getAbsolutePath(), rel.getAbsolutePath(), File.separatorChar);
    }

    public static String relativePath(String fileString, String relString) {
        return IO.relativePath(IO.ensureSlashPrefix(fileString), IO.ensureSlashPrefix(relString), '/');
    }

    private static String ensureSlashPrefix(String s2) {
        return s2.startsWith("/") ? s2 : "/" + s2;
    }

    public static String relativePath(String fileString, String relString, char separator) {
        StringTokenizer tokens;
        int i2;
        char[] filePath = fileString.toCharArray();
        char[] relPath = relString.toCharArray();
        StringBuffer result = new StringBuffer();
        for (i2 = 0; i2 < filePath.length && i2 < relPath.length && filePath[i2] == relPath[i2]; ++i2) {
        }
        if (i2 < relPath.length && i2 < filePath.length || relPath.length < filePath.length && filePath[i2] != separator) {
            while (i2 > 0 && relPath[i2 - 1] != separator) {
                --i2;
            }
        }
        if (i2 != 0) {
            tokens = new StringTokenizer(relString.substring(i2), "" + separator);
            while (tokens.hasMoreTokens()) {
                tokens.nextToken();
                result.append("../");
            }
        }
        if (i2 > fileString.length()) {
            i2 = fileString.length();
        }
        if ((tokens = new StringTokenizer(fileString.substring(i2), "" + separator)).hasMoreTokens()) {
            result.append(tokens.nextToken());
        } else if (result.length() > 0 && result.charAt(result.length() - 1) == '/') {
            result.deleteCharAt(result.length() - 1);
        }
        while (tokens.hasMoreTokens()) {
            result.append("/" + tokens.nextToken());
        }
        String res = result.toString();
        return res.equals("") ? "." : res;
    }

    public static String urlEncode(String s2) {
        StringBuffer sb = new StringBuffer();
        try {
            byte[] bytes = StringCodec.isEncodable(s2, System.getProperty("file.encoding")) ? s2.getBytes(System.getProperty("file.encoding")) : s2.getBytes("UTF-8");
            s2 = new String(bytes, "8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        char[] chars = s2.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            if (chars[i2] > '\u007f' || chars[i2] == ' ' || chars[i2] == '#' || chars[i2] == '%' || chars[i2] == '\'') {
                sb.append('%');
                sb.append(hexDigits[(chars[i2] & 0xF0) >> 4]);
                sb.append(hexDigits[chars[i2] & 0xF]);
                continue;
            }
            sb.append(chars[i2]);
        }
        return sb.toString();
    }

    public static String combinePaths(String part1, String part2) {
        return IO.combinePaths(part1, part2, '/');
    }

    public static String combinePaths(String part1, String part2, char separator) {
        int start;
        int end;
        if (part1.length() == 0) {
            return part2;
        }
        if (part2.length() == 0) {
            return part1;
        }
        for (end = part1.length(); end > 0 && part1.charAt(end - 1) == separator; --end) {
        }
        if (part1.endsWith("" + separator + separator)) {
            ++end;
        }
        for (start = 0; start < part2.length() && part2.charAt(start) == separator; ++start) {
        }
        return part1.substring(0, end) + separator + part2.substring(start, part2.length());
    }

    public static int sizeof(Object o2) {
        try {
            ByteArrayOutputStream ba2 = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(ba2);
            oos.writeObject(o2);
            return ba2.toByteArray().length;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString());
        }
    }

    public static long deepLastModified(File dir2) throws IOException {
        long lastModified = dir2.lastModified();
        File[] files = dir2.listFiles();
        if (files != null) {
            for (int i2 = 0; i2 < files.length; ++i2) {
                long lm = files[i2].lastModified();
                if (files[i2].isDirectory()) {
                    lm = IO.deepLastModified(files[i2]);
                }
                if (lm <= lastModified) continue;
                lastModified = lm;
            }
        }
        return lastModified;
    }

    public static void close(FileOutputStream fos) {
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

