/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import se.datadosen.util.APP1Segment;
import se.datadosen.util.JpegFile;
import se.datadosen.util.Segment;

public class RotationSupport {
    public static final int LEFT_ROTATED = 6;
    public static final int NOT_ROTATED = 1;
    public static final int RIGHT_ROTATED = 8;
    static /* synthetic */ Class class$com$drew$metadata$exif$ExifDirectory;

    public static BufferedImage rotateLeft(BufferedImage bi2) {
        AffineTransform rot270Transform = AffineTransform.getRotateInstance(4.71238898038469);
        rot270Transform.translate(-bi2.getWidth(), 0.0);
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        AffineTransformOp op = new AffineTransformOp(rot270Transform, hints);
        return op.filter(bi2, null);
    }

    public static BufferedImage rotateRight(BufferedImage bi2) {
        AffineTransform rot90Transform = AffineTransform.getRotateInstance(1.5707963267948966);
        rot90Transform.translate(0.0, -bi2.getHeight());
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        AffineTransformOp op = new AffineTransformOp(rot90Transform, hints);
        return op.filter(bi2, null);
    }

    public static ImageIcon adjustOrientation(ImageIcon ii, Metadata meta) {
        if (meta == null) {
            return ii;
        }
        BufferedImage bi2 = RotationSupport.createBufferedImage(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
        bi2 = RotationSupport.adjustOrientation(bi2, meta);
        return new ImageIcon(bi2);
    }

    public static ImageIcon adjustOrientation(ImageIcon ii, File file) {
        try {
            BufferedImage bi2 = RotationSupport.createBufferedImage(ii.getImage(), ii.getIconWidth(), ii.getIconHeight());
            bi2 = RotationSupport.adjustOrientation(bi2, RotationSupport.getOrientation(file));
            return new ImageIcon(bi2);
        }
        catch (IOException ex) {
            return ii;
        }
    }

    private static BufferedImage createBufferedImage(Image img, int iw, int ih) {
        BufferedImage bi2 = new BufferedImage(iw, ih, 1);
        Graphics2D g2 = bi2.createGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        return bi2;
    }

    public static BufferedImage adjustOrientation(BufferedImage bi2, Metadata meta) {
        if (meta == null) {
            return bi2;
        }
        try {
            if (meta.containsDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = RotationSupport.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory)) {
                Directory exif = meta.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = RotationSupport.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
                int existingOrientation = exif.getInt(274);
                return RotationSupport.adjustOrientation(bi2, existingOrientation);
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return bi2;
    }

    public static BufferedImage adjustOrientation(BufferedImage bi2, File file) {
        try {
            return RotationSupport.adjustOrientation(bi2, RotationSupport.getOrientation(file));
        }
        catch (IOException ex) {
            return bi2;
        }
    }

    public static int getOrientation(Metadata meta) {
        try {
            if (meta.containsDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = RotationSupport.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory)) {
                Directory exif = meta.getDirectory(class$com$drew$metadata$exif$ExifDirectory == null ? (class$com$drew$metadata$exif$ExifDirectory = RotationSupport.class$("com.drew.metadata.exif.ExifDirectory")) : class$com$drew$metadata$exif$ExifDirectory);
                return exif.getInt(274);
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return 1;
    }

    public static String getOrientationAsString(Metadata meta) {
        return RotationSupport.asString(RotationSupport.getOrientation(meta));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOrientation(File file) throws IOException {
        JpegFile f2 = null;
        try {
            Segment s2;
            f2 = new JpegFile(file);
            for (s2 = f2.getFirstSegment(); s2 != null && s2.getId() != -31; s2 = s2.getNextSegment()) {
            }
            if (s2 != null) {
                APP1Segment app1 = new APP1Segment(s2);
                boolean ifdNum = false;
                do {
                    for (int i2 = 0; i2 < app1.getEntryCount(); ++i2) {
                        APP1Segment.Entry ifd = app1.getEntry(i2);
                        if (ifd.getTagNr() != 274) continue;
                        int n2 = ifd.getValue();
                        return n2;
                    }
                } while (app1.nextIFD());
            }
            int n3 = 1;
            return n3;
        }
        finally {
            if (f2 != null) {
                f2.close();
            }
        }
    }

    public static String getOrientationAsString(File file) throws IOException {
        return RotationSupport.asString(RotationSupport.getOrientation(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setOrientation(int orientation, File file) throws IOException {
        JpegFile f2 = null;
        try {
            Segment s2;
            f2 = new JpegFile(file, "rw");
            for (s2 = f2.getFirstSegment(); s2 != null && s2.getId() != -31; s2 = s2.getNextSegment()) {
            }
            if (s2 != null) {
                APP1Segment app1 = new APP1Segment(s2);
                boolean ifdNum = false;
                block4: do {
                    for (int i2 = 0; i2 < app1.getEntryCount(); ++i2) {
                        APP1Segment.Entry ifd = app1.getEntry(i2);
                        if (ifd.getTagNr() != 274) continue;
                        ifd.setValue(orientation);
                        continue block4;
                    }
                } while (app1.nextIFD());
            }
            boolean bl2 = false;
            return bl2;
        }
        finally {
            if (f2 != null) {
                f2.close();
            }
        }
    }

    private static int asCode(String orientation) {
        if ("left".equals(orientation)) {
            return 6;
        }
        if ("right".equals(orientation)) {
            return 8;
        }
        return 1;
    }

    private static String asString(int orientation) {
        switch (orientation) {
            case 6: {
                return "left";
            }
            case 8: {
                return "right";
            }
        }
        return "normal";
    }

    public static BufferedImage adjustOrientation(BufferedImage bi2, String existingOrientation) {
        return RotationSupport.adjustOrientation(bi2, RotationSupport.asCode(existingOrientation));
    }

    public static BufferedImage adjustOrientation(BufferedImage bi2, int existingOrientation) {
        if (existingOrientation == 6) {
            return RotationSupport.rotateRight(bi2);
        }
        if (existingOrientation == 8) {
            return RotationSupport.rotateLeft(bi2);
        }
        return bi2;
    }

    public static void main(String[] args) throws Exception {
        File file = new File("C:/Documents and Settings/David Ekholm/Skrivbord/Rotationstest/DSC08646.JPG");
        RotationSupport.setOrientation(4, file);
        Metadata imageInfo = JpegMetadataReader.readMetadata(file);
        System.out.println(RotationSupport.getOrientation(imageInfo));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

