/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util.httpClient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Hashtable;
import java.util.StringTokenizer;
import se.datadosen.util.httpClient.HttpResponse;
import se.datadosen.util.httpClient.Log;
import se.datadosen.util.httpClient.ModuleException;
import se.datadosen.util.httpClient.ProtocolNotSuppException;

public class Http {
    private static final int HTTP_CONTINUE = 100;

    public static Socket makeSocket(String proto, String host, int port) throws ProtocolNotSuppException, IOException {
        if (proto.equalsIgnoreCase("http")) {
            return new Socket(host, port);
        }
        throw new ProtocolNotSuppException(proto);
    }

    public static HttpResponse readResponse(InputStream input) throws IOException, ModuleException {
        HttpResponse result;
        while ((result = Http.readHeaders(input)).getStatusCode() == 100) {
        }
        return result;
    }

    private static String readLine(InputStream input) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i2 = input.read();
        if (i2 == 13) {
            i2 = input.read();
        }
        if (i2 == -1) {
            return null;
        }
        if (i2 == 10) {
            return "";
        }
        do {
            out.write(i2);
        } while ((i2 = input.read()) > -1 && i2 != 10);
        return out.toString();
    }

    private static HttpResponse readHeaders(InputStream input) throws IOException, ModuleException {
        HttpResponse result = null;
        Hashtable<String, String> headers = new Hashtable<String, String>();
        int responseCode = -1;
        String received = "";
        String reason = null;
        String line = null;
        while ((line = Http.readLine(input)) != null) {
            Log.DEBUG("received => " + line + "\n");
            received = received + line + "\n";
            if (responseCode == -1) {
                StringTokenizer st = new StringTokenizer(line);
                st.nextToken();
                try {
                    responseCode = Integer.parseInt(st.nextToken());
                    reason = st.nextToken("\n");
                    continue;
                }
                catch (NumberFormatException e2) {
                    throw new ModuleException("status line => " + line);
                }
            }
            if (line.equals("")) {
                result = new HttpResponse(responseCode, reason, headers, input);
                break;
            }
            int colonIndex = line.indexOf(58);
            headers.put(line.substring(0, colonIndex).toUpperCase(), line.substring(colonIndex + 1, line.length()).trim());
        }
        if (result == null) {
            System.err.println("INSUFFICIENT DATA RECEIVED");
            System.err.print("|" + received + "|");
            throw new ModuleException("insufficient data received");
        }
        Log.DEBUG("read entire answer\n");
        return result;
    }
}

