/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import java.util.StringTokenizer;

public class SoftwareVersion
implements Cloneable {
    private String major = "";
    private String minor = "";
    private String maintenance = "";
    private String update = "";
    private String formatted = "";
    public static int COMPARISON_DEPTH_MAJOR = 0;
    public static int COMPARISON_DEPTH_MINOR = 1;
    public static int COMPARISON_DEPTH_MAINTENANCE = 2;
    public static int COMPARISON_DEPTH_UPDATE = 3;

    public SoftwareVersion(String string) {
        this.parse(string);
    }

    public SoftwareVersion() {
    }

    public Object clone() {
        SoftwareVersion softwareVersion = new SoftwareVersion();
        softwareVersion.setMajor(this.major);
        softwareVersion.setMinor(this.minor);
        softwareVersion.setMaintenance(this.maintenance);
        softwareVersion.setUpdate(this.update);
        softwareVersion.setFormatted(this.formatted);
        return softwareVersion;
    }

    public int hashCode() {
        String string = this.major + this.minor + this.maintenance + this.update;
        return string.hashCode();
    }

    public void setMajor(String string) {
        this.setMajor(string, false);
    }

    public void setMajor(String string, boolean bl) {
        this.major = this.component(string, bl);
    }

    private String component(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        if (bl) {
            try {
                return Integer.toString(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string.trim();
    }

    public String getMajor() {
        return this.major;
    }

    public void setMinor(String string) {
        this.setMinor(string, false);
    }

    public void setMinor(String string, boolean bl) {
        this.minor = this.component(string, bl);
    }

    public String getMinor() {
        return this.minor;
    }

    public void setMaintenance(String string) {
        this.setMaintenance(string, false);
    }

    public void setMaintenance(String string, boolean bl) {
        this.maintenance = this.component(string, bl);
    }

    public String getMaintenance() {
        return this.maintenance;
    }

    public void setUpdate(String string) {
        this.setUpdate(string, false);
    }

    public void setUpdate(String string, boolean bl) {
        this.update = this.component(string, bl);
    }

    public String getUpdate() {
        return this.update;
    }

    public void setFormatted(String string) {
        if (string == null) {
            this.formatted = "";
        }
        this.formatted = string;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SoftwareVersion softwareVersion = (SoftwareVersion)object;
        return this.major.equals(softwareVersion.major) && this.minor.equals(softwareVersion.minor) && this.maintenance.equals(softwareVersion.maintenance) && this.update.equals(softwareVersion.update);
    }

    public int compareTo(SoftwareVersion softwareVersion) {
        return this.compareTo(softwareVersion, COMPARISON_DEPTH_UPDATE);
    }

    public int compareTo(SoftwareVersion softwareVersion, int n) {
        if (softwareVersion == null) {
            return 1;
        }
        int n2 = this.compareLevel(this.major, softwareVersion.major);
        if (n2 == 0 && n > COMPARISON_DEPTH_MAJOR && (n2 = this.compareLevel(this.minor, softwareVersion.minor)) == 0 && n > COMPARISON_DEPTH_MINOR && (n2 = this.compareLevel(this.maintenance, softwareVersion.maintenance)) == 0 && n > COMPARISON_DEPTH_MAINTENANCE) {
            n2 = this.compareLevel(this.update, softwareVersion.update);
        }
        return n2;
    }

    private int compareLevel(String string, String string2) {
        try {
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            return n - n2;
        }
        catch (NumberFormatException numberFormatException) {
            return string.compareTo(string2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.major);
        if (this.minor.length() > 0) {
            stringBuffer.append(".").append(this.minor);
            if (this.maintenance.length() > 0) {
                stringBuffer.append(".").append(this.maintenance);
                if (this.update.length() > 0) {
                    stringBuffer.append(".").append(this.update);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void parse(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.hasMoreTokens()) {
                this.setMajor(stringTokenizer.nextToken(), false);
            } else {
                this.major = "";
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.setMinor(stringTokenizer.nextToken(), false);
            } else {
                this.minor = "";
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.setMaintenance(stringTokenizer.nextToken(), false);
            } else {
                this.maintenance = "";
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.setUpdate(stringTokenizer.nextToken(" ").substring(1), false);
            } else {
                this.update = "";
            }
        }
    }
}

