/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.java.lang;

import java.text.Collator;
import java.util.Enumeration;
import java.util.Vector;

public class StringUtil {
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static char[] hexvalues = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean contains(String string, char c) {
        return string.indexOf(c) != -1;
    }

    public static String[] orderStrings(Enumeration enumeration) {
        return StringUtil.orderStrings(enumeration, false);
    }

    public static String[] orderStrings(String[] stringArray) {
        return StringUtil.orderStrings(stringArray, false);
    }

    public static String[] orderStrings(Enumeration enumeration, boolean bl) {
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return StringUtil.orderStrings((String[])objectArray, bl);
    }

    public static String[] orderStrings(String[] stringArray, boolean bl) {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            objectArray = stringArray[n];
            int n2 = vector.size();
            while (n2 > 0) {
                String string;
                Object object;
                String string2 = (String)vector.elementAt(n2 - 1);
                if (bl) {
                    object = objectArray;
                    string = string2;
                } else {
                    object = objectArray.toLowerCase();
                    string = string2.toLowerCase();
                }
                int n3 = bl ? ((String)object).compareTo(string) : Collator.getInstance().compare((String)object, string);
                if (n3 >= 0) {
                    vector.insertElementAt(objectArray, n2);
                    n2 = -1;
                }
                --n2;
            }
            if (n2 == 0) {
                vector.insertElementAt(objectArray, 0);
            }
            ++n;
        }
        objectArray = new String[stringArray.length];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private static String getEscUnicodeRepresentation(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        StringUtil.appendEscUnicodeRepresentation(c, stringBuffer);
        return stringBuffer.toString();
    }

    private static void appendEscUnicodeRepresentation(char c, StringBuffer stringBuffer) {
        if (c == '\\') {
            stringBuffer.append("\\\\");
        } else {
            stringBuffer.append("\\u");
            stringBuffer.append(hexDigit[c >> 12 & 0xF]);
            stringBuffer.append(hexDigit[c >> 8 & 0xF]);
            stringBuffer.append(hexDigit[c >> 4 & 0xF]);
            stringBuffer.append(hexDigit[c >> 0 & 0xF]);
        }
    }

    public static boolean containsUnicode(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c > '~' || c < ' ' || c == '\\') {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String convertToEscapedUnicode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c > '~' || c < ' ' || c == '\\') {
                StringUtil.appendEscUnicodeRepresentation(c, stringBuffer);
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String convertFromEscapedUnicode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = -1;
        int n3 = 0;
        char c = '\u0000';
        int n4 = 0;
        while (n4 < n) {
            c = string.charAt(n4);
            if (c == '\\') {
                if (++n4 >= n) continue;
                c = string.charAt(n4);
                if (c == 'u') {
                    ++n4;
                    n2 = 0;
                    int n5 = 0;
                    while (n5 < 4 && n4 < n) {
                        c = string.charAt(n4);
                        n3 = StringUtil.getOffset(c);
                        if (n3 == -1) {
                            stringBuffer.append("\\u");
                            while (n5 > 0) {
                                stringBuffer.append(string.charAt(n4 - n5));
                                --n5;
                            }
                            n2 = -1;
                            break;
                        }
                        n2 = (n2 << 4) + c - n3;
                        ++n4;
                        ++n5;
                    }
                    if (n2 == -1) continue;
                    stringBuffer.append((char)n2);
                    continue;
                }
                stringBuffer.append(c);
                ++n4;
                continue;
            }
            stringBuffer.append(c);
            ++n4;
        }
        return stringBuffer.toString();
    }

    private static int getOffset(int n) {
        if (n >= 48 && n <= 57) {
            return 48;
        }
        if (n >= 65 && n <= 70) {
            return 55;
        }
        if (n >= 97 && n <= 102) {
            return 87;
        }
        return -1;
    }

    public static String cutOutExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String xor(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("The 'key' argument of the StringUtil.xorString method cannot be null, blank or empty.");
        }
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("The 'value' argument of the StringUtil.xorString method cannot be null or empty.");
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length());
        int n = 0;
        while (n < string2.length()) {
            char c = string.charAt(n % string.length());
            char c2 = string2.charAt(n);
            char c3 = (char)(c ^ c2);
            stringBuffer.append(c3);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(StringUtil.byteToHex(byArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static char[] byteToHex(byte by) {
        char[] cArray = new char[]{hexvalues[(by & 0xF0) >> 4], hexvalues[by & 0xF]};
        return cArray;
    }
}

