#include <stdio.h>
#include "ring.decl.h"

/*readonly*/ CProxy_Main mainProxy;
/*readonly*/ int numChares;

/*mainchare*/
class Main : public Chare
{
public:
  Main(CkArgMsg* m) {
    // Process command-line arguments
    numChares = 5;
    if(m->argc > 1)
      numChares = atoi(m->argv[1]);
    delete m;

    // Start the computation
    CkPrintf("Running Ring on %d processors for %d elements\n",
	     CkNumPes(), numChares);
    mainProxy = thishandle;

    CProxy_Ring arr = CProxy_Ring::ckNew(numChares);
    int *tokens=new int[10];
    tokens[0]=11;
    arr[0].passToken(tokens,10);
  };

  void done(void) {
    CkPrintf("All done\n");
    CkExit();
  };
};

/*array [1D]*/
class Ring : public CBase_Ring 
{
public:
  Ring() {
    CkPrintf("Ring %d created\n",thisIndex);
  }

  Ring(CkMigrateMessage *m) { }
  
  void passToken(int *token, int count) {
    CkPrintf("Token No [%d] received by chare element %d tokens %d\n", token[0], thisIndex,count);
    token[0]+=1;
    if (thisIndex < numChares-1)
      // Pass the token
      thisProxy[thisIndex+1].passToken(token,count);
    else 
      // We've been around once-- we're done.
      mainProxy.done();
  }
};

#include "ring.def.h"
