/* DEFS: group CollectiveBackbone: IrrGroup{
CollectiveBackbone(void);
  initcall void init_nb_rounds(void);
void signal(unsigned int round, unsigned short id);
void barrier_crossed(void);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_CollectiveBackbone::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: CollectiveBackbone(void);
 */


/* DEFS: void signal(unsigned int round, unsigned short id);
 */
void CProxyElement_CollectiveBackbone::signal(unsigned int round, unsigned short id, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int round, unsigned short id
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|round;
    implP|id;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|round;
    implP|id;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CollectiveBackbone::__idx_signal_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CollectiveBackbone::__idx_signal_marshall2, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CollectiveBackbone::__idx_signal_marshall2, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void barrier_crossed(void);
 */
void CProxyElement_CollectiveBackbone::barrier_crossed(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CollectiveBackbone::__idx_barrier_crossed_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CollectiveBackbone::__idx_barrier_crossed_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CollectiveBackbone::__idx_barrier_crossed_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: CollectiveBackbone(void);
 */
CkGroupID CProxy_CollectiveBackbone::ckNew(void)
{
  void *impl_msg = CkAllocSysMsg();
  return CkCreateGroup(CkIndex_CollectiveBackbone::__idx, CkIndex_CollectiveBackbone::__idx_CollectiveBackbone_void, impl_msg);
}
 int CkIndex_CollectiveBackbone::__idx_CollectiveBackbone_void=0;
void CkIndex_CollectiveBackbone::_call_CollectiveBackbone_void(void* impl_msg,CollectiveBackbone * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  new (impl_obj) CollectiveBackbone();
}


/* DEFS: void signal(unsigned int round, unsigned short id);
 */
void CProxy_CollectiveBackbone::signal(unsigned int round, unsigned short id, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int round, unsigned short id
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|round;
    implP|id;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|round;
    implP|id;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CollectiveBackbone::__idx_signal_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CollectiveBackbone::__idx_signal_marshall2, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CollectiveBackbone::__idx_signal_marshall2, impl_msg, ckGetGroupID(),0);
}
void CProxy_CollectiveBackbone::signal(unsigned int round, unsigned short id, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: unsigned int round, unsigned short id
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|round;
    implP|id;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|round;
    implP|id;
  }
  CkSendMsgBranchMulti(CkIndex_CollectiveBackbone::__idx_signal_marshall2, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CollectiveBackbone::signal(unsigned int round, unsigned short id, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: unsigned int round, unsigned short id
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|round;
    implP|id;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|round;
    implP|id;
  }
  CkSendMsgBranchGroup(CkIndex_CollectiveBackbone::__idx_signal_marshall2, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CollectiveBackbone::__idx_signal_marshall2=0;
void CkIndex_CollectiveBackbone::_call_signal_marshall2(void* impl_msg,CollectiveBackbone * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: unsigned int round, unsigned short id*/
  PUP::fromMem implP(impl_buf);
  unsigned int round; implP|round;
  unsigned short id; implP|id;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->signal(round, id);
}
int CkIndex_CollectiveBackbone::_callmarshall_signal_marshall2(char* impl_buf,CollectiveBackbone * impl_obj) {
  /*Unmarshall pup'd fields: unsigned int round, unsigned short id*/
  PUP::fromMem implP(impl_buf);
  unsigned int round; implP|round;
  unsigned short id; implP|id;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->signal(round, id);
  return implP.size();
}
void CkIndex_CollectiveBackbone::_marshallmessagepup_signal_marshall2(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: unsigned int round, unsigned short id*/
  PUP::fromMem implP(impl_buf);
  unsigned int round; implP|round;
  unsigned short id; implP|id;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("round");
  implDestP|round;
  if (implDestP.hasComments()) implDestP.comment("id");
  implDestP|id;
}

/* DEFS: void barrier_crossed(void);
 */
void CProxy_CollectiveBackbone::barrier_crossed(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CollectiveBackbone::__idx_barrier_crossed_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CollectiveBackbone::__idx_barrier_crossed_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CollectiveBackbone::__idx_barrier_crossed_void, impl_msg, ckGetGroupID(),0);
}
void CProxy_CollectiveBackbone::barrier_crossed(int npes, int *pes) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchMulti(CkIndex_CollectiveBackbone::__idx_barrier_crossed_void, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CollectiveBackbone::barrier_crossed(CmiGroup &grp) {
  void *impl_msg = CkAllocSysMsg();
  CkSendMsgBranchGroup(CkIndex_CollectiveBackbone::__idx_barrier_crossed_void, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CollectiveBackbone::__idx_barrier_crossed_void=0;
void CkIndex_CollectiveBackbone::_call_barrier_crossed_void(void* impl_msg,CollectiveBackbone * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->barrier_crossed();
}

/* DEFS: CollectiveBackbone(void);
 */


/* DEFS: void signal(unsigned int round, unsigned short id);
 */
void CProxySection_CollectiveBackbone::signal(unsigned int round, unsigned short id, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int round, unsigned short id
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|round;
    implP|id;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|round;
    implP|id;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CollectiveBackbone::__idx_signal_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CollectiveBackbone::__idx_signal_marshall2, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CollectiveBackbone::__idx_signal_marshall2, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void barrier_crossed(void);
 */
void CProxySection_CollectiveBackbone::barrier_crossed(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CollectiveBackbone::__idx_barrier_crossed_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CollectiveBackbone::__idx_barrier_crossed_void, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CollectiveBackbone::__idx_barrier_crossed_void, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_CollectiveBackbone::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeGroup);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,CollectiveBackbone::isIrreducible());
// REG: CollectiveBackbone(void);
  __idx_CollectiveBackbone_void = CkRegisterEp("CollectiveBackbone(void)",
     (CkCallFnPtr)_call_CollectiveBackbone_void, 0, __idx, 0);
  CkRegisterDefaultCtor(__idx, __idx_CollectiveBackbone_void);

      _registerInitCall(CollectiveBackbone::init_nb_rounds,0);

// REG: void signal(unsigned int round, unsigned short id);
  __idx_signal_marshall2 = CkRegisterEp("signal(unsigned int round, unsigned short id)",
     (CkCallFnPtr)_call_signal_marshall2, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_signal_marshall2,(CkMarshallUnpackFn)_callmarshall_signal_marshall2);
  CkRegisterMessagePupFn(__idx_signal_marshall2,(CkMessagePupFn)_marshallmessagepup_signal_marshall2);

// REG: void barrier_crossed(void);
  __idx_barrier_crossed_void = CkRegisterEp("barrier_crossed(void)",
     (CkCallFnPtr)_call_barrier_crossed_void, 0, __idx, 0);

}
#endif

#ifndef CK_TEMPLATES_ONLY
void _registerCharmCollective(void)
{
  static int _done = 0; if(_done) return; _done = 1;
/* REG: group CollectiveBackbone: IrrGroup{
CollectiveBackbone(void);
  initcall void init_nb_rounds(void);
void signal(unsigned int round, unsigned short id);
void barrier_crossed(void);
};
*/
  CkIndex_CollectiveBackbone::__register("CollectiveBackbone", sizeof(CollectiveBackbone));

}
#endif
