/* DEFS: group ManagerBackbone: IrrGroup{
ManagerBackbone(void);
void set(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid);
void set_group(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid);
void set_array(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_ManagerBackbone::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: ManagerBackbone(void);
 */

/* DEFS: void set(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid);
 */
void CProxyElement_ManagerBackbone::set(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkChareID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkChareID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ManagerBackbone::__idx_set_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_ManagerBackbone::__idx_set_marshall2, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_ManagerBackbone::__idx_set_marshall2, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void set_group(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid);
 */
void CProxyElement_ManagerBackbone::set_group(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ManagerBackbone::__idx_set_group_marshall3, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_ManagerBackbone::__idx_set_group_marshall3, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_ManagerBackbone::__idx_set_group_marshall3, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void set_array(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid);
 */
void CProxyElement_ManagerBackbone::set_array(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ManagerBackbone::__idx_set_array_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_ManagerBackbone::__idx_set_array_marshall4, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_ManagerBackbone::__idx_set_array_marshall4, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: ManagerBackbone(void);
 */
CkGroupID CProxy_ManagerBackbone::ckNew(void)
{
  void *impl_msg = CkAllocSysMsg();
  return CkCreateGroup(CkIndex_ManagerBackbone::__idx, CkIndex_ManagerBackbone::__idx_ManagerBackbone_void, impl_msg);
}
 int CkIndex_ManagerBackbone::__idx_ManagerBackbone_void=0;
void CkIndex_ManagerBackbone::_call_ManagerBackbone_void(void* impl_msg,ManagerBackbone * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  new (impl_obj) ManagerBackbone();
}

/* DEFS: void set(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid);
 */
void CProxy_ManagerBackbone::set(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkChareID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkChareID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ManagerBackbone::__idx_set_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_ManagerBackbone::__idx_set_marshall2, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_ManagerBackbone::__idx_set_marshall2, impl_msg, ckGetGroupID(),0);
}
void CProxy_ManagerBackbone::set(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkChareID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkChareID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  CkSendMsgBranchMulti(CkIndex_ManagerBackbone::__idx_set_marshall2, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_ManagerBackbone::set(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkChareID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkChareID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  CkSendMsgBranchGroup(CkIndex_ManagerBackbone::__idx_set_marshall2, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_ManagerBackbone::__idx_set_marshall2=0;
void CkIndex_ManagerBackbone::_call_set_marshall2(void* impl_msg,ManagerBackbone * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid*/
  PUP::fromMem implP(impl_buf);
  unsigned int uis; implP|uis;
  int impl_off_ui, impl_cnt_ui; 
  implP|impl_off_ui;
  implP|impl_cnt_ui;
  unsigned int ups; implP|ups;
  int impl_off_up, impl_cnt_up; 
  implP|impl_off_up;
  implP|impl_cnt_up;
  CkChareID id; implP|id;
  uint32_t rid; implP|rid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *ui=(char *)(impl_buf+impl_off_ui);
  char *up=(char *)(impl_buf+impl_off_up);
  impl_obj->set(uis, ui, ups, up, id, rid);
}
int CkIndex_ManagerBackbone::_callmarshall_set_marshall2(char* impl_buf,ManagerBackbone * impl_obj) {
  /*Unmarshall pup'd fields: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid*/
  PUP::fromMem implP(impl_buf);
  unsigned int uis; implP|uis;
  int impl_off_ui, impl_cnt_ui; 
  implP|impl_off_ui;
  implP|impl_cnt_ui;
  unsigned int ups; implP|ups;
  int impl_off_up, impl_cnt_up; 
  implP|impl_off_up;
  implP|impl_cnt_up;
  CkChareID id; implP|id;
  uint32_t rid; implP|rid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *ui=(char *)(impl_buf+impl_off_ui);
  char *up=(char *)(impl_buf+impl_off_up);
  impl_obj->set(uis, ui, ups, up, id, rid);
  return implP.size();
}
void CkIndex_ManagerBackbone::_marshallmessagepup_set_marshall2(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid*/
  PUP::fromMem implP(impl_buf);
  unsigned int uis; implP|uis;
  int impl_off_ui, impl_cnt_ui; 
  implP|impl_off_ui;
  implP|impl_cnt_ui;
  unsigned int ups; implP|ups;
  int impl_off_up, impl_cnt_up; 
  implP|impl_off_up;
  implP|impl_cnt_up;
  CkChareID id; implP|id;
  uint32_t rid; implP|rid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *ui=(char *)(impl_buf+impl_off_ui);
  char *up=(char *)(impl_buf+impl_off_up);
  if (implDestP.hasComments()) implDestP.comment("uis");
  implDestP|uis;
  if (implDestP.hasComments()) implDestP.comment("ui");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*ui))<impl_cnt_ui;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|ui[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("ups");
  implDestP|ups;
  if (implDestP.hasComments()) implDestP.comment("up");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*up))<impl_cnt_up;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|up[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("id");
  implDestP|id;
  if (implDestP.hasComments()) implDestP.comment("rid");
  implDestP|rid;
}

/* DEFS: void set_group(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid);
 */
void CProxy_ManagerBackbone::set_group(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ManagerBackbone::__idx_set_group_marshall3, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_ManagerBackbone::__idx_set_group_marshall3, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_ManagerBackbone::__idx_set_group_marshall3, impl_msg, ckGetGroupID(),0);
}
void CProxy_ManagerBackbone::set_group(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  CkSendMsgBranchMulti(CkIndex_ManagerBackbone::__idx_set_group_marshall3, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_ManagerBackbone::set_group(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  CkSendMsgBranchGroup(CkIndex_ManagerBackbone::__idx_set_group_marshall3, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_ManagerBackbone::__idx_set_group_marshall3=0;
void CkIndex_ManagerBackbone::_call_set_group_marshall3(void* impl_msg,ManagerBackbone * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid*/
  PUP::fromMem implP(impl_buf);
  unsigned int uis; implP|uis;
  int impl_off_ui, impl_cnt_ui; 
  implP|impl_off_ui;
  implP|impl_cnt_ui;
  unsigned int ups; implP|ups;
  int impl_off_up, impl_cnt_up; 
  implP|impl_off_up;
  implP|impl_cnt_up;
  CkGroupID id; implP|id;
  uint32_t rid; implP|rid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *ui=(char *)(impl_buf+impl_off_ui);
  char *up=(char *)(impl_buf+impl_off_up);
  impl_obj->set_group(uis, ui, ups, up, id, rid);
}
int CkIndex_ManagerBackbone::_callmarshall_set_group_marshall3(char* impl_buf,ManagerBackbone * impl_obj) {
  /*Unmarshall pup'd fields: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid*/
  PUP::fromMem implP(impl_buf);
  unsigned int uis; implP|uis;
  int impl_off_ui, impl_cnt_ui; 
  implP|impl_off_ui;
  implP|impl_cnt_ui;
  unsigned int ups; implP|ups;
  int impl_off_up, impl_cnt_up; 
  implP|impl_off_up;
  implP|impl_cnt_up;
  CkGroupID id; implP|id;
  uint32_t rid; implP|rid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *ui=(char *)(impl_buf+impl_off_ui);
  char *up=(char *)(impl_buf+impl_off_up);
  impl_obj->set_group(uis, ui, ups, up, id, rid);
  return implP.size();
}
void CkIndex_ManagerBackbone::_marshallmessagepup_set_group_marshall3(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid*/
  PUP::fromMem implP(impl_buf);
  unsigned int uis; implP|uis;
  int impl_off_ui, impl_cnt_ui; 
  implP|impl_off_ui;
  implP|impl_cnt_ui;
  unsigned int ups; implP|ups;
  int impl_off_up, impl_cnt_up; 
  implP|impl_off_up;
  implP|impl_cnt_up;
  CkGroupID id; implP|id;
  uint32_t rid; implP|rid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *ui=(char *)(impl_buf+impl_off_ui);
  char *up=(char *)(impl_buf+impl_off_up);
  if (implDestP.hasComments()) implDestP.comment("uis");
  implDestP|uis;
  if (implDestP.hasComments()) implDestP.comment("ui");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*ui))<impl_cnt_ui;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|ui[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("ups");
  implDestP|ups;
  if (implDestP.hasComments()) implDestP.comment("up");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*up))<impl_cnt_up;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|up[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("id");
  implDestP|id;
  if (implDestP.hasComments()) implDestP.comment("rid");
  implDestP|rid;
}

/* DEFS: void set_array(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid);
 */
void CProxy_ManagerBackbone::set_array(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ManagerBackbone::__idx_set_array_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_ManagerBackbone::__idx_set_array_marshall4, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_ManagerBackbone::__idx_set_array_marshall4, impl_msg, ckGetGroupID(),0);
}
void CProxy_ManagerBackbone::set_array(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  CkSendMsgBranchMulti(CkIndex_ManagerBackbone::__idx_set_array_marshall4, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_ManagerBackbone::set_array(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  CkSendMsgBranchGroup(CkIndex_ManagerBackbone::__idx_set_array_marshall4, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_ManagerBackbone::__idx_set_array_marshall4=0;
void CkIndex_ManagerBackbone::_call_set_array_marshall4(void* impl_msg,ManagerBackbone * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid*/
  PUP::fromMem implP(impl_buf);
  unsigned int uis; implP|uis;
  int impl_off_ui, impl_cnt_ui; 
  implP|impl_off_ui;
  implP|impl_cnt_ui;
  unsigned int ups; implP|ups;
  int impl_off_up, impl_cnt_up; 
  implP|impl_off_up;
  implP|impl_cnt_up;
  CkArrayID id; implP|id;
  uint32_t rid; implP|rid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *ui=(char *)(impl_buf+impl_off_ui);
  char *up=(char *)(impl_buf+impl_off_up);
  impl_obj->set_array(uis, ui, ups, up, id, rid);
}
int CkIndex_ManagerBackbone::_callmarshall_set_array_marshall4(char* impl_buf,ManagerBackbone * impl_obj) {
  /*Unmarshall pup'd fields: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid*/
  PUP::fromMem implP(impl_buf);
  unsigned int uis; implP|uis;
  int impl_off_ui, impl_cnt_ui; 
  implP|impl_off_ui;
  implP|impl_cnt_ui;
  unsigned int ups; implP|ups;
  int impl_off_up, impl_cnt_up; 
  implP|impl_off_up;
  implP|impl_cnt_up;
  CkArrayID id; implP|id;
  uint32_t rid; implP|rid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *ui=(char *)(impl_buf+impl_off_ui);
  char *up=(char *)(impl_buf+impl_off_up);
  impl_obj->set_array(uis, ui, ups, up, id, rid);
  return implP.size();
}
void CkIndex_ManagerBackbone::_marshallmessagepup_set_array_marshall4(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid*/
  PUP::fromMem implP(impl_buf);
  unsigned int uis; implP|uis;
  int impl_off_ui, impl_cnt_ui; 
  implP|impl_off_ui;
  implP|impl_cnt_ui;
  unsigned int ups; implP|ups;
  int impl_off_up, impl_cnt_up; 
  implP|impl_off_up;
  implP|impl_cnt_up;
  CkArrayID id; implP|id;
  uint32_t rid; implP|rid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *ui=(char *)(impl_buf+impl_off_ui);
  char *up=(char *)(impl_buf+impl_off_up);
  if (implDestP.hasComments()) implDestP.comment("uis");
  implDestP|uis;
  if (implDestP.hasComments()) implDestP.comment("ui");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*ui))<impl_cnt_ui;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|ui[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("ups");
  implDestP|ups;
  if (implDestP.hasComments()) implDestP.comment("up");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*up))<impl_cnt_up;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|up[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("id");
  implDestP|id;
  if (implDestP.hasComments()) implDestP.comment("rid");
  implDestP|rid;
}

/* DEFS: ManagerBackbone(void);
 */

/* DEFS: void set(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid);
 */
void CProxySection_ManagerBackbone::set(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkChareID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkChareID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ManagerBackbone::__idx_set_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_ManagerBackbone::__idx_set_marshall2, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_ManagerBackbone::__idx_set_marshall2, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void set_group(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid);
 */
void CProxySection_ManagerBackbone::set_group(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ManagerBackbone::__idx_set_group_marshall3, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_ManagerBackbone::__idx_set_group_marshall3, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_ManagerBackbone::__idx_set_group_marshall3, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void set_array(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid);
 */
void CProxySection_ManagerBackbone::set_array(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_ui, impl_cnt_ui;
  impl_off_ui=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_ui=sizeof(char)*(uis));
  int impl_off_up, impl_cnt_up;
  impl_off_up=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_up=sizeof(char)*(ups));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|uis;
    implP|impl_off_ui;
    implP|impl_cnt_ui;
    implP|ups;
    implP|impl_off_up;
    implP|impl_cnt_up;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)id;
    //Have to cast away const-ness to get pup routine
    implP|(uint32_t &)rid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_ui,ui,impl_cnt_ui);
  memcpy(impl_buf+impl_off_up,up,impl_cnt_up);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ManagerBackbone::__idx_set_array_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_ManagerBackbone::__idx_set_array_marshall4, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_ManagerBackbone::__idx_set_array_marshall4, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_ManagerBackbone::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeGroup);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,ManagerBackbone::isIrreducible());
// REG: ManagerBackbone(void);
  __idx_ManagerBackbone_void = CkRegisterEp("ManagerBackbone(void)",
     (CkCallFnPtr)_call_ManagerBackbone_void, 0, __idx, 0);
  CkRegisterDefaultCtor(__idx, __idx_ManagerBackbone_void);

// REG: void set(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid);
  __idx_set_marshall2 = CkRegisterEp("set(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid)",
     (CkCallFnPtr)_call_set_marshall2, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_set_marshall2,(CkMarshallUnpackFn)_callmarshall_set_marshall2);
  CkRegisterMessagePupFn(__idx_set_marshall2,(CkMessagePupFn)_marshallmessagepup_set_marshall2);

// REG: void set_group(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid);
  __idx_set_group_marshall3 = CkRegisterEp("set_group(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid)",
     (CkCallFnPtr)_call_set_group_marshall3, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_set_group_marshall3,(CkMarshallUnpackFn)_callmarshall_set_group_marshall3);
  CkRegisterMessagePupFn(__idx_set_group_marshall3,(CkMessagePupFn)_marshallmessagepup_set_group_marshall3);

// REG: void set_array(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid);
  __idx_set_array_marshall4 = CkRegisterEp("set_array(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid)",
     (CkCallFnPtr)_call_set_array_marshall4, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_set_array_marshall4,(CkMarshallUnpackFn)_callmarshall_set_array_marshall4);
  CkRegisterMessagePupFn(__idx_set_array_marshall4,(CkMessagePupFn)_marshallmessagepup_set_array_marshall4);

}
#endif

#ifndef CK_TEMPLATES_ONLY
void _registercharmmanager(void)
{
  static int _done = 0; if(_done) return; _done = 1;
/* REG: group ManagerBackbone: IrrGroup{
ManagerBackbone(void);
void set(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkChareID &id, const uint32_t &rid);
void set_group(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkGroupID &id, const uint32_t &rid);
void set_array(unsigned int uis, const char *ui, unsigned int ups, const char *up, const CkArrayID &id, const uint32_t &rid);
};
*/
  CkIndex_ManagerBackbone::__register("ManagerBackbone", sizeof(ManagerBackbone));

}
#endif
